/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbDerivation;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class ToDerivation
extends Transformation
implements Cloneable {
    private static final String INFO = "Derivation";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToDerivation.GetDerivations(in, conn, trie, restrictFlag, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToDerivation.GetTestStr(args, "help");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = false;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, minTrieStemLength);
            if (conn != null) {
                outs = ToDerivation.Mutate(in, conn, trie, 1, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToDerivation.PrintResults(in, outs);
    }

    protected static Vector<LexItem> GetDerivations(LexItem in, Connection conn, RamTrie trie, int restrictFlag, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String inStr = in.GetSourceTerm();
        Vector<LexItem> outs = new Vector<LexItem>();
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        try {
            Vector<DerivationRecord> factList = DbDerivation.GetDerivations(inStr, conn);
            for (int i = 0; i < factList.size(); ++i) {
                DerivationRecord record = factList.elementAt(i);
                String term = record.GetTarget();
                long curCat = record.GetSourceCat();
                if (!InputFilter.IsLegal(inCat, curCat)) continue;
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = infoStr + " (FACT)";
                }
                if (mutateFlag) {
                    mutate = "FACT" + GlobalBehavior.GetFieldSeparator() + record.GetString(GlobalBehavior.GetFieldSeparator());
                }
                LexItem temp = ToDerivation.UpdateLexItem(in, term, 18, record.GetTargetCat(), Inflection.GetBitValue(0), details, mutate);
                outs.addElement(temp);
            }
            Vector<RuleResult> ruleList = trie.GetDerivationsByRules(inStr, inCat, inInfl, true);
            for (int i = 0; i < ruleList.size(); ++i) {
                RuleResult record = ruleList.elementAt(i);
                String term = record.GetOutTerm();
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = infoStr + " (RULE|" + record.GetRuleString() + ")";
                }
                if (mutateFlag) {
                    mutate = "RULE" + GlobalBehavior.GetFieldSeparator() + record.GetRuleString() + GlobalBehavior.GetFieldSeparator();
                }
                LexItem temp = ToDerivation.UpdateLexItem(in, term, 18, Category.ToValue(record.GetOutCategory()), Inflection.ToValue(record.GetOutInflection()), details, mutate);
                outs.addElement(temp);
            }
            outs = ToDerivation.RestrictDerivations(outs, conn, restrictFlag);
        }
        catch (SQLException e) {
            System.err.println("** Error: Sql Exception in ToDerivation Flow.");
        }
        LexItemComparator lc = new LexItemComparator();
        lc.SetRule(10);
        Collections.sort(outs, lc);
        return outs;
    }

    protected static Vector<LexItem> RestrictDerivations(Vector<LexItem> in, Connection conn, int restrictFlag) throws SQLException {
        Vector<Object> out = new Vector<LexItem>();
        switch (restrictFlag) {
            case 2: {
                out = ToDerivation.VerifyDerivationsFromLvg(in, conn);
                if (out.size() != 0) break;
                out.addAll(in);
                break;
            }
            case 3: {
                out.addAll(in);
                break;
            }
            default: {
                out = ToDerivation.VerifyDerivationsFromLvg(in, conn);
            }
        }
        return out;
    }

    private static Vector<LexItem> VerifyDerivationsFromLvg(Vector<LexItem> in, Connection conn) throws SQLException {
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < in.size(); ++i) {
            LexItem cur = in.elementAt(i);
            String derivation = cur.GetTargetTerm();
            if (!DbUninflection.IsExistUninflectedTerm(derivation, conn)) continue;
            out.addElement(cur);
        }
        return out;
    }
}

