/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariants;
import gov.nih.nlm.nls.lvg.Flows.ToFruitfulVariantsDb;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFruitfulEnhanced
extends Transformation
implements Cloneable {
    private static final String INFO = "Fruitful Variants, Enhanced";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trieI, RamTrie trieD, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> outs = ToFruitfulVariantsDb.Mutate(in, conn, detailsFlag, mutateFlag);
        if (outs.size() == 0) {
            outs = ToFruitfulVariants.Mutate(in, conn, trieI, trieD, detailsFlag, mutateFlag);
        }
        for (int i = 0; i < outs.size(); ++i) {
            LexItem temp = outs.elementAt(i);
            temp.SetFlowHistory(Flow.GetBitName(49, 1));
        }
        return outs;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToFruitfulEnhanced.GetTestStr(args, "neurological");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            RamTrie trieI = new RamTrie(true, minTermLen, lvgDir, 0);
            RamTrie trieD = new RamTrie(false, minTermLen, lvgDir, minTrieStemLength);
            if (conn != null) {
                outs = ToFruitfulEnhanced.Mutate(in, conn, trieI, trieD, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToFruitfulEnhanced.PrintResults(in, outs);
    }
}

