/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbSynonym;
import gov.nih.nlm.nls.lvg.Db.SynonymRecord;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToRecursiveSynonyms
extends Transformation
implements Cloneable {
    private static final String INFO = "Recursive Synonyms";
    private static Vector<LexItem> synonyms_ = new Vector();

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag, boolean detailFlowFlag) {
        ToRecursiveSynonyms.SetSynonymVector(in);
        ToRecursiveSynonyms.GetRecursiveSynonyms(in, conn, INFO, true, detailsFlag, mutateFlag, null);
        ToRecursiveSynonyms.CleanSynonymVector(detailFlowFlag);
        Vector<LexItem> out = ToRecursiveSynonyms.GetSynonymVector();
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToRecursiveSynonyms.GetTestStr(args, "chest");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToRecursiveSynonyms.Mutate(in, conn, true, true, false);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToRecursiveSynonyms.PrintResults(in, outs);
    }

    private static void GetRecursiveSynonyms(LexItem in, Connection conn, String infoStr, boolean topLevel, boolean detailsFlag, boolean mutateFlag, String rFlowHistory) {
        StringBuffer buffer = new StringBuffer();
        if (rFlowHistory == null) {
            String prevHistory = in.GetFlowHistory();
            rFlowHistory = new String();
            if (prevHistory == null) {
                rFlowHistory = new String();
            } else {
                buffer.append(prevHistory);
                buffer.append("+");
            }
        }
        buffer.append(Flow.GetBitName(28, 1));
        rFlowHistory = rFlowHistory + buffer.toString();
        Vector<LexItem> temp = ToRecursiveSynonyms.GetSynonyms(in, conn, infoStr, topLevel, detailsFlag, mutateFlag, rFlowHistory);
        for (int i = 0; i < temp.size(); ++i) {
            LexItem tempRec = temp.elementAt(i);
            boolean existed = false;
            for (int j = 0; j < synonyms_.size(); ++j) {
                LexItem orgRec = synonyms_.elementAt(j);
                if (j == 0) {
                    if (!orgRec.GetTargetTerm().equals(tempRec.GetTargetTerm())) continue;
                    existed = true;
                    break;
                }
                if (!orgRec.GetTargetTerm().equals(tempRec.GetTargetTerm()) || orgRec.GetTargetCategory().GetValue() != tempRec.GetTargetCategory().GetValue()) continue;
                existed = true;
                break;
            }
            if (existed) continue;
            synonyms_.addElement(tempRec);
            LexItem newLexItem = LexItem.TargetToSource(tempRec);
            ToRecursiveSynonyms.GetRecursiveSynonyms(newLexItem, conn, infoStr, false, detailsFlag, mutateFlag, rFlowHistory);
        }
    }

    private static void SetSynonymVector(LexItem in) {
        synonyms_.removeAllElements();
        LexItem lexItem = new LexItem(in, true);
        lexItem.SetTargetTerm(in.GetSourceTerm());
        synonyms_.addElement(lexItem);
    }

    private static void CleanSynonymVector(boolean detailFlowFlag) {
        synonyms_.removeElementAt(0);
        if (!detailFlowFlag) {
            String flowName = Flow.GetBitName(35, 1);
            for (int i = 0; i < synonyms_.size(); ++i) {
                LexItem temp = synonyms_.elementAt(i);
                temp.SetFlowHistory(flowName);
            }
        }
    }

    private static Vector<LexItem> GetSynonymVector() {
        return synonyms_;
    }

    private static Vector<LexItem> GetSynonyms(LexItem in, Connection conn, String infoStr, boolean appendFlowHistory, boolean detailsFlag, boolean mutateFlag, String rFlowHistory) {
        String inStr = in.GetSourceTerm();
        Vector<LexItem> out = new Vector<LexItem>();
        String strippedStr = ToStripPunctuation.StripPunctuation(inStr);
        String lcStrippedStr = strippedStr.toLowerCase();
        String flowName = rFlowHistory;
        try {
            Vector<SynonymRecord> records = DbSynonym.GetSynonyms(lcStrippedStr, conn);
            long inCat = in.GetSourceCategory().GetValue();
            for (int i = 0; i < records.size(); ++i) {
                SynonymRecord record = records.elementAt(i);
                String term = record.GetSynonym();
                long curCat = record.GetCat1();
                if (!InputFilter.IsLegal(inCat, curCat)) continue;
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = infoStr;
                }
                if (mutateFlag) {
                    String fs = GlobalBehavior.GetFieldSeparator();
                    mutate = "FACT" + fs + record.GetKeyForm() + fs + Category.ToName(record.GetCat1()) + fs + record.GetSynonym() + fs + Category.ToName(record.GetCat2()) + fs + rFlowHistory + fs;
                }
                LexItem temp = ToRecursiveSynonyms.UpdateLexItem(in, term, flowName, record.GetCat2(), Inflection.GetBitValue(0), details, mutate, false);
                out.addElement(temp);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return out;
    }
}

