/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.DbUninflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Util.LvgComparator;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToUninflectWords
extends Transformation {
    private static final String INFO = "Uninflect Words";

    public static Vector<LexItem> Mutate(LexItem in, int maxTerm, Connection conn, RamTrie trie, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<String> termList = ToUninflectWords.UninflectWords(in.GetSourceTerm(), conn, trie, maxTerm);
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < termList.size(); ++i) {
            String term = termList.elementAt(i);
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                mutate = Transformation.NO_MUTATE_INFO;
            }
            LexItem temp = ToUninflectWords.UpdateLexItem(in, term, 8, 2047L, Inflection.GetBitValue(0), details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToUninflectWords.GetTestStr(args, "Left Data");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int maxTerm = Integer.parseInt(conf.GetConfiguration("MAX_RULE_UNINFLECTED_TERMS"));
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToUninflectWords.Mutate(in, maxTerm, conn, trie, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToUninflectWords.PrintResults(in, outs);
    }

    protected static Vector<String> FormCombinations(Vector<Vector<String>> inList) {
        Vector<String> out = new Vector<String>();
        for (int i = 0; i < inList.size(); ++i) {
            int j;
            int index = inList.size() - 1 - i;
            Vector<String> curList = inList.elementAt(index);
            int curSize = curList.size();
            if (i == 0) {
                out.addAll(curList);
                continue;
            }
            Vector<String> temp = new Vector<String>(out);
            int tempSize = temp.size();
            for (j = 1; j < curSize; ++j) {
                out.addAll(temp);
            }
            for (j = 0; j < out.size(); ++j) {
                String curStr = null;
                if (curSize > 0) {
                    curStr = curList.elementAt(j / tempSize);
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(curStr);
                buffer.append(" ");
                buffer.append(out.elementAt(j));
                String newStr = buffer.toString();
                out.setElementAt(newStr, j);
            }
        }
        return out;
    }

    private static Vector<String> UninflectWords(String inStr, Connection conn, RamTrie trie, int maxTerm) {
        String delim = " \t-({[)}]_!@#%&*\\:;'\",.?/~+=|<>$`^";
        StringTokenizer buf = new StringTokenizer(inStr, delim);
        Vector<String> out = new Vector();
        Vector<Vector<String>> strList = new Vector<Vector<String>>();
        long totalNum = 1L;
        while (buf.hasMoreTokens()) {
            String curStr = buf.nextToken();
            try {
                Vector<InflectionRecord> factList = DbUninflection.GetUninflections(curStr, conn);
                Vector<String> wordList = new Vector<String>();
                for (int i = 0; i < factList.size(); ++i) {
                    InflectionRecord record = factList.elementAt(i);
                    String uninflectedTerm = record.GetUninflectedTerm();
                    String uninflectedTermLc = uninflectedTerm.toLowerCase();
                    if (wordList.contains(uninflectedTermLc)) continue;
                    wordList.addElement(uninflectedTermLc);
                }
                if (factList.size() == 0) {
                    Vector<RuleResult> ruleList = trie.GetUninflectedTermsByRules(curStr, 2047L, 0xFFFFFFL, true);
                    for (int i = 0; i < ruleList.size(); ++i) {
                        RuleResult result = ruleList.elementAt(i);
                        String uninflectedTerm = result.GetOutTerm();
                        String uninflectedTermLc = uninflectedTerm.toLowerCase();
                        if (wordList.contains(uninflectedTermLc) || DbInflection.IsExistInflectedTerm(uninflectedTerm, conn)) continue;
                        wordList.addElement(uninflectedTermLc);
                    }
                }
                if ((totalNum *= (long)wordList.size()) > (long)maxTerm) {
                    out.removeAllElements();
                    out.addElement(inStr);
                    return out;
                }
                strList.addElement(wordList);
            }
            catch (Exception e) {
                break;
            }
        }
        out = ToUninflectWords.FormCombinations(strList);
        if (strList.size() >= 1) {
            LvgComparator lc = new LvgComparator();
            lc.SetLengthFlag(true);
            lc.SetCase(false);
            Collections.sort(out, lc);
        }
        return out;
    }
}

