/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.ProtocolException;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.io.HttpDataReceiver;

public class Header {
    private final String name;
    private final String value;

    public Header(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append(this.name);
        buffer.append(": ");
        if (this.value != null) {
            buffer.append(this.value);
        }
        return buffer.toString();
    }

    public HeaderElement[] getElements() {
        if (this.value != null) {
            return HeaderElement.parseAll(this.value);
        }
        return new HeaderElement[0];
    }

    public static void format(CharArrayBuffer buffer, Header header) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (header == null) {
            throw new IllegalArgumentException("Header may not be null");
        }
        buffer.append(header.getName());
        buffer.append(": ");
        if (header.getValue() != null) {
            buffer.append(header.getValue());
        }
    }

    public static String format(Header header) {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        Header.format(buffer, header);
        return buffer.toString();
    }

    public static Header[] parseAll(HttpDataReceiver datareceiver) throws HttpException, IOException {
        int i;
        ArrayList<CharArrayBuffer> headerLines = new ArrayList<CharArrayBuffer>();
        CharArrayBuffer current = null;
        CharArrayBuffer previous = null;
        while (true) {
            if (current == null) {
                current = new CharArrayBuffer(64);
            } else {
                current.clear();
            }
            int l = datareceiver.readLine(current);
            if (l == -1 || current.length() < 1) break;
            if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                char ch;
                for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                }
                previous.append(' ');
                previous.append(current, i, current.length() - i);
                continue;
            }
            headerLines.add(current);
            previous = current;
            current = null;
        }
        Header[] headers = new Header[headerLines.size()];
        for (i = 0; i < headerLines.size(); ++i) {
            CharArrayBuffer buffer = (CharArrayBuffer)headerLines.get(i);
            int colon = buffer.indexOf(58);
            if (colon == -1) {
                throw new ProtocolException("Invalid header: " + buffer.toString());
            }
            String s = buffer.substringTrimmed(0, colon);
            if (s.equals("")) {
                throw new ProtocolException("Invalid header: " + buffer.toString());
            }
            headers[i] = new BufferedHeader(s, buffer, colon + 1);
        }
        return headers;
    }

    static class BufferedHeader
    extends Header {
        private final CharArrayBuffer buffer;
        private final int posValue;

        private BufferedHeader(String name, CharArrayBuffer buffer, int posValue) {
            super(name, null);
            this.buffer = buffer;
            this.posValue = posValue;
        }

        public String getValue() {
            return this.buffer.substringTrimmed(this.posValue, this.buffer.length());
        }

        public HeaderElement[] getElements() {
            return HeaderElement.parseAll(this.buffer, this.posValue, this.buffer.length());
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

