/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.util.LangUtils;

public class HeaderElement {
    private final String name;
    private final String value;
    private final NameValuePair[] parameters;

    private HeaderElement(NameValuePair[] nvps) {
        if (nvps.length > 0) {
            NameValuePair nvp = nvps[0];
            this.name = nvp.getName();
            this.value = nvp.getValue();
            int len = nvps.length - 1;
            if (len > 0) {
                this.parameters = new NameValuePair[len];
                System.arraycopy(nvps, 1, this.parameters, 0, len);
            } else {
                this.parameters = new NameValuePair[0];
            }
        } else {
            this.name = "";
            this.value = null;
            this.parameters = new NameValuePair[0];
        }
    }

    public HeaderElement(String name, String value, NameValuePair[] parameters) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name;
        this.value = value;
        this.parameters = parameters != null ? (NameValuePair[])parameters.clone() : new NameValuePair[0];
    }

    public HeaderElement(String name, String value) {
        this(name, value, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public NameValuePair[] getParameters() {
        return (NameValuePair[])this.parameters.clone();
    }

    public static final HeaderElement[] parseAll(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        ArrayList<HeaderElement> elements = new ArrayList<HeaderElement>();
        int from = indexFrom;
        boolean qouted = false;
        boolean escaped = false;
        for (int cur = indexFrom; cur < indexTo; ++cur) {
            char ch = buffer.charAt(cur);
            if (ch == '\"' && !escaped) {
                qouted = !qouted;
            }
            HeaderElement element = null;
            if (!qouted && ch == ',') {
                element = HeaderElement.parse(buffer, from, cur);
                from = cur + 1;
            } else if (cur == indexTo - 1) {
                element = HeaderElement.parse(buffer, from, indexTo);
            }
            if (element != null && !element.getName().equals("")) {
                elements.add(element);
            }
            escaped = escaped ? false : qouted && ch == '\\';
        }
        return elements.toArray(new HeaderElement[elements.size()]);
    }

    public static final HeaderElement[] parseAll(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return HeaderElement.parseAll(buffer, 0, buffer.length());
    }

    public static HeaderElement parse(CharArrayBuffer buffer, int indexFrom, int indexTo) {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        NameValuePair[] nvps = NameValuePair.parseAll(buffer, indexFrom, indexTo);
        return new HeaderElement(nvps);
    }

    public static final HeaderElement parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return HeaderElement.parse(buffer, 0, buffer.length());
    }

    public static void format(CharArrayBuffer buffer, HeaderElement element) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Header element may not be null");
        }
        buffer.append(element.getName());
        if (element.getValue() != null) {
            buffer.append("=");
            buffer.append(element.getValue());
        }
        NameValuePair[] params = element.getParameters();
        for (int i = 0; i < params.length; ++i) {
            buffer.append("; ");
            NameValuePair.format(buffer, params[i], false);
        }
    }

    public static String format(HeaderElement element) {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        HeaderElement.format(buffer, element);
        return buffer.toString();
    }

    public static void formatAll(CharArrayBuffer buffer, HeaderElement[] elements) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Array of header element may not be null");
        }
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            HeaderElement.format(buffer, elements[i]);
        }
    }

    public static String formatAll(HeaderElement[] elements) {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        HeaderElement.formatAll(buffer, elements);
        return buffer.toString();
    }

    public NameValuePair getParameterByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        NameValuePair found = null;
        for (int i = 0; i < this.parameters.length; ++i) {
            NameValuePair current = this.parameters[i];
            if (!current.getName().equalsIgnoreCase(name)) continue;
            found = current;
            break;
        }
        return found;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof HeaderElement) {
            HeaderElement that = (HeaderElement)object;
            return this.name.equals(that.name) && LangUtils.equals(this.value, that.value) && LangUtils.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.name);
        hash = LangUtils.hashCode(hash, this.value);
        for (int i = 0; i < this.parameters.length; ++i) {
            hash = LangUtils.hashCode(hash, this.parameters[i]);
        }
        return hash;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append(this.name);
        if (this.value != null) {
            buffer.append("=");
            buffer.append(this.value);
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            buffer.append("; ");
            buffer.append(this.parameters[i]);
        }
        return buffer.toString();
    }
}

