/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http;

import org.apache.http.Scheme;
import org.apache.http.io.CharArrayBuffer;
import org.apache.http.util.LangUtils;

public class HttpHost {
    private String hostname = null;
    private int port = -1;
    private Scheme scheme = null;

    public HttpHost(String hostname, int port, Scheme scheme) {
        if (hostname == null) {
            throw new IllegalArgumentException("Host name may not be null");
        }
        if (scheme == null) {
            throw new IllegalArgumentException("Protocol may not be null");
        }
        this.hostname = hostname;
        this.scheme = scheme;
        this.port = port >= 0 ? port : this.scheme.getDefaultPort();
    }

    public HttpHost(String hostname, int port) {
        this(hostname, port, Scheme.getScheme("http"));
    }

    public HttpHost(String hostname) {
        this(hostname, -1, Scheme.getScheme("http"));
    }

    public HttpHost(HttpHost httphost) {
        this.hostname = httphost.hostname;
        this.port = httphost.port;
        this.scheme = httphost.scheme;
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public String toURI() {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append(this.scheme.getName());
        buffer.append("://");
        buffer.append(this.hostname);
        if (this.port != this.scheme.getDefaultPort()) {
            buffer.append(':');
            buffer.append(Integer.toString(this.port));
        }
        return buffer.toString();
    }

    public String toHostString() {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append(this.hostname);
        if (this.port != this.scheme.getDefaultPort()) {
            buffer.append(':');
            buffer.append(Integer.toString(this.port));
        }
        return buffer.toString();
    }

    public String toString() {
        return this.toURI();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof HttpHost) {
            HttpHost that = (HttpHost)obj;
            return this.hostname.equalsIgnoreCase(that.hostname) && this.port == that.port && this.scheme.equals(that.scheme);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = LangUtils.hashCode(hash, this.hostname.toUpperCase());
        hash = LangUtils.hashCode(hash, this.port);
        hash = LangUtils.hashCode(hash, this.scheme);
        return hash;
    }
}

