/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.http.HttpHost;
import org.apache.http.HttpProxyConnection;
import org.apache.http.ProxyHost;
import org.apache.http.Scheme;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.io.SecureSocketFactory;
import org.apache.http.io.SocketFactory;
import org.apache.http.params.HttpParams;

public class DefaultHttpProxyConnection
extends DefaultHttpClientConnection
implements HttpProxyConnection {
    private volatile HttpHost tunneltarget = null;
    private volatile boolean secure = false;

    public DefaultHttpProxyConnection(ProxyHost proxyhost, InetAddress localAddress) {
        super(proxyhost, localAddress);
    }

    public DefaultHttpProxyConnection(ProxyHost proxyhost) {
        this(proxyhost, null);
    }

    public void close() throws IOException {
        this.tunneltarget = null;
        this.secure = false;
        super.close();
    }

    public void tunnelTo(HttpHost targetHost, HttpParams params) throws IOException {
        if (targetHost == null) {
            throw new IllegalArgumentException("Target host may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        if (this.tunneltarget != null) {
            throw new IllegalStateException("Secure tunnel to " + this.tunneltarget + " is already active");
        }
        this.assertOpen();
        Scheme protocol = targetHost.getScheme();
        SocketFactory socketfactory = protocol.getSocketFactory();
        if (socketfactory instanceof SecureSocketFactory) {
            Socket socket = ((SecureSocketFactory)socketfactory).createSocket(this.socket, targetHost.getHostName(), targetHost.getPort(), true);
            this.bind(socket, params);
            this.secure = true;
        } else {
            this.secure = false;
        }
        this.tunneltarget = targetHost;
    }

    public HttpHost getTunnelTarget() {
        return this.tunneltarget;
    }

    public boolean isTunnelActive() {
        return this.tunneltarget != null;
    }

    public boolean isSecure() {
        return this.secure;
    }
}

