/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.params;

import org.apache.http.params.HttpParams;

public final class HttpConnectionParams {
    public static final String SO_TIMEOUT = "http.socket.timeout";
    public static final String TCP_NODELAY = "http.tcp.nodelay";
    public static final String SOCKET_BUFFER_SIZE = "http.socket.buffer-size";
    public static final String SO_LINGER = "http.socket.linger";
    public static final String CONNECTION_TIMEOUT = "http.connection.timeout";
    public static final String STALE_CONNECTION_CHECK = "http.connection.stalecheck";

    private HttpConnectionParams() {
    }

    public static int getSoTimeout(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getIntParameter(SO_TIMEOUT, 0);
    }

    public static void setSoTimeout(HttpParams params, int timeout) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setIntParameter(SO_TIMEOUT, timeout);
    }

    public static boolean getTcpNoDelay(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getBooleanParameter(TCP_NODELAY, true);
    }

    public static void setTcpNoDelay(HttpParams params, boolean value) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setBooleanParameter(TCP_NODELAY, value);
    }

    public static int getSocketBufferSize(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getIntParameter(SOCKET_BUFFER_SIZE, -1);
    }

    public static void setSocketBufferSize(HttpParams params, int size) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setIntParameter(SOCKET_BUFFER_SIZE, size);
    }

    public static int getLinger(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getIntParameter(SO_LINGER, -1);
    }

    public static void setLinger(HttpParams params, int value) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setIntParameter(SO_LINGER, value);
    }

    public static int getConnectionTimeout(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getIntParameter(CONNECTION_TIMEOUT, 0);
    }

    public static void setConnectionTimeout(HttpParams params, int timeout) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setIntParameter(CONNECTION_TIMEOUT, timeout);
    }

    public static boolean isStaleCheckingEnabled(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        return params.getBooleanParameter(STALE_CONNECTION_CHECK, true);
    }

    public static void setStaleCheckingEnabled(HttpParams params, boolean value) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        params.setBooleanParameter(STALE_CONNECTION_CHECK, value);
    }
}

