/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.protocol.HttpContext;

public class ResponseContent
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (response.containsHeader("Transfer-Encoding")) {
            throw new ProtocolException("Transfer-encoding header already present");
        }
        if (response.containsHeader("Content-Length")) {
            throw new ProtocolException("Content-Length header already present");
        }
        HttpVersion ver = response.getStatusLine().getHttpVersion();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long len = entity.getContentLength();
            if (entity.isChunked() && ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                response.addHeader(new Header("Transfer-Encoding", "chunked"));
            } else if (len >= 0L) {
                response.addHeader(new Header("Content-Length", Long.toString(entity.getContentLength())));
            }
            if (entity.getContentType() != null) {
                response.setHeader(entity.getContentType());
            }
            if (entity.getContentEncoding() != null) {
                response.setHeader(entity.getContentEncoding());
            }
        }
    }
}

