/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.nio.util.ContentInputBuffer;

class ContentInputStream
extends InputStream {
    private final ContentInputBuffer buffer;

    public ContentInputStream(ContentInputBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Input buffer may not be null");
        }
        this.buffer = buffer;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.buffer.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            return 0;
        }
        return this.buffer.read(b, 0, b.length);
    }

    public int read() throws IOException {
        return this.buffer.read();
    }
}

