/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolException;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.params.HttpNIOParams;
import org.apache.http.nio.protocol.BufferedContent;
import org.apache.http.nio.protocol.ContentOutputStream;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.SharedInputBuffer;
import org.apache.http.nio.util.SharedOutputBuffer;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExecutionContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.util.EncodingUtils;
import org.apache.http.util.concurrent.Executor;

public class ThrottlingHttpServiceHandler
implements NHttpServiceHandler {
    private static final String CONN_STATE = "http.nio.conn-state";
    private HttpParams params;
    private HttpProcessor httpProcessor;
    private HttpResponseFactory responseFactory;
    private ConnectionReuseStrategy connStrategy;
    private HttpRequestHandlerResolver handlerResolver;
    private HttpExpectationVerifier expectationVerifier;
    private EventListener eventListener;
    private Executor executor;

    public ThrottlingHttpServiceHandler(HttpProcessor httpProcessor, HttpResponseFactory responseFactory, ConnectionReuseStrategy connStrategy, Executor executor, HttpParams params) {
        if (httpProcessor == null) {
            throw new IllegalArgumentException("HTTP processor may not be null.");
        }
        if (connStrategy == null) {
            throw new IllegalArgumentException("Connection reuse strategy may not be null");
        }
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.httpProcessor = httpProcessor;
        this.connStrategy = connStrategy;
        this.responseFactory = responseFactory;
        this.executor = executor;
        this.params = params;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void setHandlerResolver(HttpRequestHandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    public void setExpectationVerifier(HttpExpectationVerifier expectationVerifier) {
        this.expectationVerifier = expectationVerifier;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public void connected(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        int bufsize = HttpNIOParams.getContentBufferSize(this.params);
        if (bufsize < 0) {
            bufsize = 20480;
        }
        ServerConnState connState = new ServerConnState(bufsize, conn);
        context.setAttribute(CONN_STATE, (Object)connState);
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionOpen(address);
        }
    }

    public void closed(NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
        connState.shutdown();
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionClosed(address);
        }
    }

    public void exception(final NHttpServerConnection conn, final HttpException httpex) {
        HttpContext context = conn.getContext();
        final ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
        this.executor.execute(new Runnable(){

            public void run() {
                block4: {
                    try {
                        HttpExecutionContext context = new HttpExecutionContext(conn.getContext());
                        context.setAttribute("http.connection", (Object)conn);
                        ThrottlingHttpServiceHandler.this.handleException(connState, httpex, (HttpContext)context);
                        ThrottlingHttpServiceHandler.this.commitResponse(connState, conn);
                    }
                    catch (IOException ex) {
                        ThrottlingHttpServiceHandler.this.shutdownConnection(conn);
                        if (ThrottlingHttpServiceHandler.this.eventListener != null) {
                            ThrottlingHttpServiceHandler.this.eventListener.fatalIOException(ex);
                        }
                    }
                    catch (HttpException ex) {
                        ThrottlingHttpServiceHandler.this.shutdownConnection(conn);
                        if (ThrottlingHttpServiceHandler.this.eventListener == null) break block4;
                        ThrottlingHttpServiceHandler.this.eventListener.fatalProtocolException(ex);
                    }
                }
            }
        });
    }

    public void exception(NHttpServerConnection conn, IOException ex) {
        this.shutdownConnection(conn);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(ex);
        }
    }

    public void timeout(NHttpServerConnection conn) {
        this.shutdownConnection(conn);
        if (this.eventListener != null) {
            InetAddress address = null;
            if (conn instanceof HttpInetConnection) {
                address = ((HttpInetConnection)conn).getRemoteAddress();
            }
            this.eventListener.connectionTimeout(address);
        }
    }

    public void requestReceived(final NHttpServerConnection conn) {
        HttpContext context = conn.getContext();
        HttpRequest request = conn.getHttpRequest();
        final ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
        connState.resetInput();
        connState.setRequest(request);
        connState.setInputState(1);
        this.executor.execute(new Runnable(){

            public void run() {
                block4: {
                    try {
                        HttpExecutionContext context = new HttpExecutionContext(conn.getContext());
                        context.setAttribute("http.connection", (Object)conn);
                        ThrottlingHttpServiceHandler.this.handleRequest(connState, (HttpContext)context);
                        ThrottlingHttpServiceHandler.this.commitResponse(connState, conn);
                    }
                    catch (IOException ex) {
                        ThrottlingHttpServiceHandler.this.shutdownConnection(conn);
                        if (ThrottlingHttpServiceHandler.this.eventListener != null) {
                            ThrottlingHttpServiceHandler.this.eventListener.fatalIOException(ex);
                        }
                    }
                    catch (HttpException ex) {
                        ThrottlingHttpServiceHandler.this.shutdownConnection(conn);
                        if (ThrottlingHttpServiceHandler.this.eventListener == null) break block4;
                        ThrottlingHttpServiceHandler.this.eventListener.fatalProtocolException(ex);
                    }
                }
            }
        });
    }

    public void inputReady(NHttpServerConnection conn, ContentDecoder decoder) {
        block3: {
            HttpContext context = conn.getContext();
            ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
            ContentInputBuffer buffer = connState.getInbuffer();
            connState.setInputState(2);
            try {
                buffer.consumeContent(decoder);
                if (decoder.isCompleted()) {
                    connState.setInputState(4);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block3;
                this.eventListener.fatalIOException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReady(NHttpServerConnection conn) {
        block6: {
            HttpContext context = conn.getContext();
            ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
            HttpResponse response = connState.getResponse();
            if (connState.getOutputState() != 8 && response != null && !conn.isResponseSubmitted()) {
                try {
                    conn.submitResponse(response);
                    ServerConnState serverConnState = connState;
                    synchronized (serverConnState) {
                        connState.setOutputState(8);
                        connState.notifyAll();
                    }
                }
                catch (HttpException ex) {
                    this.shutdownConnection(conn);
                    if (this.eventListener == null) break block6;
                    this.eventListener.fatalProtocolException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputReady(NHttpServerConnection conn, ContentEncoder encoder) {
        block6: {
            HttpContext context = conn.getContext();
            HttpResponse response = conn.getHttpResponse();
            ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
            ContentOutputBuffer buffer = connState.getOutbuffer();
            connState.setOutputState(16);
            try {
                buffer.produceContent(encoder);
                if (!encoder.isCompleted()) break block6;
                ServerConnState serverConnState = connState;
                synchronized (serverConnState) {
                    connState.setOutputState(32);
                    connState.notifyAll();
                }
                if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                }
            }
            catch (IOException ex) {
                this.shutdownConnection(conn);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalIOException(ex);
            }
        }
    }

    private void shutdownConnection(NHttpConnection conn) {
        HttpContext context = conn.getContext();
        ServerConnState connState = (ServerConnState)context.getAttribute(CONN_STATE);
        try {
            conn.shutdown();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (connState != null) {
            connState.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutput(ServerConnState connState, int expectedState) throws InterruptedIOException {
        ServerConnState serverConnState = connState;
        synchronized (serverConnState) {
            try {
                int currentState;
                while ((currentState = connState.getOutputState()) != expectedState) {
                    if (currentState == -1) {
                        throw new InterruptedIOException("Service interrupted");
                    }
                    connState.wait();
                }
            }
            catch (InterruptedException ex) {
                connState.shutdown();
            }
        }
    }

    private void handleException(ServerConnState connState, HttpException ex, HttpContext context) throws HttpException, IOException {
        HttpRequest request = connState.getRequest();
        context.setAttribute("http.request", (Object)request);
        HttpVersion ver = request != null ? request.getRequestLine().getHttpVersion() : HttpVersion.HTTP_1_0;
        int code = 500;
        if (ex instanceof MethodNotSupportedException) {
            code = 501;
        } else if (ex instanceof UnsupportedHttpVersionException) {
            code = 505;
        } else if (ex instanceof ProtocolException) {
            code = 400;
        }
        HttpResponse response = this.responseFactory.newHttpResponse(ver, code, context);
        byte[] msg = EncodingUtils.getAsciiBytes((String)ex.getMessage());
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=US-ASCII");
        response.setEntity((HttpEntity)entity);
        context.setAttribute("http.response", (Object)response);
        this.httpProcessor.process(response, context);
        connState.setResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ServerConnState connState, HttpContext context) throws HttpException, IOException {
        HttpResponse response;
        HttpRequest request = connState.getRequest();
        context.setAttribute("http.request", (Object)request);
        HttpVersion ver = request.getRequestLine().getHttpVersion();
        if (!ver.lessEquals(HttpVersion.HTTP_1_1)) {
            ver = HttpVersion.HTTP_1_1;
        }
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityReq = (HttpEntityEnclosingRequest)request;
            if (entityReq.expectContinue()) {
                response = this.responseFactory.newHttpResponse(ver, 100, context);
                response.getParams().setDefaults(this.params);
                if (this.expectationVerifier != null) {
                    try {
                        this.expectationVerifier.verify(request, response, context);
                    }
                    catch (HttpException ex) {
                        this.handleException(connState, ex, context);
                        return;
                    }
                }
                if (response.getStatusLine().getStatusCode() < 200) {
                    this.waitForOutput(connState, 0);
                    connState.setResponse(response);
                    ServerConnState ex = connState;
                    synchronized (ex) {
                        this.waitForOutput(connState, 8);
                        connState.resetOutput();
                    }
                } else {
                    context.setAttribute("http.response", (Object)response);
                    this.httpProcessor.process(response, context);
                    connState.setResponse(response);
                    return;
                }
            }
            if (entityReq.getEntity() != null) {
                entityReq.setEntity((HttpEntity)new BufferedContent(entityReq.getEntity(), connState.getInbuffer()));
            }
        }
        response = this.responseFactory.newHttpResponse(ver, 200, context);
        response.getParams().setDefaults(this.params);
        context.setAttribute("http.response", (Object)response);
        try {
            this.httpProcessor.process(request, context);
            HttpRequestHandler handler = null;
            if (this.handlerResolver != null) {
                String requestURI = request.getRequestLine().getUri();
                handler = this.handlerResolver.lookup(requestURI);
            }
            if (handler != null) {
                handler.handle(request, response, context);
            } else {
                response.setStatusCode(501);
            }
        }
        catch (HttpException ex) {
            this.handleException(connState, ex, context);
            return;
        }
        this.httpProcessor.process(response, context);
        connState.setResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitResponse(ServerConnState connState, IOControl ioControl) throws IOException, HttpException {
        int terminalState;
        this.waitForOutput(connState, 0);
        HttpResponse response = connState.getResponse();
        if (response.getEntity() != null) {
            ContentOutputBuffer buffer = connState.getOutbuffer();
            ContentOutputStream outstream = new ContentOutputStream(buffer);
            HttpEntity entity = response.getEntity();
            entity.writeTo((OutputStream)outstream);
            ((OutputStream)outstream).flush();
            ((OutputStream)outstream).close();
            terminalState = 32;
        } else {
            ioControl.requestOutput();
            terminalState = 8;
        }
        ServerConnState serverConnState = connState;
        synchronized (serverConnState) {
            this.waitForOutput(connState, terminalState);
            connState.resetOutput();
        }
    }

    static class ServerConnState {
        public static final int SHUTDOWN = -1;
        public static final int READY = 0;
        public static final int REQUEST_RECEIVED = 1;
        public static final int REQUEST_BODY_STREAM = 2;
        public static final int REQUEST_BODY_DONE = 4;
        public static final int RESPONSE_SENT = 8;
        public static final int RESPONSE_BODY_STREAM = 16;
        public static final int RESPONSE_BODY_DONE = 32;
        private final SharedInputBuffer inbuffer;
        private final SharedOutputBuffer outbuffer;
        private volatile int inputState;
        private volatile int outputState;
        private volatile HttpRequest request;
        private volatile HttpResponse response;

        public ServerConnState(int bufsize, IOControl ioControl) {
            this.inbuffer = new SharedInputBuffer(bufsize, ioControl);
            this.outbuffer = new SharedOutputBuffer(bufsize, ioControl);
            this.inputState = 0;
            this.outputState = 0;
        }

        public ContentInputBuffer getInbuffer() {
            return this.inbuffer;
        }

        public ContentOutputBuffer getOutbuffer() {
            return this.outbuffer;
        }

        public int getInputState() {
            return this.inputState;
        }

        public void setInputState(int inputState) {
            this.inputState = inputState;
        }

        public int getOutputState() {
            return this.outputState;
        }

        public void setOutputState(int outputState) {
            this.outputState = outputState;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public void shutdown() {
            this.inbuffer.shutdown();
            this.outbuffer.shutdown();
            this.inputState = -1;
            this.outputState = -1;
        }

        public void resetInput() {
            this.inbuffer.reset();
            this.request = null;
            this.inputState = 0;
        }

        public void resetOutput() {
            this.outbuffer.reset();
            this.response = null;
            this.outputState = 0;
        }
    }
}

