/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.reactor;

import java.io.IOException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.http.HttpRequestFactory;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.nio.DefaultNHttpServerConnection;
import org.apache.http.impl.nio.reactor.SSLIOSession;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.impl.nio.reactor.SSLMode;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.params.HttpParams;

public class SSLServerIOEventDispatch
implements IOEventDispatch {
    private static final String NHTTP_CONN = "NHTTP_CONN";
    private static final String SSL_SESSION = "SSL_SESSION";
    private final NHttpServiceHandler handler;
    private final SSLContext sslcontext;
    private final SSLIOSessionHandler sslHandler;
    private final HttpParams params;

    public SSLServerIOEventDispatch(NHttpServiceHandler handler, SSLContext sslcontext, SSLIOSessionHandler sslHandler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP service handler may not be null");
        }
        if (sslcontext == null) {
            throw new IllegalArgumentException("SSL context may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.handler = handler;
        this.params = params;
        this.sslcontext = sslcontext;
        this.sslHandler = sslHandler;
    }

    public SSLServerIOEventDispatch(NHttpServiceHandler handler, SSLContext sslcontext, HttpParams params) {
        this(handler, sslcontext, null, params);
    }

    public void connected(IOSession session) {
        SSLIOSession sslSession = new SSLIOSession(session, this.sslcontext, this.sslHandler);
        DefaultNHttpServerConnection conn = new DefaultNHttpServerConnection((IOSession)sslSession, (HttpRequestFactory)new DefaultHttpRequestFactory(), this.params);
        session.setAttribute(NHTTP_CONN, (Object)conn);
        session.setAttribute(SSL_SESSION, (Object)sslSession);
        this.handler.connected((NHttpServerConnection)conn);
        try {
            sslSession.initialize(SSLMode.SERVER, this.params);
        }
        catch (SSLException ex) {
            this.handler.exception((NHttpServerConnection)conn, (IOException)ex);
            sslSession.shutdown();
        }
    }

    public void disconnected(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        this.handler.closed((NHttpServerConnection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputReady(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        try {
            SSLIOSession sSLIOSession = sslSession;
            synchronized (sSLIOSession) {
                if (sslSession.isAppInputReady()) {
                    conn.consumeInput(this.handler);
                }
                sslSession.inboundTransport();
            }
        }
        catch (IOException ex) {
            this.handler.exception((NHttpServerConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputReady(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        try {
            SSLIOSession sSLIOSession = sslSession;
            synchronized (sSLIOSession) {
                if (sslSession.isAppOutputReady()) {
                    conn.produceOutput(this.handler);
                }
                sslSession.outboundTransport();
            }
        }
        catch (IOException ex) {
            this.handler.exception((NHttpServerConnection)conn, ex);
            sslSession.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(IOSession session) {
        DefaultNHttpServerConnection conn = (DefaultNHttpServerConnection)session.getAttribute(NHTTP_CONN);
        SSLIOSession sslSession = (SSLIOSession)session.getAttribute(SSL_SESSION);
        this.handler.timeout((NHttpServerConnection)conn);
        SSLIOSession sSLIOSession = sslSession;
        synchronized (sSLIOSession) {
            if (sslSession.isOutboundDone() && !sslSession.isInboundDone()) {
                sslSession.shutdown();
            }
        }
    }
}

