/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.runtime.Backend;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.Utils;
import cucumber.runtime.io.ClasspathResourceLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.java.ClasspathMethodScanner;
import cucumber.runtime.java.DefaultJavaObjectFactory;
import cucumber.runtime.java.JavaHookDefinition;
import cucumber.runtime.java.JavaSnippet;
import cucumber.runtime.java.JavaStepDefinition;
import cucumber.runtime.java.ObjectFactory;
import cucumber.runtime.snippets.SnippetGenerator;
import gherkin.formatter.model.Step;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;

public class JavaBackend
implements Backend {
    private final SnippetGenerator snippetGenerator = new SnippetGenerator(new JavaSnippet());
    private final ObjectFactory objectFactory;
    private final ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader(Thread.currentThread().getContextClassLoader());
    private final ClasspathMethodScanner classpathMethodScanner = new ClasspathMethodScanner(this.classpathResourceLoader);
    private Glue glue;

    public JavaBackend(ResourceLoader ignored) {
        this.objectFactory = this.loadObjectFactory();
    }

    public JavaBackend(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    private ObjectFactory loadObjectFactory() {
        ObjectFactory objectFactory;
        try {
            objectFactory = this.classpathResourceLoader.instantiateExactlyOneSubclass(ObjectFactory.class, "cucumber.runtime", new Class[0], new Object[0]);
        }
        catch (CucumberException ce) {
            objectFactory = new DefaultJavaObjectFactory();
        }
        return objectFactory;
    }

    @Override
    public void loadGlue(Glue glue, List<String> gluePaths) {
        this.glue = glue;
        this.classpathMethodScanner.scan(this, gluePaths);
    }

    public void loadGlue(Glue glue, Method method, Class<?> glueCodeClass) {
        this.glue = glue;
        this.classpathMethodScanner.scan(this, method, glueCodeClass);
    }

    @Override
    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    @Override
    public void buildWorld() {
        this.objectFactory.start();
    }

    @Override
    public void disposeWorld() {
        this.objectFactory.stop();
    }

    @Override
    public String getSnippet(Step step) {
        return this.snippetGenerator.getSnippet(step);
    }

    void addStepDefinition(Annotation annotation, Method method) {
        try {
            this.objectFactory.addClass(method.getDeclaringClass());
            this.glue.addStepDefinition(new JavaStepDefinition(method, this.pattern(annotation), this.timeout(annotation), this.objectFactory));
        }
        catch (DuplicateStepDefinitionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CucumberException(e);
        }
    }

    private Pattern pattern(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("value", new Class[0]);
        String regexpString = (String)Utils.invoke(annotation, regexpMethod, 0, new Object[0]);
        return Pattern.compile(regexpString);
    }

    private int timeout(Annotation annotation) throws Throwable {
        Method regexpMethod = annotation.getClass().getMethod("timeout", new Class[0]);
        return (Integer)Utils.invoke(annotation, regexpMethod, 0, new Object[0]);
    }

    void addHook(Annotation annotation, Method method) {
        this.objectFactory.addClass(method.getDeclaringClass());
        if (annotation.annotationType().equals(Before.class)) {
            String[] tagExpressions = ((Before)annotation).value();
            int timeout = ((Before)annotation).timeout();
            this.glue.addBeforeHook(new JavaHookDefinition(method, tagExpressions, ((Before)annotation).order(), timeout, this.objectFactory));
        } else {
            String[] tagExpressions = ((After)annotation).value();
            int timeout = ((After)annotation).timeout();
            this.glue.addAfterHook(new JavaHookDefinition(method, tagExpressions, ((After)annotation).order(), timeout, this.objectFactory));
        }
    }
}

