/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.runtime.CucumberException;
import cucumber.runtime.io.URLOutputStream;
import gherkin.deps.com.google.gson.Gson;
import gherkin.deps.com.google.gson.GsonBuilder;
import gherkin.formatter.Formatter;
import gherkin.formatter.Mappable;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HTMLFormatter
implements Formatter,
Reporter {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String JS_FORMATTER_VAR = "formatter";
    private static final String JS_REPORT_FILENAME = "report.js";
    private static final String[] TEXT_ASSETS = new String[]{"/cucumber/formatter/formatter.js", "/cucumber/formatter/index.html", "/cucumber/formatter/jquery-1.8.2.min.js", "/cucumber/formatter/style.css"};
    private static final Map<String, String> MIME_TYPES_EXTENSIONS = new HashMap<String, String>(){
        {
            this.put("image/bmp", "bmp");
            this.put("image/gif", "gif");
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("video/ogg", "ogg");
        }
    };
    private final URL htmlReportDir;
    private NiceAppendable jsOut;
    private boolean firstFeature = true;
    private int embeddedIndex;

    public HTMLFormatter(URL htmlReportDir) {
        this.htmlReportDir = htmlReportDir;
    }

    @Override
    public void uri(String uri) {
        if (this.firstFeature) {
            this.jsOut().append("$(document).ready(function() {").append("var ").append(JS_FORMATTER_VAR).append(" = new CucumberHTML.DOMFormatter($('.cucumber-report'));");
            this.firstFeature = false;
        }
        this.jsFunctionCall("uri", uri);
    }

    @Override
    public void feature(Feature feature) {
        this.jsFunctionCall("feature", feature);
    }

    @Override
    public void background(Background background) {
        this.jsFunctionCall("background", background);
    }

    @Override
    public void scenario(Scenario scenario) {
        this.jsFunctionCall("scenario", scenario);
    }

    @Override
    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.jsFunctionCall("scenarioOutline", scenarioOutline);
    }

    @Override
    public void examples(Examples examples) {
        this.jsFunctionCall("examples", examples);
    }

    @Override
    public void step(Step step) {
        this.jsFunctionCall("step", step);
    }

    @Override
    public void eof() {
    }

    @Override
    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    @Override
    public void done() {
        if (!this.firstFeature) {
            this.jsOut().append("});");
            this.copyReportFiles();
        }
    }

    @Override
    public void close() {
        this.jsOut().close();
    }

    @Override
    public void result(Result result) {
        this.jsFunctionCall("result", result);
    }

    @Override
    public void before(Match match, Result result) {
        this.jsFunctionCall("before", result);
    }

    @Override
    public void after(Match match, Result result) {
        this.jsFunctionCall("after", result);
    }

    @Override
    public void match(Match match) {
        this.jsFunctionCall("match", match);
    }

    @Override
    public void embedding(String mimeType, byte[] data) {
        String extension = MIME_TYPES_EXTENSIONS.get(mimeType);
        if (extension != null) {
            StringBuilder fileName = new StringBuilder("embedded").append(this.embeddedIndex++).append(".").append(extension);
            this.writeBytesAndClose(data, this.reportFileOutputStream(fileName.toString()));
            this.jsFunctionCall("embedding", mimeType, fileName);
        }
    }

    @Override
    public void write(String text) {
        this.jsFunctionCall("write", text);
    }

    private void jsFunctionCall(String functionName, Object ... args) {
        NiceAppendable out = this.jsOut().append("formatter.").append(functionName).append("(");
        boolean comma = false;
        for (Map<String, Object> map : args) {
            if (comma) {
                out.append(", ");
            }
            Map<String, Object> map2 = map instanceof Mappable ? ((Mappable)((Object)map)).toMap() : map;
            String stringArg = gson.toJson(map2);
            out.append(stringArg);
            comma = true;
        }
        out.append(");").println();
    }

    private void copyReportFiles() {
        for (String textAsset : TEXT_ASSETS) {
            InputStream textAssetStream = this.getClass().getResourceAsStream(textAsset);
            if (textAssetStream == null) {
                throw new CucumberException("Couldn't find " + textAsset + ". Is cucumber-html on your classpath? Make sure you have the right version.");
            }
            String baseName = new File(textAsset).getName();
            this.writeStreamAndClose(textAssetStream, this.reportFileOutputStream(baseName));
        }
    }

    private void writeStreamAndClose(InputStream in, OutputStream out) {
        byte[] buffer = new byte[16384];
        try {
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
            out.close();
        }
        catch (IOException e) {
            throw new CucumberException("Unable to write to report file item: ", e);
        }
    }

    private void writeBytesAndClose(byte[] buf, OutputStream out) {
        try {
            out.write(buf);
        }
        catch (IOException e) {
            throw new CucumberException("Unable to write to report file item: ", e);
        }
    }

    private NiceAppendable jsOut() {
        if (this.jsOut == null) {
            try {
                this.jsOut = new NiceAppendable(new OutputStreamWriter(this.reportFileOutputStream(JS_REPORT_FILENAME), "UTF-8"));
            }
            catch (IOException e) {
                throw new CucumberException(e);
            }
        }
        return this.jsOut;
    }

    private OutputStream reportFileOutputStream(String fileName) {
        try {
            return new URLOutputStream(new URL(this.htmlReportDir, fileName));
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
    }
}

