/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.table;

import cucumber.api.DataTable;
import cucumber.deps.difflib.Delta;
import cucumber.deps.difflib.DiffUtils;
import cucumber.deps.difflib.Patch;
import cucumber.runtime.table.DiffableRow;
import cucumber.runtime.table.TableDiffException;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableDiffer {
    private final DataTable from;
    private final DataTable to;

    public TableDiffer(DataTable fromTable, DataTable toTable) {
        this.checkColumns(fromTable, toTable);
        this.from = fromTable;
        this.to = toTable;
    }

    private void checkColumns(DataTable a2, DataTable b) {
        if (a2.topCells().size() != b.topCells().size()) {
            throw new IllegalArgumentException("Tables must have equal number of columns:\n" + a2 + "\n" + b);
        }
    }

    public void calculateDiffs() throws TableDiffException {
        Patch patch = DiffUtils.diff(this.from.diffableRows(), this.to.diffableRows());
        List<Delta> deltas = patch.getDeltas();
        if (!deltas.isEmpty()) {
            Map<Integer, Delta> deltasByLine = this.createDeltasByLine(deltas);
            throw new TableDiffException(this.from, this.to, this.createTableDiff(deltasByLine));
        }
    }

    private Map<Integer, Delta> createDeltasByLine(List<Delta> deltas) {
        HashMap<Integer, Delta> deltasByLine = new HashMap<Integer, Delta>();
        for (Delta delta : deltas) {
            deltasByLine.put(delta.getOriginal().getPosition(), delta);
        }
        return deltasByLine;
    }

    private DataTable createTableDiff(Map<Integer, Delta> deltasByLine) {
        ArrayList<DataTableRow> diffTableRows = new ArrayList<DataTableRow>();
        List<List<String>> rows = this.from.raw();
        for (int i = 0; i < rows.size(); ++i) {
            Delta delta = deltasByLine.get(i);
            if (delta == null) {
                diffTableRows.add(this.from.getGherkinRows().get(i));
                continue;
            }
            this.addRowsToTableDiff(diffTableRows, delta);
            if (delta.getType() == Delta.TYPE.CHANGE || delta.getType() == Delta.TYPE.DELETE) {
                i += delta.getOriginal().getLines().size() - 1;
                continue;
            }
            diffTableRows.add(this.from.getGherkinRows().get(i));
        }
        Delta remainingDelta = deltasByLine.get(rows.size());
        if (remainingDelta != null) {
            this.addRowsToTableDiff(diffTableRows, remainingDelta);
        }
        return new DataTable(diffTableRows, this.from.getTableConverter());
    }

    private void addRowsToTableDiff(List<DataTableRow> diffTableRows, Delta delta) {
        this.markChangedAndDeletedRowsInOriginalAsMissing(diffTableRows, delta);
        this.markChangedAndInsertedRowsInRevisedAsNew(diffTableRows, delta);
    }

    private void markChangedAndDeletedRowsInOriginalAsMissing(List<DataTableRow> diffTableRows, Delta delta) {
        List<?> deletedLines = delta.getOriginal().getLines();
        for (DiffableRow row : deletedLines) {
            diffTableRows.add(new DataTableRow(row.row.getComments(), row.row.getCells(), row.row.getLine(), Row.DiffType.DELETE));
        }
    }

    private void markChangedAndInsertedRowsInRevisedAsNew(List<DataTableRow> diffTableRows, Delta delta) {
        List<?> insertedLines = delta.getRevised().getLines();
        for (DiffableRow row : insertedLines) {
            diffTableRows.add(new DataTableRow(row.row.getComments(), row.row.getCells(), row.row.getLine(), Row.DiffType.INSERT));
        }
    }
}

