/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.serializers.impl;

import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.Value;
import io.advantageous.boon.json.serializers.JsonSerializerInternal;
import io.advantageous.boon.json.serializers.ObjectSerializer;
import io.advantageous.boon.primitive.CharBuf;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class BasicObjectSerializerImpl
implements ObjectSerializer {
    private final boolean includeNulls;
    private final boolean includeTypeInfo;

    public BasicObjectSerializerImpl(boolean includeNulls, boolean includeTypeInfo) {
        this.includeNulls = includeNulls;
        this.includeTypeInfo = includeTypeInfo;
    }

    @Override
    public final void serializeObject(JsonSerializerInternal jsonSerializer, Object obj, CharBuf builder) {
        TypeType type = TypeType.getInstanceType((Object)obj);
        switch (type) {
            case NULL: {
                if (this.includeNulls) {
                    builder.addNull();
                }
                return;
            }
            case INT: {
                builder.addInt(Integer.TYPE.cast(obj));
                return;
            }
            case BOOLEAN: {
                builder.addBoolean(Boolean.TYPE.cast(obj).booleanValue());
                return;
            }
            case BYTE: {
                builder.addByte(Byte.TYPE.cast(obj).byteValue());
                return;
            }
            case LONG: {
                builder.addLong(Long.TYPE.cast(obj));
                return;
            }
            case DOUBLE: {
                builder.addDouble(Double.TYPE.cast(obj));
                return;
            }
            case FLOAT: {
                builder.addFloat(Float.TYPE.cast(obj));
                return;
            }
            case SHORT: {
                builder.addShort(Short.TYPE.cast(obj).shortValue());
                return;
            }
            case CHAR: {
                builder.addChar(Character.TYPE.cast(obj).charValue());
                return;
            }
            case BIG_DECIMAL: {
                builder.addBigDecimal((BigDecimal)obj);
                return;
            }
            case BIG_INT: {
                builder.addBigInteger((BigInteger)obj);
                return;
            }
            case DATE: {
                jsonSerializer.serializeDate((Date)obj, builder);
                return;
            }
            case STRING: {
                jsonSerializer.serializeString((String)obj, builder);
                return;
            }
            case CLASS: {
                builder.addQuoted(((Class)obj).getName());
                return;
            }
            case TIME_ZONE: {
                TimeZone zone = (TimeZone)obj;
                builder.addQuoted(zone.getID());
                return;
            }
            case CHAR_SEQUENCE: {
                jsonSerializer.serializeString(obj.toString(), builder);
                return;
            }
            case BOOLEAN_WRAPPER: {
                builder.addBoolean(((Boolean)obj).booleanValue());
                return;
            }
            case INTEGER_WRAPPER: {
                builder.addInt((Integer)obj);
                return;
            }
            case LONG_WRAPPER: {
                builder.addLong((Long)obj);
                return;
            }
            case FLOAT_WRAPPER: {
                builder.addFloat((Float)obj);
                return;
            }
            case DOUBLE_WRAPPER: {
                builder.addDouble((Double)obj);
                return;
            }
            case SHORT_WRAPPER: {
                builder.addShort(((Short)obj).shortValue());
                return;
            }
            case BYTE_WRAPPER: {
                builder.addByte(((Byte)obj).byteValue());
                return;
            }
            case CHAR_WRAPPER: {
                builder.addChar(((Character)obj).charValue());
                return;
            }
            case ENUM: {
                builder.addQuoted(obj.toString());
                return;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                jsonSerializer.serializeCollection((Collection)obj, builder);
                return;
            }
            case MAP: {
                jsonSerializer.serializeMap((Map)obj, builder);
                return;
            }
            case ARRAY: 
            case ARRAY_INT: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_OBJECT: {
                jsonSerializer.serializeArray(obj, builder);
                return;
            }
            case VALUE: {
                Value value = (Value)obj;
                this.serializeObject(jsonSerializer, value.toValue(), builder);
                return;
            }
            case INSTANCE: {
                jsonSerializer.serializeInstance(obj, builder, this.includeTypeInfo);
                return;
            }
            case CURRENCY: {
                builder.addCurrency((Currency)obj);
                return;
            }
        }
        jsonSerializer.serializeUnknown(obj, builder);
    }
}

