/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.serializers.impl;

import io.advantageous.boon.json.serializers.ArraySerializer;
import io.advantageous.boon.json.serializers.CollectionSerializer;
import io.advantageous.boon.json.serializers.JsonSerializerInternal;
import io.advantageous.boon.primitive.CharBuf;
import java.lang.reflect.Array;
import java.util.Collection;

public class CollectionSerializerImpl
implements CollectionSerializer,
ArraySerializer {
    private static final char[] EMPTY_LIST_CHARS = new char[]{'[', ']'};

    @Override
    public final void serializeCollection(JsonSerializerInternal serializer, Collection<?> collection, CharBuf builder) {
        if (collection.size() == 0) {
            builder.addChars(EMPTY_LIST_CHARS);
            return;
        }
        builder.addChar('[');
        for (Object o : collection) {
            if (o == null) {
                builder.addNull();
                builder.addChar(',');
                continue;
            }
            serializer.serializeObject(o, builder);
            builder.addChar(',');
        }
        builder.removeLastChar();
        builder.addChar(']');
    }

    @Override
    public void serializeArray(JsonSerializerInternal serializer, Object array, CharBuf builder) {
        if (Array.getLength(array) == 0) {
            builder.addChars(EMPTY_LIST_CHARS);
            return;
        }
        builder.addChar('[');
        int length = Array.getLength(array);
        for (int index = 0; index < length; ++index) {
            Object o = Array.get(array, index);
            if (o == null) {
                builder.addNull();
                builder.addChar(',');
                continue;
            }
            serializer.serializeObject(o, builder);
            builder.addChar(',');
        }
        builder.removeLastChar();
        builder.addChar(']');
    }
}

