/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.serializers.impl;

import io.advantageous.boon.core.reflection.fields.FieldAccess;
import io.advantageous.boon.json.serializers.InstanceSerializer;
import io.advantageous.boon.json.serializers.JsonSerializerInternal;
import io.advantageous.boon.json.serializers.impl.JsonSerializerImpl;
import io.advantageous.boon.primitive.CharBuf;
import java.util.Collection;
import java.util.Map;

public class InstanceSerializerImpl
implements InstanceSerializer {
    @Override
    public final void serializeInstance(JsonSerializerInternal serializer, Object instance, CharBuf builder) {
        Map<String, FieldAccess> fieldAccessors = serializer.getFields(instance.getClass());
        Collection<FieldAccess> values = fieldAccessors.values();
        builder.addChar('{');
        int index = 0;
        for (FieldAccess fieldAccess : values) {
            if (!serializer.serializeField(instance, fieldAccess, builder)) continue;
            builder.addChar(',');
            ++index;
        }
        if (index > 0) {
            builder.removeLastChar();
        }
        builder.addChar('}');
    }

    @Override
    public void serializeSubtypeInstance(JsonSerializerInternal serializer, Object instance, CharBuf builder) {
        builder.addString("{\"class\":");
        builder.addQuoted(instance.getClass().getName());
        Map<String, FieldAccess> fieldAccessors = serializer.getFields(instance.getClass());
        int index = 0;
        Collection<FieldAccess> values = fieldAccessors.values();
        int length = values.size();
        if (length > 0) {
            builder.addChar(',');
            for (FieldAccess fieldAccess : values) {
                boolean sent = serializer.serializeField(instance, fieldAccess, builder);
                if (!sent) continue;
                ++index;
                builder.addChar(',');
            }
            if (index > 0) {
                builder.removeLastChar();
            }
            builder.addChar('}');
        }
    }

    @Override
    public void serializeInstance(JsonSerializerImpl serializer, Object instance, CharBuf builder, boolean includeTypeInfo) {
        Map<String, FieldAccess> fieldAccessors = serializer.getFields(instance.getClass());
        Collection<FieldAccess> values = fieldAccessors.values();
        if (includeTypeInfo) {
            builder.addString("{\"class\":");
            builder.addQuoted(instance.getClass().getName());
            builder.addChar(',');
        } else {
            builder.addChar('{');
        }
        int index = 0;
        for (FieldAccess fieldAccess : values) {
            if (!serializer.serializeField(instance, fieldAccess, builder)) continue;
            builder.addChar(',');
            ++index;
        }
        if (index > 0) {
            builder.removeLastChar();
        }
        builder.addChar('}');
    }
}

