/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core;

import io.advantageous.boon.core.Dates;
import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.IO;
import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.StringScanner;
import io.advantageous.boon.core.Typ;
import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.Value;
import io.advantageous.boon.core.reflection.BeanUtils;
import io.advantageous.boon.core.reflection.ClassMeta;
import io.advantageous.boon.core.reflection.ConstructorAccess;
import io.advantageous.boon.core.reflection.FastStringUtils;
import io.advantageous.boon.core.reflection.MapObjectConversion;
import io.advantageous.boon.core.reflection.Reflection;
import io.advantageous.boon.primitive.Arry;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Logger;

public class Conversions {
    private static final Logger log = Logger.getLogger(Conversions.class.getName());

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Value) {
            return ((Value)obj).bigDecimalValue();
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        if (obj instanceof Number) {
            double val = ((Number)obj).doubleValue();
            return BigDecimal.valueOf(val);
        }
        return null;
    }

    public static BigInteger toBigInteger(Object obj) {
        if (obj instanceof BigInteger) {
            return (BigInteger)obj;
        }
        if (obj instanceof Value) {
            return ((Value)obj).bigIntegerValue();
        }
        if (obj instanceof String) {
            return new BigInteger((String)obj);
        }
        if (obj instanceof Number) {
            long val = ((Number)obj).longValue();
            return BigInteger.valueOf(val);
        }
        return null;
    }

    public static int toInt(Object obj) {
        return Conversions.toInt(obj, Integer.MIN_VALUE);
    }

    public static int toInt(Object obj, int defaultValue) {
        if (obj.getClass() == Integer.TYPE) {
            return Integer.TYPE.cast(obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof Boolean || obj.getClass() == Boolean.class) {
            boolean value = Conversions.toBoolean(obj);
            return value ? 1 : 0;
        }
        if (obj instanceof CharSequence) {
            try {
                return StringScanner.parseInt(Str.toString(obj));
            }
            catch (Exception ex) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static byte toByte(Object obj) {
        return Conversions.toByte(obj, (byte)-128);
    }

    public static byte toByte(Object obj, byte defaultByte) {
        if (obj.getClass() == Byte.TYPE) {
            return Byte.TYPE.cast(obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        return (byte)Conversions.toInt(obj, defaultByte);
    }

    public static short toShort(Object obj) {
        return Conversions.toShort(obj, (short)Short.MIN_VALUE);
    }

    public static short toShort(Object obj, short shortDefault) {
        if (obj.getClass() == Short.TYPE) {
            return Short.TYPE.cast(obj);
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        return (short)Conversions.toInt(obj, shortDefault);
    }

    public static char toChar(Object obj) {
        return Conversions.toChar(obj, '\u0000');
    }

    public static char toChar(Object obj, char defaultChar) {
        if (obj.getClass() == Character.TYPE) {
            return Character.TYPE.cast(obj).charValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj instanceof CharSequence) {
            return obj.toString().charAt(0);
        }
        if (obj instanceof Number) {
            return (char)Conversions.toInt(obj);
        }
        if (obj instanceof Boolean || obj.getClass() == Boolean.class) {
            boolean value = Conversions.toBoolean(obj);
            return value ? (char)'T' : 'F';
        }
        if (obj.getClass().isPrimitive()) {
            return (char)Conversions.toInt(obj);
        }
        String str = Conversions.toString(obj);
        if (str.length() > 0) {
            return str.charAt(0);
        }
        return defaultChar;
    }

    public static long toLong(Object obj) {
        return Conversions.toLong(obj, Long.MIN_VALUE);
    }

    public static long toLongOrDie(Object obj) {
        long l = Conversions.toLong(obj, Long.MIN_VALUE);
        if (l == Long.MIN_VALUE) {
            Exceptions.die("Cannot convert", obj, "into long value", obj);
        }
        return l;
    }

    public static long toLong(Object obj, long longDefault) {
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof CharSequence) {
            String str = Str.toString(obj);
            if (Dates.isJsonDate(str)) {
                return Dates.fromJsonDate(str).getTime();
            }
            try {
                return StringScanner.parseLong(str);
            }
            catch (Exception ex) {
                return longDefault;
            }
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        return Conversions.toInt(obj);
    }

    public static Currency toCurrency(Object obj) {
        if (obj instanceof Currency) {
            return (Currency)obj;
        }
        if (obj instanceof String) {
            String str = Str.toString(obj);
            return Currency.getInstance(str);
        }
        return null;
    }

    public static boolean toBoolean(Object value) {
        return Conversions.toBoolean(value, false);
    }

    public static boolean toBoolean(Object obj, boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number || obj.getClass().isPrimitive()) {
            int value = Conversions.toInt(obj);
            return value != 0;
        }
        if (obj instanceof Value) {
            return ((Value)obj).booleanValue();
        }
        if (obj instanceof String || obj instanceof CharSequence) {
            String str = Conversions.toString(obj);
            if (str.length() == 0) {
                return false;
            }
            return !str.equals("false");
        }
        if (Typ.isArray(obj)) {
            return Conversions.len(obj) > 0;
        }
        if (obj instanceof Collection) {
            if (Conversions.len(obj) > 0) {
                List list = Lists.list((Collection)obj);
                while (list.remove(null)) {
                }
                return Lists.len(list) > 0;
            }
            return false;
        }
        return Conversions.toBoolean(Conversions.toString(obj));
    }

    public static boolean toBooleanOrDie(Object obj) {
        if (obj == null) {
            Exceptions.die("Can't convert boolean from a null");
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String || obj instanceof CharSequence) {
            String str = Conversions.toString(obj);
            if (str.length() == 0) {
                return false;
            }
            if (str.equals("false")) {
                return false;
            }
            if (str.equals("true")) {
                return true;
            }
            Exceptions.die("Can't convert string", obj, "to boolean ");
            return false;
        }
        Exceptions.die("Can't convert", obj, "to boolean ");
        return false;
    }

    public static double toDouble(Object obj) {
        try {
            if (obj instanceof Double) {
                return (Double)obj;
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj instanceof CharSequence) {
                try {
                    return Double.parseDouble(((CharSequence)obj).toString());
                }
                catch (Exception ex) {
                    Exceptions.die(String.format("Unable to convert %s to a double", obj.getClass()));
                    return Double.MIN_VALUE;
                }
            }
        }
        catch (Exception ex) {
            log.warning(String.format("unable to convert to double and there was an exception %s", ex.getMessage()));
        }
        Exceptions.die(String.format("Unable to convert %s to a double", obj.getClass()));
        return Double.MIN_VALUE;
    }

    public static float toFloat(Object obj) {
        if (obj.getClass() == Float.TYPE) {
            return ((Float)obj).floatValue();
        }
        try {
            if (obj instanceof Float) {
                return ((Float)obj).floatValue();
            }
            if (obj instanceof Number) {
                return ((Number)obj).floatValue();
            }
            if (obj instanceof CharSequence) {
                try {
                    return Float.parseFloat(Str.toString(obj));
                }
                catch (Exception ex) {
                    Exceptions.die(String.format("Unable to convert %s to a float", obj.getClass()));
                    return Float.MIN_VALUE;
                }
            }
        }
        catch (Exception ex) {
            log.warning(String.format("unable to convert to float and there was an exception %s", ex.getMessage()));
        }
        Exceptions.die(String.format("Unable to convert %s to a float", obj.getClass()));
        return Float.MIN_VALUE;
    }

    public static <T> T coerce(Class<T> clz, Object value) {
        if (value != null && clz == value.getClass()) {
            return (T)value;
        }
        return Conversions.coerce(TypeType.getType(clz), clz, value);
    }

    public static <T> T createFromArg(Class<T> clz, Object value) {
        Class<?> arg1Type;
        if (value == null) {
            return Reflection.newInstance(clz);
        }
        if (clz.isInstance(value)) {
            return (T)value;
        }
        ClassMeta<T> meta = ClassMeta.classMeta(clz);
        List<ConstructorAccess> constructors = meta.oneArgumentConstructors();
        if (constructors.size() == 0) {
            return null;
        }
        if (constructors.size() == 1) {
            ConstructorAccess constructorAccess = constructors.get(0);
            Class<?> arg1Type2 = constructorAccess.parameterTypes()[0];
            if (arg1Type2.isInstance(value)) {
                return constructorAccess.create(value);
            }
            return constructorAccess.create(Conversions.coerce(arg1Type2, value));
        }
        for (ConstructorAccess c : constructors) {
            arg1Type = c.parameterTypes()[0];
            if (!arg1Type.isInstance(value)) continue;
            return c.create(value);
        }
        for (ConstructorAccess c : constructors) {
            arg1Type = c.parameterTypes()[0];
            if (!arg1Type.isAssignableFrom(value.getClass())) continue;
            return c.create(value);
        }
        return null;
    }

    public static <T> T coerce(TypeType coerceTo, Class<T> clz, Object value) {
        if (value == null) {
            if (coerceTo != TypeType.INSTANCE && !clz.isPrimitive()) {
                return null;
            }
            if (clz.isPrimitive()) {
                if (clz == Boolean.TYPE) {
                    return (T)Boolean.valueOf(false);
                }
                return (T)Integer.valueOf(0);
            }
        }
        switch (coerceTo) {
            case STRING: 
            case CHAR_SEQUENCE: {
                return (T)value.toString();
            }
            case NUMBER: {
                if (value instanceof Number) {
                    return (T)value;
                }
                Double d = Conversions.toDouble(value);
                return (T)d;
            }
            case INT: 
            case INTEGER_WRAPPER: {
                Integer i = Conversions.toInt(value);
                return (T)i;
            }
            case SHORT: 
            case SHORT_WRAPPER: {
                Short s = Conversions.toShort(value);
                return (T)s;
            }
            case BYTE: 
            case BYTE_WRAPPER: {
                Byte by = Conversions.toByte(value);
                return (T)by;
            }
            case CHAR: 
            case CHAR_WRAPPER: {
                Character ch = Character.valueOf(Conversions.toChar(value));
                return (T)ch;
            }
            case LONG: 
            case LONG_WRAPPER: {
                Long l = Conversions.toLong(value);
                return (T)l;
            }
            case DOUBLE: 
            case DOUBLE_WRAPPER: {
                Double d = Conversions.toDouble(value);
                return (T)d;
            }
            case FLOAT: 
            case FLOAT_WRAPPER: {
                Float f = Float.valueOf(Conversions.toFloat(value));
                return (T)f;
            }
            case DATE: {
                return (T)Conversions.toDate(value);
            }
            case CALENDAR: {
                return (T)Conversions.toCalendar(Conversions.toDate(value));
            }
            case LOCALE_DATE_TIME: {
                return (T)Conversions.toLocalDateTime(Conversions.toDate(value));
            }
            case BIG_DECIMAL: {
                return (T)Conversions.toBigDecimal(value);
            }
            case BIG_INT: {
                return (T)Conversions.toBigInteger(value);
            }
            case BOOLEAN: 
            case BOOLEAN_WRAPPER: {
                return (T)Boolean.valueOf(Conversions.toBoolean(value));
            }
            case MAP: {
                return (T)Conversions.toMap(value);
            }
            case ARRAY: 
            case ARRAY_INT: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_OBJECT: {
                return Conversions.toPrimitiveArrayIfPossible(clz, value);
            }
            case LIST: 
            case SET: 
            case COLLECTION: {
                return Conversions.toCollection(clz, value);
            }
            case INSTANCE: {
                if (value instanceof Value) {
                    value = ((Value)value).toValue();
                }
                if (value instanceof Map) {
                    return MapObjectConversion.fromMap((Map)value, clz);
                }
                if (value instanceof List) {
                    return MapObjectConversion.fromList((List)value, clz);
                }
                if (clz.isInstance(value)) {
                    return (T)value;
                }
                return Conversions.createFromArg(clz, value);
            }
            case ENUM: {
                return Conversions.toEnum(clz, value);
            }
            case PATH: {
                return (T)IO.path(value.toString());
            }
            case CLASS: {
                return (T)Conversions.toClass(value);
            }
            case TIME_ZONE: {
                return (T)Conversions.toTimeZone(value);
            }
            case UUID: {
                return (T)Conversions.toUUID(value);
            }
            case CURRENCY: {
                return (T)Conversions.toCurrency(value);
            }
            case OBJECT: {
                return (T)value;
            }
        }
        return Conversions.createFromArg(clz, value);
    }

    private static LocalDateTime toLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault());
    }

    private static UUID toUUID(Object value) {
        return UUID.fromString(value.toString());
    }

    public static <T> T coerceWithFlag(Class<T> clz, boolean[] flag, Object value) {
        return Conversions.coerceWithFlag(TypeType.getType(clz), clz, flag, value);
    }

    public static <T> T coerceWithFlag(TypeType coerceTo, Class<T> clz, boolean[] flag, Object value) {
        flag[0] = true;
        if (value == null) {
            return null;
        }
        if (clz.isInstance(value)) {
            return (T)value;
        }
        switch (coerceTo) {
            case STRING: 
            case CHAR_SEQUENCE: {
                return (T)value.toString();
            }
            case INT: 
            case INTEGER_WRAPPER: {
                Integer i = Conversions.toInt(value);
                if (i == Integer.MIN_VALUE) {
                    flag[0] = false;
                }
                return (T)i;
            }
            case SHORT: 
            case SHORT_WRAPPER: {
                Short s = Conversions.toShort(value);
                if (s == Short.MIN_VALUE) {
                    flag[0] = false;
                }
                return (T)s;
            }
            case BYTE: 
            case BYTE_WRAPPER: {
                Byte by = Conversions.toByte(value);
                if (by == -128) {
                    flag[0] = false;
                }
                return (T)by;
            }
            case CHAR: 
            case CHAR_WRAPPER: {
                Character ch = Character.valueOf(Conversions.toChar(value));
                if (ch.charValue() == '\u0000') {
                    flag[0] = false;
                }
                return (T)ch;
            }
            case LONG: 
            case LONG_WRAPPER: {
                Long l = Conversions.toLong(value);
                if (l == Long.MIN_VALUE) {
                    flag[0] = false;
                }
                return (T)l;
            }
            case DOUBLE: 
            case DOUBLE_WRAPPER: {
                Double d = Conversions.toDouble(value);
                if (d == Double.MIN_VALUE) {
                    flag[0] = false;
                }
                return (T)d;
            }
            case FLOAT: 
            case FLOAT_WRAPPER: {
                Float f = Float.valueOf(Conversions.toFloat(value));
                if (f.floatValue() == Float.MIN_VALUE) {
                    flag[0] = false;
                }
                return (T)f;
            }
            case DATE: {
                return (T)Conversions.toDate(value);
            }
            case BIG_DECIMAL: {
                return (T)Conversions.toBigDecimal(value);
            }
            case BIG_INT: {
                return (T)Conversions.toBigInteger(value);
            }
            case CALENDAR: {
                return (T)Conversions.toCalendar(Conversions.toDate(value));
            }
            case BOOLEAN: 
            case BOOLEAN_WRAPPER: {
                return (T)Boolean.valueOf(Conversions.toBooleanOrDie(value));
            }
            case MAP: {
                return (T)Conversions.toMap(value);
            }
            case ARRAY: 
            case ARRAY_INT: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_OBJECT: {
                return Conversions.toPrimitiveArrayIfPossible(clz, value);
            }
            case COLLECTION: {
                return Conversions.toCollection(clz, value);
            }
            case INSTANCE: {
                Class<?> arg1Type;
                if (value instanceof Map) {
                    return MapObjectConversion.fromMap((Map)value, clz);
                }
                if (value instanceof List) {
                    return MapObjectConversion.fromList((List)value, clz);
                }
                if (clz.isInstance(value)) {
                    return (T)value;
                }
                ClassMeta<T> meta = ClassMeta.classMeta(clz);
                List<ConstructorAccess> constructors = meta.oneArgumentConstructors();
                if (constructors.size() == 0) {
                    return null;
                }
                if (constructors.size() == 1) {
                    ConstructorAccess constructorAccess = constructors.get(0);
                    Class<?> arg1Type2 = constructorAccess.parameterTypes()[0];
                    if (arg1Type2.isInstance(value)) {
                        return constructorAccess.create(value);
                    }
                    return constructorAccess.create(Conversions.coerce(arg1Type2, value));
                }
                for (ConstructorAccess c : constructors) {
                    arg1Type = c.parameterTypes()[0];
                    if (!arg1Type.isInstance(value)) continue;
                    return c.create(value);
                }
                for (ConstructorAccess c : constructors) {
                    arg1Type = c.parameterTypes()[0];
                    if (!arg1Type.isAssignableFrom(value.getClass())) continue;
                    return c.create(value);
                }
                flag[0] = false;
                break;
            }
            case ENUM: {
                return Conversions.toEnum(clz, value);
            }
            case CLASS: {
                return (T)Conversions.toClass(value);
            }
            case TIME_ZONE: {
                return (T)Conversions.toTimeZone(flag, value);
            }
            case UUID: {
                return (T)Conversions.toUUID(flag, value);
            }
            case CURRENCY: {
                return (T)Conversions.toCurrency(value);
            }
            case OBJECT: {
                return (T)value;
            }
            default: {
                flag[0] = false;
            }
        }
        return null;
    }

    private static UUID toUUID(boolean[] flag, Object value) {
        return Conversions.toUUID(value);
    }

    public static TimeZone toTimeZone(boolean[] flag, Object value) {
        String id = value.toString();
        return TimeZone.getTimeZone(id);
    }

    public static TimeZone toTimeZone(Object value) {
        String id = value.toString();
        return TimeZone.getTimeZone(id);
    }

    public static <T> T coerceClassic(Class<T> clz, Object value) {
        if (value == null) {
            return null;
        }
        if (clz == value.getClass()) {
            return (T)value;
        }
        if (clz == Typ.string || clz == Typ.chars) {
            return (T)value.toString();
        }
        if (clz == Typ.integer || clz == Typ.intgr) {
            Integer i = Conversions.toInt(value);
            return (T)i;
        }
        if (clz == Typ.longWrapper || clz == Typ.lng) {
            Long l = Conversions.toLong(value);
            return (T)l;
        }
        if (clz == Typ.doubleWrapper || clz == Typ.dbl) {
            Double i = Conversions.toDouble(value);
            return (T)i;
        }
        if (clz == Typ.date) {
            return (T)Conversions.toDate(value);
        }
        if (clz == Typ.bigInteger) {
            return (T)Conversions.toBigInteger(value);
        }
        if (clz == Typ.bigDecimal) {
            return (T)Conversions.toBigDecimal(value);
        }
        if (clz == Typ.calendar) {
            return (T)Conversions.toCalendar(Conversions.toDate(value));
        }
        if (clz == Typ.floatWrapper || clz == Typ.flt) {
            Float i = Float.valueOf(Conversions.toFloat(value));
            return (T)i;
        }
        if (clz == Typ.stringArray) {
            Exceptions.die("Need to fix this");
            return null;
        }
        if (clz == Typ.bool || clz == Typ.bln) {
            Boolean b = Conversions.toBoolean(value);
            return (T)b;
        }
        if (Typ.isMap(clz)) {
            return (T)Conversions.toMap(value);
        }
        if (clz.isArray()) {
            return Conversions.toPrimitiveArrayIfPossible(clz, value);
        }
        if (Typ.isCollection(clz)) {
            return Conversions.toCollection(clz, value);
        }
        if (clz != null && clz.getPackage() != null && !clz.getPackage().getName().startsWith("java") && Typ.isMap(value.getClass()) && Typ.doesMapHaveKeyTypeString(value)) {
            return (T)MapObjectConversion.fromMap((Map)value);
        }
        if (clz.isEnum()) {
            return Conversions.toEnum(clz, value);
        }
        return null;
    }

    public static <T extends Enum> T toEnumOld(Class<T> cls, String value) {
        try {
            return Enum.valueOf(cls, value);
        }
        catch (Exception ex) {
            return Enum.valueOf(cls, value.toUpperCase().replace('-', '_'));
        }
    }

    public static <T extends Enum> T toEnum(Class<T> cls, String value) {
        return Conversions.toEnum(cls, value, null);
    }

    public static <T extends Enum> T toEnum(Class<T> cls, String value, Enum defaultEnum) {
        Enum[] enumConstants;
        for (Enum e : enumConstants = (Enum[])cls.getEnumConstants()) {
            if (!e.name().equals(value)) continue;
            return (T)e;
        }
        value = value.toUpperCase().replace('-', '_');
        for (Enum e : enumConstants) {
            if (!e.name().equals(value)) continue;
            return (T)e;
        }
        value = Str.underBarCase(value);
        for (Enum e : enumConstants) {
            if (!e.name().equals(value)) continue;
            return (T)e;
        }
        return (T)defaultEnum;
    }

    public static <T extends Enum> T toEnum(Class<T> cls, int value) {
        Enum[] enumConstants;
        for (Enum e : enumConstants = (Enum[])cls.getEnumConstants()) {
            if (e.ordinal() != value) continue;
            return (T)e;
        }
        return null;
    }

    public static <T extends Enum> T toEnumOrDie(Class<T> cls, int value) {
        Enum[] enumConstants;
        for (Enum e : enumConstants = (Enum[])cls.getEnumConstants()) {
            if (e.ordinal() != value) continue;
            return (T)e;
        }
        Exceptions.die("Can't convert ordinal value " + value + " into enum of type " + cls);
        return null;
    }

    public static <T extends Enum> T toEnum(Class<T> cls, Object value) {
        if (value instanceof Value) {
            return ((Value)value).toEnum(cls);
        }
        if (value instanceof CharSequence) {
            return Conversions.toEnum(cls, value.toString());
        }
        if (value instanceof Number || value.getClass().isPrimitive()) {
            int i = Conversions.toInt(value);
            return Conversions.toEnum(cls, i);
        }
        if (value instanceof Collection) {
            return Conversions.toEnum(cls, ((Collection)value).iterator().next());
        }
        Exceptions.die("Can't convert  value " + value + " into enum of type " + cls);
        return null;
    }

    public static <T> T toPrimitiveArrayIfPossible(Class<T> clz, Object value) {
        if (clz == Typ.intArray) {
            return (T)Conversions.iarray(value);
        }
        if (clz == Typ.byteArray) {
            return (T)Conversions.barray(value);
        }
        if (clz == Typ.charArray) {
            return (T)Conversions.carray(value);
        }
        if (clz == Typ.shortArray) {
            return (T)Conversions.sarray(value);
        }
        if (clz == Typ.longArray) {
            return (T)Conversions.larray(value);
        }
        if (clz == Typ.floatArray) {
            return (T)Conversions.farray(value);
        }
        if (clz == Typ.doubleArray) {
            return (T)Conversions.darray(value);
        }
        if (value.getClass() == clz) {
            return (T)value;
        }
        int index = 0;
        Object newInstance = Array.newInstance(clz.getComponentType(), Conversions.len(value));
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (clz.getComponentType().isAssignableFrom(item.getClass())) {
                BeanUtils.idx(newInstance, index, item);
            } else {
                item = Conversions.coerce(clz.getComponentType(), item);
                BeanUtils.idx(newInstance, index, item);
            }
            ++index;
        }
        return (T)newInstance;
    }

    public static double[] darray(Object value) {
        if (value.getClass() == Typ.doubleArray) {
            return (double[])value;
        }
        double[] values = new double[Conversions.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toFloat(iterator.next());
            ++index;
        }
        return values;
    }

    public static float[] farray(Object value) {
        if (value.getClass() == Typ.floatArray) {
            return (float[])value;
        }
        float[] values = new float[Conversions.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toFloat(iterator.next());
            ++index;
        }
        return values;
    }

    public static long[] larray(Object value) {
        if (value.getClass() == Typ.shortArray) {
            return (long[])value;
        }
        long[] values = new long[Conversions.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toLong(iterator.next());
            ++index;
        }
        return values;
    }

    public static short[] sarray(Object value) {
        if (value.getClass() == Typ.shortArray) {
            return (short[])value;
        }
        short[] values = new short[Conversions.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toShort(iterator.next());
            ++index;
        }
        return values;
    }

    public static int[] iarray(Object value) {
        if (value.getClass() == Typ.intArray) {
            return (int[])value;
        }
        int[] values = new int[Conversions.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toInt(iterator.next());
            ++index;
        }
        return values;
    }

    public static byte[] barray(Object value) {
        if (value.getClass() == Typ.byteArray) {
            return (byte[])value;
        }
        byte[] values = new byte[Conversions.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Object.class, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toByte(iterator.next());
            ++index;
        }
        return values;
    }

    public static char[] carray(Object value) {
        if (value.getClass() == Typ.charArray) {
            return (char[])value;
        }
        char[] values = new char[Conversions.len(value)];
        int index = 0;
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            values[index] = Conversions.toChar(iterator.next());
            ++index;
        }
        return values;
    }

    public static Iterator iterator(Object value) {
        return Conversions.iterator(null, value);
    }

    public static <T> Iterator<T> iterator(Class<T> class1, final Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (Typ.isArray(value)) {
            final int length = Arry.len(value);
            return new Iterator<T>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < length;
                }

                @Override
                public T next() {
                    Object next = BeanUtils.idx(value, this.i);
                    ++this.i;
                    return next;
                }

                @Override
                public void remove() {
                }
            };
        }
        if (Typ.isCollection(value.getClass())) {
            return ((Collection)value).iterator();
        }
        return Collections.singleton(value).iterator();
    }

    public static <T> T toCollection(Class<T> clz, Object value) {
        if (Typ.isList(clz)) {
            return (T)Conversions.toList(value);
        }
        if (Typ.isSortedSet(clz)) {
            return (T)Conversions.toSortedSet(value);
        }
        if (Typ.isSet(clz)) {
            return (T)Conversions.toSet(value);
        }
        return (T)Conversions.toList(value);
    }

    public static List toList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Collection) {
            return new ArrayList((Collection)value);
        }
        if (value == null) {
            return new ArrayList();
        }
        if (value instanceof Map) {
            return new ArrayList(((Map)value).entrySet());
        }
        ArrayList<Object> list = new ArrayList<Object>(Conversions.len(value));
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Collection toCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value == null) {
            return new ArrayList();
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet();
        }
        ArrayList<Object> list = new ArrayList<Object>(Conversions.len(value));
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Set toSet(Object value) {
        if (value instanceof Set) {
            return (Set)value;
        }
        if (value instanceof Collection) {
            return new HashSet((Collection)value);
        }
        HashSet<Object> set = new HashSet<Object>(Conversions.len(value));
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static SortedSet toSortedSet(Object value) {
        if (value instanceof Set) {
            return (SortedSet)value;
        }
        if (value instanceof Collection) {
            return new TreeSet((Collection)value);
        }
        TreeSet<Object> set = new TreeSet<Object>();
        Iterator<Object> iterator = Conversions.iterator(Typ.object, value);
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static Map<String, Object> toMap(Object value) {
        return MapObjectConversion.toMap(value);
    }

    public static Number toWrapper(long l) {
        if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
            return Conversions.toWrapper((int)l);
        }
        return l;
    }

    public static Number toWrapper(int i) {
        if (i >= -128 && i <= 127) {
            return (byte)i;
        }
        if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
            return (short)i;
        }
        return i;
    }

    public static Object wrapAsObject(boolean i) {
        return i;
    }

    public static Object wrapAsObject(byte i) {
        return i;
    }

    public static Object wrapAsObject(short i) {
        return i;
    }

    public static Object wrapAsObject(int i) {
        return i;
    }

    public static Object wrapAsObject(long i) {
        return i;
    }

    public static Object wrapAsObject(double i) {
        return i;
    }

    public static Object wrapAsObject(float i) {
        return Float.valueOf(i);
    }

    public static Object toArrayGuessType(Collection<?> value) {
        Class<?> componentType = Reflection.getComponentType(value);
        Object array = Array.newInstance(componentType, value.size());
        Iterator<?> iterator = value.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            BeanUtils.idx(array, index, iterator.next());
            ++index;
        }
        return array;
    }

    public static <T> T[] toArray(Class<T> componentType, Collection<T> collection) {
        Object[] array = (Object[])Array.newInstance(componentType, collection.size());
        if (componentType.isAssignableFrom(Typ.getComponentType(collection))) {
            return collection.toArray(array);
        }
        int index = 0;
        for (Object object : collection) {
            array[index] = Conversions.coerce(componentType, object);
            ++index;
        }
        return array;
    }

    public static <V> V[] array(Class<V> type, Collection<V> array) {
        return Conversions.toArray(type, array);
    }

    public static Date toDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Value) {
            return ((Value)object).dateValue();
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        if (object instanceof Long) {
            return new Date((Long)object);
        }
        if (object instanceof CharSequence) {
            String val = object.toString();
            char[] chars = FastStringUtils.toCharArray(val);
            if (Dates.isISO8601QuickCheck(chars)) {
                return Dates.fromISO8601DateLoose(chars);
            }
            if (Dates.isLocalDateTime(chars)) {
                return Dates.fromISO8601DateLoose(chars);
            }
            return Conversions.toDateUS(val);
        }
        return null;
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Date toDate(Calendar c) {
        return c.getTime();
    }

    public static Date toDate(long value) {
        return new Date(value);
    }

    public static Date toDate(Long value) {
        return new Date(value);
    }

    public static Date toDate(String value) {
        try {
            return Conversions.toDateUS(value);
        }
        catch (Exception ex) {
            try {
                return DateFormat.getDateInstance(3).parse(value);
            }
            catch (ParseException e) {
                Exceptions.die("Unable to parse date");
                return null;
            }
        }
    }

    public static Date toDateUS(String string) {
        String[] split = StringScanner.splitByChars(string, '.', '\\', '/', ':');
        if (split.length == 3) {
            return Dates.getUSDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]));
        }
        if (split.length >= 6) {
            return Dates.getUSDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]), Conversions.toInt(split[3]), Conversions.toInt(split[4]), Conversions.toInt(split[5]));
        }
        Exceptions.die(String.format("Not able to parse %s into a US date", string));
        return null;
    }

    public static Date toEuroDate(String string) {
        String[] split = StringScanner.splitByChars(string, '.', '\\', '/', ':');
        if (split.length == 3) {
            return Dates.getEuroDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]));
        }
        if (split.length >= 6) {
            return Dates.getEuroDate(Conversions.toInt(split[0]), Conversions.toInt(split[1]), Conversions.toInt(split[2]), Conversions.toInt(split[3]), Conversions.toInt(split[4]), Conversions.toInt(split[5]));
        }
        Exceptions.die(String.format("Not able to parse %s into a Euro date", string));
        return null;
    }

    public static Collection<Object> createCollection(Class<?> type, int size) {
        if (type == List.class) {
            return new ArrayList<Object>(size);
        }
        if (type == SortedSet.class) {
            return new TreeSet<Object>();
        }
        if (type == Set.class) {
            return new LinkedHashSet<Object>(size);
        }
        if (Typ.isList(type)) {
            return new ArrayList<Object>();
        }
        if (Typ.isSortedSet(type)) {
            return new TreeSet<Object>();
        }
        if (Typ.isSet(type)) {
            return new LinkedHashSet<Object>(size);
        }
        return new ArrayList<Object>(size);
    }

    public static Map<?, ?> createMap(Class<?> type, int size) {
        if (type == HashMap.class) {
            return new HashMap(size);
        }
        if (type == TreeMap.class) {
            return new TreeMap();
        }
        if (type == SortedMap.class) {
            return new TreeMap();
        }
        if (type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap();
        }
        return new HashMap(size);
    }

    public static <TO, FROM> List<TO> mapFilterNulls(Function<FROM, TO> converter, Collection<FROM> fromCollection) {
        ArrayList<TO> toList = new ArrayList<TO>(fromCollection.size());
        for (FROM from : fromCollection) {
            TO converted = converter.apply(from);
            if (converted == null) continue;
            toList.add(converted);
        }
        return toList;
    }

    public static Object unifyListOrArray(Object o) {
        return Conversions.unifyListOrArray(o, null);
    }

    public static Object unifyListOrArray(Object o, List list) {
        if (o == null) {
            return null;
        }
        boolean isArray = o.getClass().isArray();
        if (list == null && !isArray && !(o instanceof Iterable)) {
            return o;
        }
        if (list == null) {
            list = new LinkedList<Object>();
        }
        if (isArray) {
            int length = Array.getLength(o);
            for (int index = 0; index < length; ++index) {
                Object o1 = Array.get(o, index);
                if (o1 instanceof Iterable || o.getClass().isArray()) {
                    Conversions.unifyListOrArray(o1, list);
                    continue;
                }
                list.add(o1);
            }
        } else if (o instanceof Collection) {
            Collection i = (Collection)o;
            for (Object item : i) {
                if (item instanceof Iterable || o.getClass().isArray()) {
                    Conversions.unifyListOrArray(item, list);
                    continue;
                }
                list.add(item);
            }
        } else {
            list.add(o);
        }
        return list;
    }

    public static Object unifyList(List list) {
        return Conversions.unifyListOrArray(list, null);
    }

    public static Object unifyList(Object o, List list) {
        if (o == null) {
            return null;
        }
        if (list == null) {
            list = new ArrayList<Object>();
        }
        if (o instanceof Iterable) {
            Iterable i = (Iterable)o;
            for (Object item : i) {
                Conversions.unifyListOrArray(item, list);
            }
        } else {
            list.add(o);
        }
        return list;
    }

    public static Comparable comparable(Object comparable) {
        return (Comparable)comparable;
    }

    public static int lengthOf(Object obj) {
        return Conversions.len(obj);
    }

    public static int len(Object obj) {
        if (Typ.isArray(obj)) {
            return Arry.len(obj);
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj == null) {
            return 0;
        }
        return 1;
    }

    public static Class<?> toClass(Object value) {
        if (value instanceof Class || value == null) {
            return (Class)value;
        }
        return Conversions.toClass(value.toString());
    }

    public static Class<?> toClass(String str) {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException ex) {
            return (Class)Exceptions.handle(Object.class, ex);
        }
    }

    public static String toString(Object obj, String defaultValue) {
        return obj == null ? defaultValue : obj.toString();
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public Number coerceNumber(Object inputArgument, Class<?> paraType) {
        Number number = (Number)inputArgument;
        if (paraType == Integer.TYPE || paraType == Integer.class) {
            return number.intValue();
        }
        if (paraType == Double.TYPE || paraType == Double.class) {
            return number.doubleValue();
        }
        if (paraType == Float.TYPE || paraType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        if (paraType == Short.TYPE || paraType == Short.class) {
            return number.shortValue();
        }
        if (paraType == Byte.TYPE || paraType == Byte.class) {
            return number.byteValue();
        }
        return null;
    }
}

