/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core.reflection;

import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.Sets;
import io.advantageous.boon.core.Typ;
import io.advantageous.boon.core.reflection.Reflection;
import io.advantageous.boon.core.reflection.fields.FieldAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Fields {
    private static final Set<String> fieldSortNames = Sets.safeSet("name", "orderBy", "title", "key");
    private static final Set<String> fieldSortNamesSuffixes = Sets.safeSet("Name", "Title", "Key");

    private static void setSortableField(Class<?> clazz, String fieldName) {
        Reflection.context()._sortableFields.put(clazz.getName(), fieldName);
    }

    private static String getSortableField(Class<?> clazz) {
        return Reflection.context()._sortableFields.get(clazz.getName());
    }

    public static boolean hasStringField(Object value1, String name) {
        Class<?> clz = value1.getClass();
        return Fields.classHasStringField(clz, name);
    }

    public static boolean classHasStringField(Class<?> clz, String name) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getType().equals(Typ.string) || !field.getName().equals(name) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz) continue;
            return true;
        }
        return false;
    }

    public static boolean hasField(Object value1, String name) {
        return Fields.classHasField(value1.getClass(), name);
    }

    public static boolean classHasField(Class<?> clz, String name) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getName().equals(name) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz) continue;
            return true;
        }
        return false;
    }

    public static String getFirstComparableOrPrimitive(Object value1) {
        return Fields.getFirstComparableOrPrimitiveFromClass(value1.getClass());
    }

    public static String getFirstComparableOrPrimitiveFromClass(Class<?> clz) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getType().isPrimitive() && (!Typ.isComparable(field.getType()) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz)) continue;
            return field.getName();
        }
        return null;
    }

    public static String getFirstStringFieldNameEndsWith(Object value, String name) {
        return Fields.getFirstStringFieldNameEndsWithFromClass(value.getClass(), name);
    }

    public static String getFirstStringFieldNameEndsWithFromClass(Class<?> clz, String name) {
        List<Field> fields = Reflection.getAllFields(clz);
        for (Field field : fields) {
            if (!field.getName().endsWith(name) || !field.getType().equals(Typ.string) || Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass() != clz) continue;
            return field.getName();
        }
        return null;
    }

    public static String getSortableField(Object value1) {
        if (value1 instanceof Map) {
            return Fields.getSortableFieldFromMap((Map)value1);
        }
        return Fields.getSortableFieldFromClass(value1.getClass());
    }

    private static String getSortableFieldFromMap(Map<String, ?> map) {
        Map.Entry entry;
        for (String string : fieldSortNames) {
            if (!map.containsKey(string)) continue;
            return string;
        }
        for (String string : fieldSortNamesSuffixes) {
            for (String key : map.keySet()) {
                if (!key.endsWith(string)) continue;
                return key;
            }
        }
        for (Object object : map.entrySet()) {
            entry = (Map.Entry)object;
            if (!Typ.isBasicType(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        for (Object object : map.entrySet()) {
            entry = (Map.Entry)object;
            if (!(entry.getValue() instanceof Comparable)) continue;
            return (String)entry.getKey();
        }
        return Exceptions.die(String.class, "No suitable sort key was found");
    }

    public static String getSortableFieldFromClass(Class<?> clazz) {
        String fieldName = Fields.getSortableField(clazz);
        if (fieldName == null) {
            for (String name : fieldSortNames) {
                if (!Fields.classHasStringField(clazz, name)) continue;
                fieldName = name;
                break;
            }
            if (fieldName == null) {
                String name;
                Iterator<String> iterator = fieldSortNamesSuffixes.iterator();
                while (iterator.hasNext() && (fieldName = Fields.getFirstStringFieldNameEndsWithFromClass(clazz, name = iterator.next())) == null) {
                }
            }
            if (fieldName == null) {
                fieldName = Fields.getFirstComparableOrPrimitiveFromClass(clazz);
            }
            if (fieldName == null) {
                Fields.setSortableField(clazz, "NOT FOUND");
                Exceptions.die("Could not find a sortable field for type " + clazz);
            }
            Fields.setSortableField(clazz, fieldName);
        }
        return fieldName;
    }

    public static boolean hasField(Class<?> aClass, String name) {
        Map<String, FieldAccess> fields = Reflection.getAllAccessorFields(aClass);
        return fields.containsKey(name);
    }
}

