/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core.reflection.fields;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.Sets;
import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.Value;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.Annotations;
import io.advantageous.boon.core.reflection.fields.FieldAccess;
import io.advantageous.boon.core.value.ValueContainer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseField
implements FieldAccess {
    private static final int PRIMITIVE = 0;
    private static final int FINAL = 1;
    private static final int STATIC = 2;
    private static final int VOLATILE = 3;
    private static final int QUALIFIED = 4;
    private static final int READ_ONLY = 5;
    private static final int INCLUDE = 6;
    private static final int IGNORE = 7;
    private static final int WRITE_ONLY = 8;
    private static final int HAS_INJECT = 9;
    private static final int NAMED = 10;
    private static final int REQUIRES_INJECTION = 11;
    protected final BitSet bits = new BitSet();
    protected final Class<?> type;
    protected final Class<?> parentType;
    protected final String name;
    protected final ParameterizedType parameterizedType;
    protected final Class<?> componentClass;
    protected final String typeName;
    public final TypeType typeEnum;
    private final TypeType componentType;
    private Map<String, Map<String, Object>> annotationMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private HashSet<String> includedViews;
    private HashSet<String> ignoreWithViews;
    private final String alias;
    private static Set<String> annotationsThatHaveAliases = Sets.set("JsonProperty", "SerializedName", "Named", "id", "In", "Qualifier");

    private void initAnnotationData(Class clazz) {
        String[] props;
        Map<String, AnnotationData> classAnnotations;
        AnnotationData jsonIgnoreProperties;
        Map<String, Object> props2;
        boolean required;
        String include;
        Map<String, Object> jsonIgnore;
        Collection<AnnotationData> annotationDataForFieldAndProperty = Annotations.getAnnotationDataForFieldAndProperty(clazz, this.name, Collections.EMPTY_SET);
        for (AnnotationData data : annotationDataForFieldAndProperty) {
            this.annotationMap.put(data.getSimpleClassName(), data.getValues());
            this.annotationMap.put(data.getFullClassName(), data.getValues());
        }
        if (this.hasAnnotation("JsonViews")) {
            Map<String, Object> jsonViews = this.getAnnotationData("JsonViews");
            String[] includeWithViews = (String[])jsonViews.get("includeWithViews");
            String[] ignoreWithViews = (String[])jsonViews.get("ignoreWithViews");
            if (includeWithViews != null) {
                this.includedViews = new HashSet();
                for (String view : includeWithViews) {
                    this.includedViews.add(view);
                }
            }
            if (ignoreWithViews != null) {
                this.ignoreWithViews = new HashSet();
                for (String view : ignoreWithViews) {
                    this.ignoreWithViews.add(view);
                }
            }
        }
        if (this.hasAnnotation("JsonIgnore")) {
            jsonIgnore = this.getAnnotationData("JsonIgnore");
            boolean ignore = (Boolean)jsonIgnore.get("value");
            this.bits.set(7, ignore);
        }
        if (this.hasAnnotation("JsonInclude") && (include = (String)(jsonIgnore = this.getAnnotationData("JsonInclude")).get("value")).equals("ALWAYS")) {
            this.bits.set(6);
        }
        if (this.hasAnnotation("Expose")) {
            jsonIgnore = this.getAnnotationData("Expose");
            boolean serialize = (Boolean)jsonIgnore.get("serialize");
            this.bits.set(6, serialize);
            this.bits.set(7, !serialize);
        }
        if (this.hasAnnotation("Inject") || this.hasAnnotation("Autowired") || this.hasAnnotation("In")) {
            this.bits.set(9);
        }
        if (this.hasAnnotation("Autowired") && (required = ((Boolean)(props2 = this.getAnnotationData("Autowired")).get("required")).booleanValue())) {
            this.bits.set(11);
        }
        if (this.hasAnnotation("In") && (required = ((Boolean)(props2 = this.getAnnotationData("In")).get("required")).booleanValue())) {
            this.bits.set(11);
        }
        if (this.hasAnnotation("Required")) {
            this.bits.set(11);
        }
        if (this.parentType != null && (jsonIgnoreProperties = (classAnnotations = Annotations.getAnnotationDataForClassAsMap(this.parentType)).get("JsonIgnoreProperties")) != null && (props = (String[])jsonIgnoreProperties.getValues().get("value")) != null) {
            for (String prop : props) {
                if (!prop.equals(this.name)) continue;
                this.bits.set(7, true);
                break;
            }
        }
    }

    private String findAlias() {
        String alias = null;
        for (String aliasAnnotation : annotationsThatHaveAliases) {
            alias = this.getAlias(aliasAnnotation);
            if (Str.isEmpty(alias)) continue;
            this.bits.set(10);
            break;
        }
        return Str.isEmpty(alias) ? this.name : alias;
    }

    private String getAlias(String annotationName) {
        String alias = null;
        if (this.hasAnnotation(annotationName)) {
            Map<String, Object> aliasD = this.getAnnotationData(annotationName);
            alias = (String)aliasD.get("value");
        }
        return alias;
    }

    protected BaseField(String name, Method getter, Method setter) {
        try {
            if (setter == null) {
                this.bits.set(5);
            } else if (getter == null) {
                this.bits.set(8);
                this.bits.set(7);
            }
            this.name = name.intern();
            this.bits.set(3, false);
            this.bits.set(4, false);
            if (getter != null) {
                this.bits.set(2, Modifier.isStatic(getter.getModifiers()));
                this.bits.set(1, Modifier.isFinal(getter.getModifiers()));
                this.type = getter.getReturnType();
                this.parentType = getter.getDeclaringClass();
                this.bits.set(0, this.type.isPrimitive());
                this.typeName = this.type.getName().intern();
                Type obj = getter.getGenericReturnType();
                this.parameterizedType = obj instanceof ParameterizedType ? (ParameterizedType)obj : null;
                this.typeEnum = name.startsWith("$") ? TypeType.SYSTEM : TypeType.getType(this.type);
                if (this.typeEnum.isArray()) {
                    this.componentClass = this.type.getComponentType();
                    this.componentType = TypeType.getType(this.componentClass);
                } else if (this.parameterizedType == null) {
                    this.componentClass = Object.class;
                    this.componentType = TypeType.OBJECT;
                } else {
                    Type obj2 = this.parameterizedType.getActualTypeArguments()[0];
                    this.componentClass = obj2 instanceof Class ? (Class<Object>)this.parameterizedType.getActualTypeArguments()[0] : Object.class;
                    this.componentType = TypeType.getType(this.componentClass);
                }
                getter.setAccessible(true);
                this.initAnnotationData(getter.getDeclaringClass());
            } else {
                this.bits.set(2, Modifier.isStatic(setter.getModifiers()));
                this.bits.set(1, Modifier.isFinal(setter.getModifiers()));
                this.type = setter.getParameterTypes()[0];
                this.typeEnum = name.startsWith("$") ? TypeType.SYSTEM : TypeType.getType(this.type);
                this.bits.set(0, this.type.isPrimitive());
                this.typeName = this.type.getName().intern();
                this.parameterizedType = null;
                this.componentClass = Object.class;
                this.componentType = TypeType.getType(this.componentClass);
                this.parentType = setter.getDeclaringClass();
                this.initAnnotationData(setter.getDeclaringClass());
            }
            String alias = this.findAlias();
            this.alias = alias != null ? alias : name;
        }
        catch (Exception ex) {
            Exceptions.handle("name " + name + " setter " + setter + " getter " + getter, (Throwable)ex);
            throw new RuntimeException("die");
        }
    }

    protected BaseField(Field field) {
        Type obj;
        Type[] actualTypeArguments;
        Type obj2;
        this.name = field.getName().intern();
        this.bits.set(2, Modifier.isStatic(field.getModifiers()));
        this.bits.set(1, Modifier.isFinal(field.getModifiers()));
        this.bits.set(3, Modifier.isVolatile(field.getModifiers()));
        this.bits.set(4, this.bits.get(1) || this.bits.get(3));
        this.bits.set(5, this.bits.get(1));
        this.bits.set(7, Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()));
        this.parentType = field.getDeclaringClass();
        this.type = field.getType();
        this.typeName = this.type.getName().intern();
        this.bits.set(0, this.type.isPrimitive());
        this.parameterizedType = field != null ? ((obj2 = field.getGenericType()) instanceof ParameterizedType ? (ParameterizedType)obj2 : null) : null;
        this.typeEnum = this.name.startsWith("$") ? TypeType.SYSTEM : TypeType.getType(this.type);
        this.componentClass = this.typeEnum.isArray() ? this.type.getComponentType() : (this.parameterizedType == null ? Object.class : ((actualTypeArguments = this.parameterizedType.getActualTypeArguments()).length > 0 ? ((obj = this.parameterizedType.getActualTypeArguments()[0]) instanceof Class ? (Class<Object>)this.parameterizedType.getActualTypeArguments()[0] : Object.class) : Object.class));
        this.componentType = TypeType.getType(this.componentClass);
        this.initAnnotationData(field.getDeclaringClass());
        this.alias = this.findAlias();
    }

    @Override
    public final Object getValue(Object obj) {
        switch (this.typeEnum) {
            case INT: {
                return this.getInt(obj);
            }
            case LONG: {
                return this.getLong(obj);
            }
            case BOOLEAN: {
                return this.getBoolean(obj);
            }
            case BYTE: {
                return this.getByte(obj);
            }
            case SHORT: {
                return this.getShort(obj);
            }
            case CHAR: {
                return Character.valueOf(this.getChar(obj));
            }
            case DOUBLE: {
                return this.getDouble(obj);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(obj));
            }
        }
        return this.getObject(obj);
    }

    @Override
    public final void setValue(Object obj, Object value) {
        if (this.isPrimitive() && value == null) {
            return;
        }
        switch (this.typeEnum) {
            case INT: {
                this.setInt(obj, Conversions.toInt(value));
                return;
            }
            case LONG: {
                this.setLong(obj, Conversions.toLong(value));
                return;
            }
            case BOOLEAN: {
                this.setBoolean(obj, Conversions.toBoolean(value));
                return;
            }
            case BYTE: {
                this.setByte(obj, Conversions.toByte(value));
                return;
            }
            case SHORT: {
                this.setShort(obj, Conversions.toShort(value));
                return;
            }
            case CHAR: {
                this.setChar(obj, Conversions.toChar(value));
                return;
            }
            case DOUBLE: {
                this.setDouble(obj, Conversions.toDouble(value));
                return;
            }
            case FLOAT: {
                this.setFloat(obj, Conversions.toFloat(value));
                return;
            }
            case DATE: {
                this.setObject(obj, Conversions.toDate(value));
                return;
            }
            case STRING: {
                if (value instanceof String) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toString(value));
                }
                return;
            }
            case ENUM: {
                if (value.getClass() == this.type) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toEnum(this.type, value));
                }
                return;
            }
            case BIG_DECIMAL: {
                if (value instanceof BigDecimal) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toBigDecimal(value));
                }
                return;
            }
            case NUMBER: {
                if (value instanceof Number) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toDouble(value));
                }
                return;
            }
            case BIG_INT: {
                if (value instanceof BigInteger) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toBigInteger(value));
                }
                return;
            }
            case COLLECTION: 
            case LIST: 
            case SET: {
                this.setObject(obj, Conversions.toCollection(this.type, value));
                return;
            }
            case CURRENCY: {
                if (value instanceof Currency) {
                    this.setObject(obj, value);
                } else {
                    this.setObject(obj, Conversions.toCurrency(value));
                }
                return;
            }
        }
        if (value == null) {
            this.setObject(obj, null);
            return;
        }
        if (value.getClass() == this.type) {
            this.setObject(obj, value);
            return;
        }
        if (this.type.isInstance(value)) {
            this.setObject(obj, value);
            return;
        }
        Object object = Conversions.coerce(this.typeEnum, this.type, value);
        if (object == null) {
            Exceptions.die(new Object[]{"Unable to convert", value, "to", this.typeEnum, this.type});
            return;
        }
        if (object.getClass() == this.type) {
            this.setObject(obj, object);
            return;
        }
        if (this.type.isInstance(object)) {
            this.setObject(obj, object);
            return;
        }
        if (object != null) {
            Exceptions.die(Str.sputs("Unable to set value into field after conversion was called", this, "converted value", object, "original value", value, "field", this, "converted object type", object.getClass()));
        }
    }

    @Override
    public final void setFromValue(Object obj, Value value) {
        if (value == ValueContainer.NULL) {
            this.setObject(obj, null);
            return;
        }
        switch (this.typeEnum) {
            case INT: {
                this.setInt(obj, value.intValue());
                return;
            }
            case LONG: {
                this.setLong(obj, value.longValue());
                return;
            }
            case BOOLEAN: {
                this.setBoolean(obj, value.booleanValue());
                return;
            }
            case BYTE: {
                this.setByte(obj, value.byteValue());
                return;
            }
            case SHORT: {
                this.setShort(obj, value.shortValue());
                return;
            }
            case CHAR: {
                this.setChar(obj, value.charValue());
                return;
            }
            case DOUBLE: {
                this.setDouble(obj, value.doubleValue());
                return;
            }
            case FLOAT: {
                this.setFloat(obj, value.floatValue());
                return;
            }
            case INTEGER_WRAPPER: {
                this.setObject(obj, value.intValue());
                return;
            }
            case LONG_WRAPPER: {
                this.setObject(obj, value.longValue());
                return;
            }
            case BOOLEAN_WRAPPER: {
                this.setObject(obj, value.booleanValue());
                return;
            }
            case BYTE_WRAPPER: {
                this.setObject(obj, value.byteValue());
                return;
            }
            case SHORT_WRAPPER: {
                this.setObject(obj, value.shortValue());
                return;
            }
            case CHAR_WRAPPER: {
                this.setObject(obj, Character.valueOf(value.charValue()));
                return;
            }
            case DOUBLE_WRAPPER: {
                this.setObject(obj, value.doubleValue());
                return;
            }
            case FLOAT_WRAPPER: {
                this.setObject(obj, Float.valueOf(value.floatValue()));
                return;
            }
            case STRING: 
            case CHAR_SEQUENCE: {
                this.setObject(obj, value.stringValue());
                return;
            }
            case BIG_DECIMAL: {
                this.setObject(obj, value.bigDecimalValue());
                return;
            }
            case BIG_INT: {
                this.setObject(obj, value.bigIntegerValue());
                return;
            }
            case DATE: {
                this.setObject(obj, value.dateValue());
                return;
            }
            case ENUM: {
                this.setObject(obj, value.toEnum(this.type));
                return;
            }
            case CURRENCY: {
                this.setObject(obj, value.currencyValue());
                return;
            }
        }
        this.setValue(obj, value.toValue());
    }

    @Override
    public final ParameterizedType getParameterizedType() {
        return this.parameterizedType;
    }

    @Override
    public final Class<?> getComponentClass() {
        return this.componentClass;
    }

    protected void analyzeError(Exception e, Object obj) {
        Exceptions.handle(Str.lines(e.getClass().getName(), String.format("cause %s", e.getCause()), String.format("Field info name %s, type %s, class that declared field %s", this.name(), this.type(), this.getField().getDeclaringClass()), String.format("TypeType of object passed %s", obj.getClass().getName())), (Throwable)e);
    }

    @Override
    public final boolean hasAnnotation(String annotationName) {
        return this.annotationMap.containsKey(annotationName);
    }

    @Override
    public final Map<String, Object> getAnnotationData(String annotationName) {
        return this.annotationMap.get(annotationName);
    }

    @Override
    public final boolean isPrimitive() {
        return this.bits.get(0);
    }

    @Override
    public final TypeType typeEnum() {
        return this.typeEnum;
    }

    @Override
    public final boolean isFinal() {
        return this.bits.get(1);
    }

    @Override
    public final boolean isStatic() {
        return this.bits.get(2);
    }

    @Override
    public final boolean isVolatile() {
        return this.bits.get(3);
    }

    @Override
    public final boolean isQualified() {
        return this.bits.get(4);
    }

    @Override
    public final boolean isReadOnly() {
        return this.bits.get(5);
    }

    @Override
    public boolean isWriteOnly() {
        return this.bits.get(8);
    }

    @Override
    public final Class<?> type() {
        return this.type;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final String alias() {
        return this.alias;
    }

    public String toString() {
        return "FieldInfo [name=" + this.name + ", type=" + this.type + ", parentType=" + this.parentType + "]";
    }

    @Override
    public final boolean isViewActive(String activeView) {
        if (this.includedViews == null && this.ignoreWithViews == null) {
            return true;
        }
        if (this.includedViews != null) {
            return this.includedViews.contains(activeView);
        }
        if (this.ignoreWithViews != null) {
            return !this.ignoreWithViews.contains(activeView);
        }
        return true;
    }

    @Override
    public final boolean include() {
        return this.bits.get(6);
    }

    @Override
    public final boolean ignore() {
        return this.bits.get(7);
    }

    @Override
    public boolean injectable() {
        return this.bits.get(9);
    }

    @Override
    public boolean requiresInjection() {
        return this.bits.get(11);
    }

    @Override
    public boolean isNamed() {
        return this.bits.get(10);
    }

    @Override
    public boolean hasAlias() {
        return this.bits.get(10);
    }

    @Override
    public String named() {
        return this.alias;
    }

    @Override
    public Object parent() {
        return this.parentType;
    }

    @Override
    public Class<?> declaringParent() {
        return this.parentType;
    }

    @Override
    public TypeType componentType() {
        return this.componentType;
    }
}

