/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core.reflection.fields;

import io.advantageous.boon.core.reflection.Reflection;
import io.advantageous.boon.core.reflection.fields.FieldAccess;
import io.advantageous.boon.core.reflection.fields.FieldsAccessor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FieldsAccessorFieldThenProp
implements FieldsAccessor {
    private final Map<Class<?>, Map<String, FieldAccess>> fieldMap = new ConcurrentHashMap();
    private final boolean useAlias;
    private final boolean caseInsensitive;

    public FieldsAccessorFieldThenProp(boolean useAlias) {
        this(useAlias, false);
    }

    public FieldsAccessorFieldThenProp(boolean useAlias, boolean caseInsensitive) {
        this.useAlias = useAlias;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public final Map<String, FieldAccess> getFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> map = this.fieldMap.get(aClass);
        if (map == null) {
            map = this.doGetFields(aClass);
            this.fieldMap.put(aClass, map);
        }
        return map;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    private final Map<String, FieldAccess> doGetFields(Class<? extends Object> aClass) {
        Map<String, FieldAccess> fieldAccessMap;
        Map<String, FieldAccess> mapOld = fieldAccessMap = Reflection.getPropertyFieldAccessMapFieldFirstForSerializer(aClass);
        fieldAccessMap = new LinkedHashMap<String, FieldAccess>();
        for (Map.Entry<String, FieldAccess> entry : mapOld.entrySet()) {
            if (entry.getValue().isStatic()) continue;
            fieldAccessMap.put(entry.getKey(), entry.getValue());
        }
        if (this.caseInsensitive) {
            mapOld = fieldAccessMap;
            fieldAccessMap = new LinkedHashMap<String, FieldAccess>();
            for (Map.Entry<String, FieldAccess> entry : mapOld.entrySet()) {
                if (entry.getValue().isStatic()) continue;
                fieldAccessMap.put(entry.getKey().toLowerCase(), entry.getValue());
                fieldAccessMap.put(entry.getKey().toUpperCase(), entry.getValue());
                fieldAccessMap.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.useAlias) {
            LinkedHashMap<String, FieldAccess> fieldAccessMap2 = new LinkedHashMap<String, FieldAccess>(fieldAccessMap.size());
            for (FieldAccess fa : fieldAccessMap.values()) {
                if (fa.isStatic()) continue;
                String alias = fa.alias();
                if (this.caseInsensitive) {
                    alias = alias.toLowerCase();
                }
                fieldAccessMap2.put(alias, fa);
            }
            return fieldAccessMap2;
        }
        return fieldAccessMap;
    }
}

