/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core.value;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Dates;
import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.Value;
import io.advantageous.boon.core.reflection.FastStringUtils;
import io.advantageous.boon.primitive.CharBuf;
import io.advantageous.boon.primitive.CharScanner;
import io.advantageous.boon.primitive.Chr;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;

public class CharSequenceValue
implements Value,
CharSequence {
    private final TypeType type;
    private final boolean checkDate;
    private final boolean decodeStrings;
    private char[] buffer;
    private boolean chopped;
    private int startIndex;
    private int endIndex;
    private Object value;
    private static float[] fpowersOf10 = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f};

    public CharSequenceValue(boolean chop, TypeType type, int startIndex, int endIndex, char[] buffer, boolean encoded, boolean checkDate) {
        this.type = type;
        this.checkDate = checkDate;
        this.decodeStrings = encoded;
        if (chop) {
            try {
                this.buffer = Arrays.copyOfRange(buffer, startIndex, endIndex);
            }
            catch (Exception ex) {
                Exceptions.handle(ex);
            }
            this.startIndex = 0;
            this.endIndex = this.buffer.length;
            this.chopped = true;
        } else {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.buffer = buffer;
        }
    }

    @Override
    public String toString() {
        if (this.decodeStrings) {
            return this.stringValue();
        }
        if (this.startIndex == 0 && this.endIndex == this.buffer.length) {
            return FastStringUtils.noCopyStringFromCharsNoCheck(this.buffer);
        }
        return new String(this.buffer, this.startIndex, this.endIndex - this.startIndex);
    }

    @Override
    public final Object toValue() {
        return this.value != null ? this.value : (this.value = this.doToValue());
    }

    @Override
    public <T extends Enum> T toEnum(Class<T> cls) {
        switch (this.type) {
            case STRING: {
                return Conversions.toEnum(cls, this.stringValue());
            }
            case INT: 
            case INTEGER_WRAPPER: {
                return Conversions.toEnum(cls, this.intValue());
            }
            case NULL: {
                return null;
            }
        }
        Exceptions.die("toEnum " + cls + " value was " + this.stringValue());
        return null;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    private Object doToValue() {
        switch (this.type) {
            case DOUBLE: {
                return this.doubleValue();
            }
            case INT: 
            case INTEGER_WRAPPER: {
                if (CharScanner.isInteger(this.buffer, this.startIndex, this.endIndex - this.startIndex)) {
                    return this.intValue();
                }
                return this.longValue();
            }
            case STRING: {
                if (this.checkDate) {
                    Date date = null;
                    if (Dates.isISO8601QuickCheck(this.buffer, this.startIndex, this.endIndex)) {
                        if (Dates.isJsonDate(this.buffer, this.startIndex, this.endIndex)) {
                            date = Dates.fromJsonDate(this.buffer, this.startIndex, this.endIndex);
                        } else if (Dates.isISO8601(this.buffer, this.startIndex, this.endIndex)) {
                            date = Dates.fromISO8601(this.buffer, this.startIndex, this.endIndex);
                        } else {
                            return this.stringValue();
                        }
                        if (date == null) {
                            return this.stringValue();
                        }
                        return date;
                    }
                }
                return this.stringValue();
            }
        }
        Exceptions.die();
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Value)) {
            return false;
        }
        CharSequenceValue value1 = (CharSequenceValue)o;
        if (this.endIndex != value1.endIndex) {
            return false;
        }
        if (this.startIndex != value1.startIndex) {
            return false;
        }
        if (!Arrays.equals(this.buffer, value1.buffer)) {
            return false;
        }
        if (this.type != value1.type) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(value1.value) : value1.value != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.buffer != null ? Arrays.hashCode(this.buffer) : 0);
        result = 31 * result + this.startIndex;
        result = 31 * result + this.endIndex;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public final int length() {
        return this.buffer.length;
    }

    @Override
    public final char charAt(int index) {
        return this.buffer[index];
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return new CharSequenceValue(false, this.type, start, end, this.buffer, this.decodeStrings, this.checkDate);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.buffer, this.startIndex, this.endIndex - this.startIndex);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return new BigInteger(this.toString());
    }

    private static String decodeForSure(char[] chars, int start, int to) {
        CharBuf builder = CharBuf.create(to - start);
        builder.decodeJsonString(chars, start, to);
        return builder.toString();
    }

    private static String decodeForSure(CharBuf charBuf, char[] chars, int start, int to) {
        charBuf.recycle();
        charBuf.decodeJsonString(chars, start, to);
        return charBuf.toString();
    }

    @Override
    public String stringValue() {
        if (this.decodeStrings) {
            return CharSequenceValue.decodeForSure(this.buffer, this.startIndex, this.endIndex);
        }
        return this.toString();
    }

    @Override
    public String stringValue(CharBuf charBuf) {
        if (this.decodeStrings) {
            return CharSequenceValue.decodeForSure(charBuf, this.buffer, this.startIndex, this.endIndex);
        }
        return this.toString();
    }

    private static String decode(char[] chars, int start, int to) {
        if (!Chr.contains(chars, '\\', start, to - start)) {
            return new String(chars, start, to - start);
        }
        return CharSequenceValue.decodeForSure(chars, start, to);
    }

    @Override
    public String stringValueEncoded() {
        return CharSequenceValue.decode(this.buffer, this.startIndex, this.endIndex);
    }

    @Override
    public Date dateValue() {
        if (this.type == TypeType.STRING) {
            if (Dates.isISO8601QuickCheck(this.buffer, this.startIndex, this.endIndex)) {
                if (Dates.isJsonDate(this.buffer, this.startIndex, this.endIndex)) {
                    return Dates.fromJsonDate(this.buffer, this.startIndex, this.endIndex);
                }
                if (Dates.isISO8601Jackson(this.buffer, this.startIndex, this.endIndex)) {
                    return Dates.fromISO8601Jackson(this.buffer, this.startIndex, this.endIndex);
                }
                if (Dates.isISO8601(this.buffer, this.startIndex, this.endIndex)) {
                    return Dates.fromISO8601(this.buffer, this.startIndex, this.endIndex);
                }
                throw new IllegalStateException("Unable to convert " + this.stringValue() + " to date ");
            }
            throw new IllegalStateException("Unable to convert " + this.stringValue() + " to date ");
        }
        return new Date(Dates.utc(this.longValue()));
    }

    @Override
    public int intValue() {
        if (CharScanner.isInteger(this.buffer, this.startIndex, this.endIndex - this.startIndex)) {
            return CharScanner.parseInt(this.buffer, this.startIndex, this.endIndex);
        }
        return Exceptions.die(Integer.TYPE, "not an int");
    }

    @Override
    public long longValue() {
        if (CharScanner.isLong(this.buffer, this.startIndex, this.endIndex - this.startIndex)) {
            return CharScanner.parseLong(this.buffer, this.startIndex, this.endIndex);
        }
        return Exceptions.die(Integer.TYPE, "not a long").intValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public double doubleValue() {
        return CharScanner.parseDouble(this.buffer, this.startIndex, this.endIndex);
    }

    @Override
    public boolean booleanValue() {
        return Boolean.parseBoolean(this.toString());
    }

    @Override
    public float floatValue() {
        return CharScanner.parseFloat(this.buffer, this.startIndex, this.endIndex);
    }

    @Override
    public Currency currencyValue() {
        return Currency.getInstance(this.toString());
    }

    @Override
    public final void chop() {
        if (!this.chopped) {
            this.chopped = true;
            this.buffer = Arrays.copyOfRange(this.buffer, this.startIndex, this.endIndex);
            this.startIndex = 0;
            this.endIndex = this.buffer.length;
        }
    }

    @Override
    public char charValue() {
        return this.buffer[this.startIndex];
    }

    @Override
    public TypeType type() {
        return TypeType.CHAR_SEQUENCE;
    }
}

