/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.primitive;

import io.advantageous.boon.primitive.Byt;
import io.advantageous.boon.primitive.Input;
import java.nio.charset.StandardCharsets;

public class InputByteArray
implements Input {
    private final byte[] array;
    private int location;

    public InputByteArray(byte[] array) {
        this.array = array;
    }

    @Override
    public void readFully(byte[] readToThis) {
        Byt._idx(readToThis, 0, this.array, this.location, readToThis.length);
        this.location += readToThis.length;
    }

    @Override
    public void readFully(byte[] readToThis, int off, int len) {
        Byt._idx(readToThis, off, this.array, this.location, len);
        this.location += readToThis.length;
    }

    @Override
    public int skipBytes(int n) {
        return this.location += n;
    }

    @Override
    public void location(int n) {
        this.location = n;
    }

    @Override
    public int location() {
        return this.location;
    }

    @Override
    public void reset() {
        this.location = 0;
    }

    @Override
    public boolean readBoolean() {
        byte val = Byt.idx(this.array, this.location);
        ++this.location;
        return val != 0;
    }

    @Override
    public byte readByte() {
        byte value = Byt.idx(this.array, this.location);
        ++this.location;
        return value;
    }

    @Override
    public short readUnsignedByte() {
        short value = Byt.idxUnsignedByte(this.array, this.location);
        ++this.location;
        return value;
    }

    @Override
    public short readShort() {
        short value = Byt.idxShort(this.array, this.location);
        this.location += 2;
        return value;
    }

    @Override
    public int readUnsignedShort() {
        int value = Byt.idxUnsignedShort(this.array, this.location);
        this.location += 2;
        return value;
    }

    @Override
    public char readChar() {
        char value = Byt.idxChar(this.array, this.location);
        this.location += 2;
        return value;
    }

    @Override
    public int readInt() {
        int value = Byt.idxInt(this.array, this.location);
        this.location += 4;
        return value;
    }

    @Override
    public long readUnsignedInt() {
        long value = Byt.idxUnsignedInt(this.array, this.location);
        this.location += 4;
        return value;
    }

    @Override
    public long readLong() {
        long value = Byt.idxLong(this.array, this.location);
        this.location += 8;
        return value;
    }

    @Override
    public float readFloat() {
        float value = Byt.idxFloat(this.array, this.location);
        this.location += 4;
        return value;
    }

    @Override
    public double readDouble() {
        double value = Byt.idxDouble(this.array, this.location);
        this.location += 8;
        return value;
    }

    @Override
    public String readSmallString() {
        short size = this.readUnsignedByte();
        byte[] bytes = this.readBytes(size);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public String readMediumString() {
        int size = this.readUnsignedShort();
        byte[] bytes = this.readBytes(size);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public String readLargeString() {
        int size = this.readInt();
        byte[] bytes = this.readBytes(size);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readSmallByteArray() {
        short size = this.readUnsignedByte();
        byte[] bytes = this.readBytes(size);
        return bytes;
    }

    @Override
    public byte[] readMediumByteArray() {
        int size = this.readUnsignedShort();
        byte[] bytes = this.readBytes(size);
        return bytes;
    }

    @Override
    public short[] readSmallShortArray() {
        short size = this.readUnsignedByte();
        return this.doReadShortArray(size);
    }

    private short[] doReadShortArray(int size) {
        short[] values = new short[size];
        for (int index = 0; index < values.length; ++index) {
            values[index] = this.readShort();
        }
        return values;
    }

    @Override
    public short[] readLargeShortArray() {
        int size = this.readInt();
        return this.doReadShortArray(size);
    }

    @Override
    public short[] readMediumShortArray() {
        int size = this.readUnsignedShort();
        return this.doReadShortArray(size);
    }

    @Override
    public byte[] readLargeByteArray() {
        int size = this.readInt();
        byte[] bytes = this.readBytes(size);
        return bytes;
    }

    @Override
    public byte[] readBytes(int size) {
        byte[] bytes = new byte[size];
        this.readFully(bytes);
        return bytes;
    }

    @Override
    public int[] readSmallIntArray() {
        short size = this.readUnsignedByte();
        return this.doReadIntArray(size);
    }

    private int[] doReadIntArray(int size) {
        int[] values = new int[size];
        for (int index = 0; index < values.length; ++index) {
            values[index] = this.readInt();
        }
        return values;
    }

    @Override
    public int[] readLargeIntArray() {
        int size = this.readInt();
        return this.doReadIntArray(size);
    }

    @Override
    public int[] readMediumIntArray() {
        int size = this.readUnsignedShort();
        return this.doReadIntArray(size);
    }

    @Override
    public long[] readSmallLongArray() {
        short size = this.readUnsignedByte();
        return this.doReadLongArray(size);
    }

    private long[] doReadLongArray(int size) {
        long[] values = new long[size];
        for (int index = 0; index < values.length; ++index) {
            values[index] = this.readLong();
        }
        return values;
    }

    @Override
    public long[] readLargeLongArray() {
        int size = this.readInt();
        return this.doReadLongArray(size);
    }

    @Override
    public long[] readMediumLongArray() {
        int size = this.readUnsignedShort();
        return this.doReadLongArray(size);
    }

    @Override
    public float[] readSmallFloatArray() {
        short size = this.readUnsignedByte();
        return this.doReadFloatArray(size);
    }

    @Override
    public float[] readLargeFloatArray() {
        int size = this.readInt();
        return this.doReadFloatArray(size);
    }

    @Override
    public float[] readMediumFloatArray() {
        int size = this.readUnsignedShort();
        return this.doReadFloatArray(size);
    }

    private float[] doReadFloatArray(int size) {
        float[] values = new float[size];
        for (int index = 0; index < values.length; ++index) {
            values[index] = this.readFloat();
        }
        return values;
    }

    @Override
    public double[] readSmallDoubleArray() {
        short size = this.readUnsignedByte();
        return this.doReadDoubleArray(size);
    }

    @Override
    public double[] readLargeDoubleArray() {
        int size = this.readInt();
        return this.doReadDoubleArray(size);
    }

    @Override
    public double[] readMediumDoubleArray() {
        int size = this.readUnsignedShort();
        return this.doReadDoubleArray(size);
    }

    private double[] doReadDoubleArray(int size) {
        double[] values = new double[size];
        for (int index = 0; index < values.length; ++index) {
            values[index] = this.readDouble();
        }
        return values;
    }
}

