/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt;

import io.advantageous.reakt.impl.BreakerImpl;
import java.util.function.Consumer;

public interface Breaker<T> {
    public static final Breaker OPENED = new BreakerImpl();

    public static <T> Breaker<T> broken() {
        return Breaker.opened();
    }

    public static <T> Breaker<T> opened() {
        Breaker t = OPENED;
        return t;
    }

    public static <T> Breaker<T> operational(T value) {
        return new BreakerImpl<T>(value);
    }

    public static <T> Breaker<T> operational(T value, int maxErrorsCount) {
        return new BreakerImpl<T>(value, maxErrorsCount);
    }

    public boolean isBroken();

    public boolean isOperational();

    default public boolean isOk() {
        return this.isOperational();
    }

    public Breaker<T> ifOperational(Consumer<? super T> var1);

    default public Breaker<T> ifOk(Consumer<? super T> consumer) {
        return this.ifOperational(consumer);
    }

    public Breaker<T> ifBroken(Runnable var1);

    public Breaker<T> cleanup(Consumer<? super T> var1);

    public long errorCount();
}

