/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt;

import io.advantageous.reakt.Result;
import io.advantageous.reakt.impl.ResultImpl;
import java.util.function.Consumer;

public interface Callback<T>
extends Consumer<T> {
    public void onResult(Result<T> var1);

    default public void reject(Throwable error) {
        this.onResult(new ResultImpl(error));
    }

    default public void reject(String errorMessage) {
        this.onResult(new ResultImpl(new IllegalStateException(errorMessage)));
    }

    default public void reject(String errorMessage, Throwable error) {
        this.reject(new IllegalStateException(errorMessage, error));
    }

    default public void reply(T result) {
        this.onResult(new ResultImpl(result));
    }

    default public void replyDone() {
        this.onResult(Result.doneResult());
    }

    default public void resolve() {
        this.replyDone();
    }

    default public void resolve(T result) {
        this.reply(result);
    }

    @Override
    default public void accept(T t) {
        this.reply(t);
    }

    default public Consumer<Throwable> errorConsumer() {
        return this::reject;
    }

    default public Consumer<T> consumer() {
        return this;
    }
}

