/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt;

import io.advantageous.reakt.impl.ExpectedImpl;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Expected<T> {
    public static final Expected EMPTY = new ExpectedImpl();

    public static <T> Expected<T> empty() {
        Expected t = EMPTY;
        return t;
    }

    public static <T> Expected<T> of(T value) {
        return new ExpectedImpl<T>(value);
    }

    public static <T> Expected<T> ofNullable(T value) {
        return value == null ? Expected.empty() : Expected.of(value);
    }

    public static <T> Expected<T> ofOptional(Optional<T> value) {
        return !value.isPresent() ? Expected.empty() : Expected.of(value.get());
    }

    public T get();

    public boolean isPresent();

    public boolean isEmpty();

    public Expected<T> ifPresent(Consumer<? super T> var1);

    public Expected<T> ifEmpty(Runnable var1);

    public Expected<T> filter(Predicate<? super T> var1);

    public <U> Expected<U> map(Function<? super T, ? extends U> var1);

    public T orElse(T var1);

    public boolean equalsValue(Object var1);
}

