/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt;

import io.advantageous.reakt.Callback;
import io.advantageous.reakt.Stream;

public interface Observer<T> {
    public static <T> Callback<T> callback(Observer<T> observer) {
        return result -> {
            if (result.success()) {
                observer.onNext(result.get());
            } else {
                observer.onError(result.cause());
            }
            observer.onCompleted();
        };
    }

    public static <T> Stream<T> stream(Observer<T> observer) {
        return result -> {
            if (result.success()) {
                observer.onNext(result.get());
            } else {
                observer.onError(result.cause());
            }
            if (result.complete()) {
                observer.onCompleted();
            }
        };
    }

    public void onCompleted();

    public void onError(Throwable var1);

    public void onNext(T var1);
}

