/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt;

import io.advantageous.reakt.Expected;
import io.advantageous.reakt.StreamResult;
import io.advantageous.reakt.impl.StreamResultImpl;
import java.util.function.Consumer;

public interface Stream<T> {
    public void onNext(StreamResult<T> var1);

    default public void complete(T result) {
        this.onNext(new StreamResultImpl(result, true, Expected.empty(), Expected.empty()));
    }

    default public void reply(T result) {
        this.onNext(new StreamResultImpl(result, false, Expected.empty(), Expected.empty()));
    }

    default public void reply(T result, boolean done) {
        this.onNext(new StreamResultImpl(result, done, Expected.empty(), Expected.empty()));
    }

    default public void reply(T result, boolean done, Runnable cancelHandler) {
        this.onNext(new StreamResultImpl(result, done, Expected.of(cancelHandler), Expected.empty()));
    }

    default public void reply(T result, boolean done, Runnable cancelHandler, Consumer<Long> wantsMore) {
        this.onNext(new StreamResultImpl(result, done, Expected.of(cancelHandler), Expected.of(wantsMore)));
    }

    default public void fail(Throwable error) {
        this.onNext(new StreamResultImpl(error, true, Expected.empty(), Expected.empty()));
    }

    default public void fail(String errorMessage) {
        this.onNext(new StreamResultImpl(new IllegalStateException(errorMessage), true, Expected.empty(), Expected.empty()));
    }
}

