/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.impl;

import io.advantageous.reakt.Breaker;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class BreakerImpl<T>
implements Breaker<T> {
    private final T service;
    private final AtomicLong errors = new AtomicLong();
    private final int maxErrorCount;

    public BreakerImpl() {
        this.maxErrorCount = 0;
        this.service = null;
    }

    public BreakerImpl(T value) {
        this.maxErrorCount = 0;
        this.service = Objects.requireNonNull(value);
    }

    public BreakerImpl(T value, int maxErrorCount) {
        this.service = Objects.requireNonNull(value);
        this.maxErrorCount = maxErrorCount;
    }

    @Override
    public boolean isOperational() {
        return this.service != null && this.maxErrorCount == 0 || this.errorCount() < (long)this.maxErrorCount;
    }

    @Override
    public boolean isBroken() {
        return !this.isOperational();
    }

    @Override
    public Breaker<T> ifOperational(Consumer<? super T> consumer) {
        try {
            if (this.isOperational()) {
                consumer.accept(this.service);
            }
            return this;
        }
        catch (Exception ex) {
            this.errors.incrementAndGet();
            throw new IllegalStateException("Operation failed", ex);
        }
    }

    @Override
    public Breaker<T> ifBroken(Runnable runnable) {
        if (this.isBroken()) {
            runnable.run();
        }
        return this;
    }

    @Override
    public Breaker<T> cleanup(Consumer<? super T> consumer) {
        if (this.isBroken() && this.service != null) {
            consumer.accept(this.service);
        }
        return this;
    }

    @Override
    public long errorCount() {
        return this.errors.get();
    }
}

