/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.impl;

import io.advantageous.reakt.Expected;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ExpectedImpl<T>
implements Expected<T> {
    private final T value;

    public ExpectedImpl() {
        this.value = null;
    }

    public ExpectedImpl(T value) {
        this.value = Objects.requireNonNull(value);
    }

    @Override
    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    @Override
    public boolean isPresent() {
        return this.value != null;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public Expected<T> ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
        return this;
    }

    @Override
    public Expected<T> ifEmpty(Runnable runnable) {
        if (this.value == null) {
            runnable.run();
        }
        return this;
    }

    @Override
    public Expected<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : Expected.empty();
    }

    @Override
    public <U> Expected<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Expected.empty();
        }
        return Expected.ofNullable(mapper.apply(this.value));
    }

    @Override
    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Expected)) {
            return false;
        }
        ExpectedImpl otherValue = (ExpectedImpl)other;
        return Objects.equals(this.value, otherValue.value);
    }

    @Override
    public boolean equalsValue(Object other) {
        return Objects.equals(this.value, other);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return "Expected{value=" + this.value + '}';
    }
}

