/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.impl;

import io.advantageous.reakt.Expected;
import io.advantageous.reakt.Result;
import java.util.function.Consumer;

public class ResultImpl<T>
implements Result<T> {
    private final Object object;

    public ResultImpl(Object object) {
        this.object = object;
    }

    @Override
    public Result<T> thenExpect(Consumer<Expected<T>> consumer) {
        if (this.success()) {
            consumer.accept(this.expect());
        }
        return this;
    }

    @Override
    public Result<T> then(Consumer<T> consumer) {
        if (this.success()) {
            consumer.accept(this.get());
        }
        return this;
    }

    @Override
    public Result<T> catchError(Consumer<Throwable> handler) {
        if (this.failure()) {
            handler.accept(this.cause());
        }
        return this;
    }

    @Override
    public boolean success() {
        return !(this.object instanceof Throwable);
    }

    @Override
    public boolean complete() {
        return true;
    }

    @Override
    public boolean failure() {
        return this.object instanceof Throwable;
    }

    @Override
    public Throwable cause() {
        return this.object instanceof Throwable ? (Throwable)this.object : null;
    }

    @Override
    public Expected<T> expect() {
        if (this.failure()) {
            throw new IllegalStateException(this.cause());
        }
        return Expected.ofNullable(this.object);
    }

    @Override
    public T get() {
        if (this.failure()) {
            throw new IllegalStateException(this.cause());
        }
        return (T)this.object;
    }

    @Override
    public T orElse(T other) {
        return (T)(this.success() ? this.object : other);
    }
}

