/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.promise;

import io.advantageous.reakt.promise.Promise;
import io.advantageous.reakt.promise.ReplayPromise;
import io.advantageous.reakt.promise.impl.AllBlockingPromise;
import io.advantageous.reakt.promise.impl.AllPromise;
import io.advantageous.reakt.promise.impl.AllReplayPromise;
import io.advantageous.reakt.promise.impl.AnyBlockingPromise;
import io.advantageous.reakt.promise.impl.AnyPromise;
import io.advantageous.reakt.promise.impl.AnyReplayPromise;
import io.advantageous.reakt.promise.impl.BasePromise;
import io.advantageous.reakt.promise.impl.BlockingPromise;
import io.advantageous.reakt.promise.impl.InvokerPromise;
import io.advantageous.reakt.promise.impl.ReplayPromiseImpl;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public interface Promises {
    public static <T> Promise<T> promise() {
        return new BasePromise();
    }

    public static Promise<Void> all(Promise<?> ... promises) {
        return new AllPromise(promises);
    }

    public static <T> Promise<Void> all(List<Promise<T>> promises) {
        return Promises.all(promises.toArray(new Promise[promises.size()]));
    }

    public static Promise<Void> any(Promise<?> ... promises) {
        return new AnyPromise(promises);
    }

    public static <T> Promise<Void> any(List<Promise<T>> promises) {
        return Promises.any(promises.toArray(new Promise[promises.size()]));
    }

    public static Promise<Void> allBlocking(Promise<?> ... promises) {
        return new AllBlockingPromise(promises);
    }

    public static <T> Promise<Void> allBlocking(List<Promise<T>> promises) {
        return Promises.allBlocking(promises.toArray(new Promise[promises.size()]));
    }

    public static Promise<Void> anyBlocking(Promise<?> ... promises) {
        return new AnyBlockingPromise(promises);
    }

    public static <T> Promise<Void> anyBlocking(List<Promise<T>> promises) {
        return Promises.anyBlocking(promises.toArray(new Promise[promises.size()]));
    }

    public static ReplayPromise<Void> allReplay(Duration timeout, long time, Promise<?> ... promises) {
        return new AllReplayPromise(timeout, time, promises);
    }

    public static <T> ReplayPromise<Void> allReplay(Duration timeout, long time, List<Promise<T>> promises) {
        return Promises.allReplay(timeout, time, promises.toArray(new Promise[promises.size()]));
    }

    public static ReplayPromise<Void> allReplay(Duration timeout, Promise<?> ... promises) {
        return Promises.allReplay(timeout, System.currentTimeMillis(), promises);
    }

    public static <T> ReplayPromise<Void> allReplay(Duration timeout, List<Promise<T>> promises) {
        return Promises.allReplay(timeout, System.currentTimeMillis(), promises.toArray(new Promise[promises.size()]));
    }

    public static ReplayPromise<Void> anyReplay(Duration timeout, long time, Promise<?> ... promises) {
        return new AnyReplayPromise(timeout, time, promises);
    }

    public static <T> ReplayPromise<Void> anyReplay(Duration timeout, long time, List<Promise<T>> promises) {
        return new AnyReplayPromise(timeout, time, promises.toArray(new Promise[promises.size()]));
    }

    public static ReplayPromise<Void> anyReplay(Duration timeout, Promise<?> ... promises) {
        return Promises.anyReplay(timeout, System.currentTimeMillis(), promises);
    }

    public static <T> ReplayPromise<Void> anyReplay(Duration timeout, List<Promise<T>> promises) {
        return Promises.anyReplay(timeout, System.currentTimeMillis(), promises.toArray(new Promise[promises.size()]));
    }

    public static <T> ReplayPromise<T> replayPromise(Duration timeout, long time) {
        return new ReplayPromiseImpl(timeout, time);
    }

    public static <T> ReplayPromise<T> replayPromise(Duration timeout) {
        return new ReplayPromiseImpl(timeout, System.currentTimeMillis());
    }

    public static <T> Promise<T> blockingPromise() {
        return new BlockingPromise();
    }

    public static <T> Promise<T> blockingPromise(Duration duration) {
        return new BlockingPromise(duration);
    }

    public static Promise<String> promiseString() {
        return new BasePromise<String>();
    }

    public static Promise<Integer> promiseInt() {
        return new BasePromise<Integer>();
    }

    public static Promise<Long> promiseLong() {
        return new BasePromise<Long>();
    }

    public static Promise<Double> promiseDouble() {
        return new BasePromise<Double>();
    }

    public static Promise<Float> promiseFloat() {
        return new BasePromise<Float>();
    }

    public static Promise<Void> promiseNotify() {
        return new BasePromise<Void>();
    }

    public static Promise<Boolean> promiseBoolean() {
        return new BasePromise<Boolean>();
    }

    public static <T> Promise<T> promise(Class<T> cls) {
        return new BasePromise();
    }

    public static <T> Promise<List<T>> promiseList(Class<T> componentType) {
        return new BasePromise<List<T>>();
    }

    public static <T> Promise<Collection<T>> promiseCollection(Class<T> componentType) {
        return new BasePromise<Collection<T>>();
    }

    public static <K, V> Promise<Map<K, V>> promiseMap(Class<K> keyType, Class<V> valueType) {
        return new BasePromise<Map<K, V>>();
    }

    public static <T> Promise<Set<T>> promiseSet(Class<T> componentType) {
        return new BasePromise<Set<T>>();
    }

    public static ReplayPromise<String> replayPromiseString(Duration timeout, long time) {
        return new ReplayPromiseImpl<String>(timeout, time);
    }

    public static ReplayPromise<Integer> replayPromiseInt(Duration timeout, long time) {
        return new ReplayPromiseImpl<Integer>(timeout, time);
    }

    public static ReplayPromise<Long> replayPromiseLong(Duration timeout, long time) {
        return new ReplayPromiseImpl<Long>(timeout, time);
    }

    public static ReplayPromise<Double> replayPromiseDouble(Duration timeout, long time) {
        return new ReplayPromiseImpl<Double>(timeout, time);
    }

    public static ReplayPromise<Float> replayPromiseFloat(Duration timeout, long time) {
        return new ReplayPromiseImpl<Float>(timeout, time);
    }

    public static ReplayPromise<Void> replayPromiseNotify(Duration timeout, long time) {
        return new ReplayPromiseImpl<Void>(timeout, time);
    }

    public static ReplayPromise<Boolean> replayPromiseBoolean(Duration timeout, long time) {
        return new ReplayPromiseImpl<Boolean>(timeout, time);
    }

    public static <T> ReplayPromise<T> replayPromise(Class<T> cls, Duration timeout, long time) {
        return new ReplayPromiseImpl(timeout, time);
    }

    public static <T> ReplayPromise<List<T>> replayPromiseList(Class<T> componentType, Duration timeout, long time) {
        return new ReplayPromiseImpl<List<T>>(timeout, time);
    }

    public static <T> ReplayPromise<Collection<T>> replayPromiseCollection(Class<T> componentType, Duration timeout, long time) {
        return new ReplayPromiseImpl<Collection<T>>(timeout, time);
    }

    public static <K, V> ReplayPromise<Map<K, V>> replayPromiseMap(Class<K> keyType, Class<V> valueType, Duration timeout, long time) {
        return new ReplayPromiseImpl<Map<K, V>>(timeout, time);
    }

    public static <T> ReplayPromise<Set<T>> replayPromiseSet(Class<T> componentType, Duration timeout, long time) {
        return new ReplayPromiseImpl<Set<T>>(timeout, time);
    }

    public static Promise<String> blockingPromiseString(Duration duration) {
        return new BlockingPromise<String>(duration);
    }

    public static Promise<Integer> blockingPromiseInt(Duration duration) {
        return new BlockingPromise<Integer>(duration);
    }

    public static Promise<Long> blockingPromiseLong(Duration duration) {
        return new BlockingPromise<Long>(duration);
    }

    public static Promise<Double> blockingPromiseDouble(Duration duration) {
        return new BlockingPromise<Double>(duration);
    }

    public static Promise<Float> blockingPromiseFloat(Duration duration) {
        return new BlockingPromise<Float>(duration);
    }

    public static Promise<Void> blockingPromiseNotify(Duration duration) {
        return new BlockingPromise<Void>(duration);
    }

    public static Promise<Boolean> blockingPromiseBoolean(Duration duration) {
        return new BlockingPromise<Boolean>(duration);
    }

    public static <T> Promise<T> blockingPromise(Class<T> cls, Duration duration) {
        return new BlockingPromise(duration);
    }

    public static <T> Promise<List<T>> blockingPromiseList(Class<T> componentType, Duration duration) {
        return new BlockingPromise<List<T>>(duration);
    }

    public static <T> Promise<Collection<T>> blockingPromiseCollection(Class<T> componentType, Duration duration) {
        return new BlockingPromise<Collection<T>>(duration);
    }

    public static <K, V> Promise<Map<K, V>> blockingPromiseMap(Class<K> keyType, Class<V> valueType, Duration duration) {
        return new BlockingPromise<Map<K, V>>(duration);
    }

    public static <T> Promise<Set<T>> blockingPromiseSet(Class<T> componentType, Duration duration) {
        return new BlockingPromise<Set<T>>(duration);
    }

    public static Promise<String> blockingPromiseString() {
        return new BlockingPromise<String>();
    }

    public static Promise<Integer> blockingPromiseInt() {
        return new BlockingPromise<Integer>();
    }

    public static Promise<Long> blockingPromiseLong() {
        return new BlockingPromise<Long>();
    }

    public static Promise<Double> blockingPromiseDouble() {
        return new BlockingPromise<Double>();
    }

    public static Promise<Float> blockingPromiseFloat() {
        return new BlockingPromise<Float>();
    }

    public static Promise<Void> blockingPromiseNotify() {
        return new BlockingPromise<Void>();
    }

    public static Promise<Boolean> blockingPromiseBoolean() {
        return new BlockingPromise<Boolean>();
    }

    public static <T> Promise<T> blockingPromise(Class<T> cls) {
        return new BlockingPromise();
    }

    public static <T> Promise<List<T>> blockingPromiseList(Class<T> componentType) {
        return new BlockingPromise<List<T>>();
    }

    public static <T> Promise<Collection<T>> blockingPromiseCollection(Class<T> componentType) {
        return new BlockingPromise<Collection<T>>();
    }

    public static <K, V> Promise<Map<K, V>> blockingPromiseMap(Class<K> keyType, Class<V> valueType) {
        return new BlockingPromise<Map<K, V>>();
    }

    public static <T> Promise<Set<T>> blockingPromiseSet(Class<T> componentType) {
        return new BlockingPromise<Set<T>>();
    }

    public static <T> Promise<T> invokablePromise(Consumer<Promise<T>> promiseConsumer) {
        return new InvokerPromise<T>(promiseConsumer);
    }
}

