/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.promise.impl;

import io.advantageous.reakt.Expected;
import io.advantageous.reakt.Result;
import io.advantageous.reakt.promise.Promise;
import io.advantageous.reakt.promise.impl.FinalPromise;
import io.advantageous.reakt.promise.impl.PromiseUtil;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class BasePromise<T>
implements Promise<T> {
    protected final AtomicReference<Result<T>> result = new AtomicReference();
    protected Expected<Consumer<T>> thenConsumer = Expected.empty();
    protected Expected<Consumer<Throwable>> catchConsumer = Expected.empty();
    protected Expected<Consumer<Expected<T>>> thenValueConsumer = Expected.empty();
    protected Expected<List<Consumer<Promise<T>>>> completeListeners = Expected.empty();

    public static <T> Promise<T> provideFinalPromise(Promise<T> promise) {
        if (promise instanceof BasePromise) {
            BasePromise basePromise = (BasePromise)promise;
            return new FinalPromise<T>(basePromise.thenConsumer, basePromise.catchConsumer, basePromise.thenValueConsumer, basePromise.completeListeners);
        }
        throw new IllegalStateException("Operation not supported use FinalPromise directly");
    }

    @Override
    public synchronized Promise<T> then(Consumer<T> consumer) {
        this.thenConsumer = Expected.of(consumer);
        return this;
    }

    @Override
    public Promise<T> whenComplete(Consumer<Promise<T>> doneListener) {
        if (this.completeListeners.isEmpty()) {
            this.completeListeners = Expected.of(new CopyOnWriteArrayList());
        }
        this.completeListeners.get().add(doneListener);
        return this;
    }

    @Override
    public synchronized Promise<T> thenExpect(Consumer<Expected<T>> consumer) {
        this.thenValueConsumer = Expected.of(consumer);
        return this;
    }

    @Override
    public Promise<T> catchError(Consumer<Throwable> consumer) {
        this.catchConsumer = Expected.of(consumer);
        return this;
    }

    @Override
    public boolean success() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.result.get().success();
    }

    @Override
    public boolean complete() {
        return this.result.get() != null;
    }

    @Override
    public boolean failure() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.result.get().failure();
    }

    @Override
    public Throwable cause() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.result.get().cause();
    }

    @Override
    public Expected<T> expect() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        if (this.failure()) {
            throw new IllegalStateException(this.cause());
        }
        return this.result.get().expect();
    }

    @Override
    public T get() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        if (this.failure()) {
            throw new IllegalStateException(this.cause());
        }
        return this.result.get().get();
    }

    @Override
    public T orElse(T other) {
        if (!this.complete()) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.success() ? this.result.get().get() : other;
    }

    @Override
    public void onResult(Result<T> result) {
        this.doOnResult(result);
    }

    protected void doOnResult(Result<T> result) {
        this.result.set(result);
        if (result.success()) {
            this.thenConsumer.ifPresent(consumer -> consumer.accept(result.get()));
            this.thenValueConsumer.ifPresent(valueConsumer -> valueConsumer.accept(result.expect()));
        } else {
            this.catchConsumer.ifPresent(catchConsumer -> catchConsumer.accept(result.cause()));
        }
        this.completeListeners.ifPresent(runnables -> runnables.forEach(promiseConsumer -> promiseConsumer.accept(this)));
    }

    @Override
    public <U> Promise<U> thenMap(Function<? super T, ? extends U> mapper) {
        return PromiseUtil.mapPromise(this, mapper);
    }
}

