/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.promise.impl;

import io.advantageous.reakt.Expected;
import io.advantageous.reakt.Result;
import io.advantageous.reakt.promise.Promise;
import io.advantageous.reakt.promise.Promises;
import io.advantageous.reakt.promise.impl.BasePromise;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class BlockingPromise<T>
extends BasePromise<T> {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final Expected<Duration> duration;

    public BlockingPromise() {
        this.duration = Expected.empty();
    }

    public BlockingPromise(Duration duration) {
        this.duration = Expected.of(duration);
    }

    @Override
    public void onResult(Result<T> result) {
        super.onResult(result);
        this.countDownLatch.countDown();
    }

    @Override
    public Expected<T> expect() {
        this.await();
        return super.expect();
    }

    @Override
    public T get() {
        this.await();
        return super.get();
    }

    @Override
    public Throwable cause() {
        this.await();
        return super.cause();
    }

    @Override
    public boolean failure() {
        this.await();
        return super.failure();
    }

    @Override
    public boolean success() {
        this.await();
        return super.success();
    }

    private void doAwait(Callable<Void> runnable) {
        try {
            runnable.call();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected boolean _success() {
        return super.success();
    }

    private void await() {
        this.duration.ifPresent(duration1 -> this.doAwait(() -> {
            this.countDownLatch.await(duration1.toMillis(), TimeUnit.MILLISECONDS);
            return null;
        })).ifEmpty(() -> this.doAwait(() -> {
            this.countDownLatch.await();
            return null;
        }));
    }

    @Override
    public <U> Promise<U> thenMap(Function<? super T, ? extends U> mapper) {
        Promise mappedPromise = Promises.blockingPromise();
        this.whenComplete(p -> {
            BlockingPromise promise = (BlockingPromise)p;
            if (promise._success()) {
                Object t = ((Result)promise.result.get()).get();
                Object mapped = mapper.apply((Object)t);
                mappedPromise.reply(mapped);
            } else {
                mappedPromise.reject(promise.cause());
            }
        });
        return mappedPromise;
    }
}

