/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.promise.impl;

import io.advantageous.reakt.Expected;
import io.advantageous.reakt.Result;
import io.advantageous.reakt.promise.Promise;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class FinalPromise<T>
implements Promise<T> {
    protected final Expected<List<Consumer<Promise<T>>>> completeListeners;
    protected final AtomicReference<Result<T>> result = new AtomicReference();
    protected final Expected<Consumer<T>> thenConsumer;
    protected final Expected<Consumer<Throwable>> catchConsumer;
    protected final Expected<Consumer<Expected<T>>> thenValueConsumer;

    public FinalPromise(Expected<Consumer<T>> thenConsumer, Expected<Consumer<Throwable>> catchConsumer, Expected<Consumer<Expected<T>>> thenValueConsumer, Expected<List<Consumer<Promise<T>>>> completeListeners) {
        this.thenConsumer = thenConsumer;
        this.catchConsumer = catchConsumer;
        this.thenValueConsumer = thenValueConsumer;
        this.completeListeners = completeListeners;
    }

    protected void doFail(Throwable cause) {
        this.catchConsumer.ifPresent(catchConsumer -> catchConsumer.accept(cause));
    }

    protected void doThen(T value) {
        this.thenConsumer.ifPresent(consumer -> consumer.accept(value));
    }

    @Override
    public Promise<T> then(Consumer<T> consumer) {
        throw new UnsupportedOperationException("then(..) not supported for final promise");
    }

    @Override
    public Promise<T> whenComplete(Consumer<Promise<T>> doneListener) {
        throw new UnsupportedOperationException("whenComplete(..) not supported for final promise");
    }

    @Override
    public synchronized Promise<T> thenExpect(Consumer<Expected<T>> consumer) {
        throw new UnsupportedOperationException("thenExpect(..) not supported for final promise");
    }

    @Override
    public Promise<T> catchError(Consumer<Throwable> consumer) {
        throw new UnsupportedOperationException("catchError(..) not supported for final promise");
    }

    @Override
    public boolean success() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.result.get().success();
    }

    @Override
    public boolean complete() {
        return this.result.get() != null;
    }

    @Override
    public boolean failure() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.result.get().failure();
    }

    @Override
    public Throwable cause() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.result.get().cause();
    }

    @Override
    public Expected<T> expect() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        if (this.failure()) {
            throw new IllegalStateException(this.cause());
        }
        return this.result.get().expect();
    }

    @Override
    public T get() {
        if (this.result.get() == null) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        if (this.failure()) {
            throw new IllegalStateException(this.cause());
        }
        return this.result.get().get();
    }

    @Override
    public void onResult(Result<T> result) {
        this.result.set(result);
        if (result.success()) {
            this.doThen(result.get());
            this.doThenValue(result);
        } else {
            this.doFail(result.cause());
        }
        this.completeListeners.ifPresent(runnables -> runnables.forEach(promiseConsumer -> promiseConsumer.accept(this)));
    }

    protected void doThenValue(Result<T> result) {
        this.thenValueConsumer.ifPresent(valueConsumer -> valueConsumer.accept(result.expect()));
    }

    @Override
    public <U> Promise<U> thenMap(Function<? super T, ? extends U> mapper) {
        throw new UnsupportedOperationException("then(..) not supported for final promise");
    }

    @Override
    public T orElse(T other) {
        if (!this.complete()) {
            throw new NoSuchElementException("No value present, result not returned.");
        }
        return this.success() ? this.result.get().get() : other;
    }
}

