/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.promise.impl;

import io.advantageous.reakt.Result;
import io.advantageous.reakt.promise.Promise;
import io.advantageous.reakt.promise.Promises;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;

public interface PromiseUtil {
    public static <T> void all(Promise<T> parent, Promise<T>[] childPromises) {
        AtomicInteger count = new AtomicInteger(childPromises.length);
        Consumer consumer = childPromise -> {
            if (childPromise.failure()) {
                parent.reject(childPromise.cause());
                count.set(0);
            } else {
                int currentCount = count.decrementAndGet();
                if (currentCount <= 0) {
                    parent.onResult(Result.result(null));
                }
            }
        };
        for (Promise childPromise2 : childPromises) {
            childPromise2.whenComplete(consumer);
        }
    }

    public static <T> void any(Promise<T> parent, Promise<T>[] childPromises) {
        AtomicBoolean done = new AtomicBoolean();
        Consumer runnable = childPromise -> {
            if (childPromise.failure()) {
                if (done.compareAndSet(false, true)) {
                    parent.reject(childPromise.cause());
                }
            } else if (done.compareAndSet(false, true)) {
                parent.reject(childPromise.cause());
            }
        };
        for (Promise childPromise2 : childPromises) {
            childPromise2.whenComplete(runnable);
        }
    }

    public static <T, U> Promise<U> mapPromise(Promise<T> thisPromise, Function<? super T, ? extends U> mapper) {
        Promise mappedPromise = Promises.promise();
        thisPromise.whenComplete(promise -> {
            if (promise.success()) {
                Object mapped = mapper.apply((Object)promise.get());
                mappedPromise.reply(mapped);
            } else {
                mappedPromise.reject(promise.cause());
            }
        });
        return mappedPromise;
    }
}

