/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.promise.impl;

import io.advantageous.reakt.Expected;
import io.advantageous.reakt.Result;
import io.advantageous.reakt.impl.ResultImpl;
import io.advantageous.reakt.promise.Promise;
import io.advantageous.reakt.promise.ReplayPromise;
import io.advantageous.reakt.promise.impl.BasePromise;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class ReplayPromiseImpl<T>
extends BasePromise<T>
implements ReplayPromise<T> {
    private final Duration timeoutDuration;
    private final long startTime;
    private Expected<Runnable> timeoutHandler;
    private Expected<Consumer<ReplayPromise>> afterResultProcessedHandler = Expected.empty();

    public ReplayPromiseImpl(Duration timeout, long startTime) {
        this.timeoutDuration = timeout;
        this.startTime = startTime;
    }

    @Override
    public void onResult(Result<T> result) {
        this.result.compareAndSet(null, result);
        this.afterResultProcessedHandler.ifPresent(replayPromiseConsumer -> replayPromiseConsumer.accept(this));
    }

    @Override
    public boolean check(long time) {
        Result theResult;
        if (this.result.get() == null && time - this.startTime > this.timeoutDuration.toMillis()) {
            this.handleTimeout(time);
        }
        if ((theResult = (Result)this.result.get()) != null) {
            this.handleResultPresent(theResult);
            return true;
        }
        return false;
    }

    private void handleResultPresent(Result<T> theResult) {
        this.doOnResult(theResult);
    }

    private void handleTimeout(long time) {
        this.timeoutHandler.ifPresent(Runnable::run);
        this.result.set(new ResultImpl(new TimeoutException(String.format("Operation timed out start time %d timeout duration ms %d time %d elapsed time %d", this.startTime, this.timeoutDuration.toMillis(), time, time - this.startTime))));
    }

    @Override
    public synchronized ReplayPromise<T> onTimeout(Runnable handler) {
        this.timeoutHandler = Expected.of(handler);
        return this;
    }

    @Override
    public synchronized ReplayPromise<T> afterResultProcessed(Consumer<ReplayPromise> handler) {
        this.afterResultProcessedHandler = Expected.of(handler);
        return this;
    }

    @Override
    public Promise<T> freeze() {
        throw new IllegalStateException("Freeze (freeze()) only makes sense for callback and blocking promises because replay promises are only accessed from one thread so mutability is ok.");
    }
}

