/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.reactor;

import io.advantageous.reakt.promise.Promise;
import io.advantageous.reakt.reactor.TimeSource;
import io.advantageous.reakt.reactor.impl.ReactorImpl;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Reactor {
    public static Reactor reactor() {
        return Reactor.reactor(Duration.ofSeconds(30L));
    }

    public static Reactor reactor(Duration timeout) {
        return Reactor.reactor(timeout, System::currentTimeMillis);
    }

    public static Reactor reactor(Duration timeout, TimeSource timeSource) {
        return new ReactorImpl(timeout, timeSource);
    }

    public <T> Promise<T> promise();

    public Promise<Void> all(Promise<?> ... var1);

    public Promise<Void> all(Duration var1, Promise<?> ... var2);

    public <T> Promise<Void> all(List<Promise<T>> var1);

    public <T> Promise<Void> all(Duration var1, List<Promise<T>> var2);

    public Promise<Void> any(Promise<?> ... var1);

    public Promise<Void> any(Duration var1, Promise<?> ... var2);

    public <T> Promise<Void> any(List<Promise<T>> var1);

    public <T> Promise<Void> any(Duration var1, List<Promise<T>> var2);

    public void addRepeatingTask(Duration var1, Runnable var2);

    public void runTaskAfter(Duration var1, Runnable var2);

    public void deferRun(Runnable var1);

    public void process();

    public Promise<String> promiseString();

    public Promise<Integer> promiseInt();

    public Promise<Long> promiseLong();

    public Promise<Double> promiseDouble();

    public Promise<Float> promiseFloat();

    public Promise<Void> promiseNotify();

    public Promise<Boolean> promiseBoolean();

    public <T> Promise<T> promise(Class<T> var1);

    public <T> Promise<List<T>> promiseList(Class<T> var1);

    public <T> Promise<Collection<T>> promiseCollection(Class<T> var1);

    public <K, V> Promise<Map<K, V>> promiseMap(Class<K> var1, Class<V> var2);

    public <T> Promise<Set<T>> promiseSet(Class<T> var1);
}

