/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.reakt.reactor.impl;

import io.advantageous.reakt.promise.Promise;
import io.advantageous.reakt.promise.Promises;
import io.advantageous.reakt.promise.ReplayPromise;
import io.advantageous.reakt.reactor.Reactor;
import io.advantageous.reakt.reactor.TimeSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.stream.Collectors;

public class ReactorImpl
implements Reactor {
    private final Duration defaultTimeout;
    private final TimeSource timeSource;
    private final BlockingQueue<ReplayPromise> promisesQueue = new LinkedTransferQueue<ReplayPromise>();
    private final BlockingQueue<Runnable> deferRuns = new LinkedTransferQueue<Runnable>();
    private final List<ReplayPromise> notCompletedPromises = new ArrayList<ReplayPromise>();
    private List<FireOnceTask> fireOnceAfterTasks = new ArrayList<FireOnceTask>(1);
    private long currentTime;
    private List<RepeatingTask> repeatingTasks = new ArrayList<RepeatingTask>(1);

    public ReactorImpl(Duration defaultTimeout, TimeSource timeSource) {
        this.defaultTimeout = defaultTimeout;
        this.timeSource = timeSource;
    }

    @Override
    public <T> Promise<T> promise() {
        ReplayPromise promise = Promises.replayPromise(this.defaultTimeout, this.timeSource.getTime());
        return this.addPromiseToProcessingQueue(promise);
    }

    @Override
    public Promise<Void> all(Promise<?> ... promises) {
        return this.all(this.defaultTimeout, promises);
    }

    @Override
    public Promise<Void> all(Duration timeout, Promise<?> ... promises) {
        return this.addPromiseToProcessingQueue(Promises.allReplay(timeout, this.timeSource.getTime(), promises));
    }

    @Override
    public <T> Promise<Void> all(List<Promise<T>> promises) {
        return this.all(this.defaultTimeout, promises);
    }

    @Override
    public <T> Promise<Void> all(Duration timeout, List<Promise<T>> promises) {
        return this.addPromiseToProcessingQueue(Promises.allReplay(timeout, this.timeSource.getTime(), promises));
    }

    @Override
    public Promise<Void> any(Promise<?> ... promises) {
        return this.any(this.defaultTimeout, promises);
    }

    @Override
    public Promise<Void> any(Duration timeout, Promise<?> ... promises) {
        return this.addPromiseToProcessingQueue(Promises.anyReplay(timeout, this.timeSource.getTime(), promises));
    }

    @Override
    public <T> Promise<Void> any(List<Promise<T>> promises) {
        return this.any(this.defaultTimeout, promises);
    }

    @Override
    public <T> Promise<Void> any(Duration timeout, List<Promise<T>> promises) {
        return this.addPromiseToProcessingQueue(Promises.anyReplay(timeout, this.timeSource.getTime(), promises));
    }

    @Override
    public void addRepeatingTask(Duration interval, Runnable runnable) {
        this.repeatingTasks.add(new RepeatingTask(runnable, interval.toMillis()));
    }

    @Override
    public void runTaskAfter(Duration afterInterval, Runnable runnable) {
        this.fireOnceAfterTasks.add(new FireOnceTask(runnable, afterInterval.toMillis()));
    }

    @Override
    public void deferRun(Runnable runnable) {
        this.deferRuns.add(runnable);
    }

    @Override
    public void process() {
        this.currentTime = this.timeSource.getTime();
        this.processReplayPromises();
        this.processDeferRuns();
        this.processRepeatingTasks();
        this.processFireOnceTasks();
    }

    @Override
    public Promise<String> promiseString() {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseString(this.defaultTimeout, this.currentTime));
    }

    @Override
    public Promise<Integer> promiseInt() {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseInt(this.defaultTimeout, this.currentTime));
    }

    @Override
    public Promise<Long> promiseLong() {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseLong(this.defaultTimeout, this.currentTime));
    }

    @Override
    public Promise<Double> promiseDouble() {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseDouble(this.defaultTimeout, this.currentTime));
    }

    @Override
    public Promise<Float> promiseFloat() {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseFloat(this.defaultTimeout, this.currentTime));
    }

    @Override
    public Promise<Void> promiseNotify() {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseNotify(this.defaultTimeout, this.currentTime));
    }

    @Override
    public Promise<Boolean> promiseBoolean() {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseBoolean(this.defaultTimeout, this.currentTime));
    }

    @Override
    public <T> Promise<T> promise(Class<T> cls) {
        return this.addPromiseToProcessingQueue(Promises.replayPromise(cls, this.defaultTimeout, this.currentTime));
    }

    @Override
    public <T> Promise<List<T>> promiseList(Class<T> componentType) {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseList(componentType, this.defaultTimeout, this.currentTime));
    }

    @Override
    public <T> Promise<Collection<T>> promiseCollection(Class<T> componentType) {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseCollection(componentType, this.defaultTimeout, this.currentTime));
    }

    @Override
    public <K, V> Promise<Map<K, V>> promiseMap(Class<K> keyType, Class<V> valueType) {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseMap(keyType, valueType, this.defaultTimeout, this.currentTime));
    }

    @Override
    public <T> Promise<Set<T>> promiseSet(Class<T> componentType) {
        return this.addPromiseToProcessingQueue(Promises.replayPromiseSet(componentType, this.defaultTimeout, this.currentTime));
    }

    private void processDeferRuns() {
        Runnable runnable = (Runnable)this.deferRuns.poll();
        while (runnable != null) {
            runnable.run();
            runnable = (Runnable)this.deferRuns.poll();
        }
    }

    private void processReplayPromises() {
        this.notCompletedPromises.clear();
        ReplayPromise poll = (ReplayPromise)this.promisesQueue.poll();
        while (poll != null) {
            poll.check(this.timeSource.getTime());
            if (!poll.complete()) {
                this.notCompletedPromises.add(poll);
            }
            poll = (ReplayPromise)this.promisesQueue.poll();
        }
        this.promisesQueue.addAll(this.notCompletedPromises);
        this.notCompletedPromises.clear();
    }

    private <T> Promise<T> addPromiseToProcessingQueue(ReplayPromise<T> promise) {
        promise.afterResultProcessed(this.promisesQueue::add);
        return promise;
    }

    public void processRepeatingTasks() {
        this.repeatingTasks.forEach(repeatingTask -> {
            if (this.currentTime - ((RepeatingTask)repeatingTask).lastTimeInvoked > ((RepeatingTask)repeatingTask).repeatEveryMS) {
                ((RepeatingTask)repeatingTask).lastTimeInvoked = this.currentTime;
                ((RepeatingTask)repeatingTask).task.run();
            }
        });
    }

    public void processFireOnceTasks() {
        List<FireOnceTask> fireOnceTasks = this.fireOnceAfterTasks.stream().filter(fireOnceTask -> this.currentTime - ((FireOnceTask)fireOnceTask).created > ((FireOnceTask)fireOnceTask).fireAfterMS).collect(Collectors.toList());
        fireOnceTasks.forEach(fireOnceTask -> ((FireOnceTask)fireOnceTask).task.run());
        this.fireOnceAfterTasks.removeAll(fireOnceTasks);
    }

    class FireOnceTask {
        private final Runnable task;
        private final long fireAfterMS;
        private final long created;

        public FireOnceTask(Runnable task, long fireAfterMS) {
            this.task = task;
            this.created = ReactorImpl.this.currentTime;
            this.fireAfterMS = fireAfterMS;
        }
    }

    class RepeatingTask {
        private final Runnable task;
        private final long repeatEveryMS;
        private long lastTimeInvoked;

        public RepeatingTask(Runnable task, long repeatEveryMS) {
            this.task = task;
            this.repeatEveryMS = repeatEveryMS;
        }
    }
}

