/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia;

import io.antmedia.AppSettings;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.Vod;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.muxer.IMuxerListener;
import io.antmedia.rest.BroadcastRestService;
import io.antmedia.social.endpoint.PeriscopeEndpoint;
import io.antmedia.social.endpoint.VideoServiceEndpoint;
import io.antmedia.streamsource.StreamFetcher;
import io.antmedia.streamsource.StreamFetcherManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.red5.server.adapter.MultiThreadedApplicationAdapter;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.red5.server.api.stream.IBroadcastStream;
import org.red5.server.api.stream.IStreamPublishSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntMediaApplicationAdapter
extends MultiThreadedApplicationAdapter
implements IMuxerListener {
    public static final String BEAN_NAME = "web.handler";
    public static final String BROADCAST_STATUS_CREATED = "created";
    public static final String BROADCAST_STATUS_BROADCASTING = "broadcasting";
    public static final String BROADCAST_STATUS_FINISHED = "finished";
    public static final String HOOK_ACTION_END_LIVE_STREAM = "liveStreamEnded";
    public static final String HOOK_ACTION_START_LIVE_STREAM = "liveStreamStarted";
    public static final String HOOK_ACTION_VOD_READY = "vodReady";
    protected static Logger logger = LoggerFactory.getLogger(AntMediaApplicationAdapter.class);
    public static final String LIVE_STREAM = "liveStream";
    public static final String IP_CAMERA = "ipCamera";
    public static final String STREAM_SOURCE = "streamSource";
    protected static final int END_POINT_LIMIT = 20;
    public static final String FACEBOOK = "facebook";
    public static final String PERISCOPE = "periscope";
    public static final String YOUTUBE = "youtube";
    public static final String FACEBOOK_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.FacebookEndpoint";
    public static final String YOUTUBE_ENDPOINT_CLASS = "io.antmedia.enterprise.social.endpoint.YoutubeEndpoint";
    private List<VideoServiceEndpoint> videoServiceEndpoints = new ArrayList<VideoServiceEndpoint>();
    private List<VideoServiceEndpoint> videoServiceEndpointsHavingError = new ArrayList<VideoServiceEndpoint>();
    private List<IStreamPublishSecurity> streamPublishSecurityList;
    private HashMap<String, OnvifCamera> onvifCameraList = new HashMap();
    private StreamFetcherManager streamFetcherManager;
    private IDataStore dataStore;
    private AppSettings appSettings;

    @Override
    public boolean appStart(final IScope app) {
        if (this.getStreamPublishSecurityList() != null) {
            for (IStreamPublishSecurity streamPublishSecurity : this.getStreamPublishSecurityList()) {
                this.registerStreamPublishSecurity(streamPublishSecurity);
            }
        }
        this.addScheduledOnceJob(0L, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                AntMediaApplicationAdapter.this.streamFetcherManager = new StreamFetcherManager(AntMediaApplicationAdapter.this, AntMediaApplicationAdapter.this.dataStore, app);
                AntMediaApplicationAdapter.this.streamFetcherManager.setRestartStreamFetcherPeriod(AntMediaApplicationAdapter.this.appSettings.getRestartStreamFetcherPeriod());
                List streams = AntMediaApplicationAdapter.this.getDataStore().getExternalStreamsList();
                AntMediaApplicationAdapter.this.streamFetcherManager.startStreams(streams);
                List socialEndpoints = AntMediaApplicationAdapter.this.dataStore.getSocialEndpoints(0, 20);
                for (SocialEndpointCredentials socialEndpointCredentials : socialEndpoints) {
                    VideoServiceEndpoint endPointService = null;
                    if (socialEndpointCredentials.getServiceName().equals(AntMediaApplicationAdapter.FACEBOOK)) {
                        endPointService = AntMediaApplicationAdapter.this.getEndpointService(AntMediaApplicationAdapter.FACEBOOK_ENDPOINT_CLASS, socialEndpointCredentials, AntMediaApplicationAdapter.this.appSettings.getFacebookClientId(), AntMediaApplicationAdapter.this.appSettings.getFacebookClientSecret());
                    } else if (socialEndpointCredentials.getServiceName().equals(AntMediaApplicationAdapter.PERISCOPE)) {
                        endPointService = new PeriscopeEndpoint(AntMediaApplicationAdapter.this.appSettings.getPeriscopeClientId(), AntMediaApplicationAdapter.this.appSettings.getPeriscopeClientSecret(), AntMediaApplicationAdapter.this.dataStore, socialEndpointCredentials);
                    } else if (socialEndpointCredentials.getServiceName().equals(AntMediaApplicationAdapter.YOUTUBE)) {
                        endPointService = AntMediaApplicationAdapter.this.getEndpointService(AntMediaApplicationAdapter.YOUTUBE_ENDPOINT_CLASS, socialEndpointCredentials, AntMediaApplicationAdapter.this.appSettings.getYoutubeClientId(), AntMediaApplicationAdapter.this.appSettings.getYoutubeClientSecret());
                    }
                    if (endPointService == null) continue;
                    AntMediaApplicationAdapter.this.videoServiceEndpoints.add(endPointService);
                }
                if (AntMediaApplicationAdapter.this.appSettings != null) {
                    AntMediaApplicationAdapter.this.synchUserVoDFolder(null, AntMediaApplicationAdapter.this.appSettings.getVodFolder());
                }
            }
        });
        return super.appStart(app);
    }

    public boolean synchUserVoDFolder(String oldFolderPath, String vodFolderPath) {
        boolean result = false;
        File streamsFolder = new File("webapps/" + this.getScope().getName() + "/streams");
        try {
            this.deleteOldFolderPath(oldFolderPath, streamsFolder);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        File f = new File(vodFolderPath == null ? "" : vodFolderPath);
        try {
            if (!streamsFolder.exists()) {
                streamsFolder.mkdir();
            }
            if (f.exists() && f.isDirectory()) {
                String newLinkPath = streamsFolder.getAbsolutePath() + "/" + f.getName();
                File newLinkFile = new File(newLinkPath);
                if (!f.exists()) {
                    Path target = f.toPath();
                    Files.createSymbolicLink(newLinkFile.toPath(), target, new FileAttribute[0]);
                }
            }
            this.dataStore.fetchUserVodList(f);
            result = true;
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    public boolean deleteOldFolderPath(String oldFolderPath, File streamsFolder) throws IOException {
        boolean result = false;
        if (oldFolderPath != null && !oldFolderPath.isEmpty() && streamsFolder != null) {
            File f = new File(oldFolderPath);
            File linkFile = new File(streamsFolder.getAbsolutePath(), f.getName());
            if (linkFile.exists() && linkFile.isDirectory()) {
                Files.delete(linkFile.toPath());
                result = true;
            }
        }
        return result;
    }

    @Override
    public void streamBroadcastClose(IBroadcastStream stream) {
        String streamName = stream.getPublishedName();
        this.closeBroadcast(streamName);
        super.streamBroadcastClose(stream);
    }

    public void closeBroadcast(String streamName) {
        try {
            if (this.dataStore != null) {
                this.dataStore.updateStatus(streamName, BROADCAST_STATUS_FINISHED);
                Broadcast broadcast = this.dataStore.get(streamName);
                if (broadcast != null) {
                    List endPointList;
                    final String listenerHookURL = broadcast.getListenerHookURL();
                    final String streamId = broadcast.getStreamId();
                    if (listenerHookURL != null && listenerHookURL.length() > 0) {
                        final String name = broadcast.getName();
                        final String category = broadcast.getCategory();
                        this.addScheduledOnceJob(100L, new IScheduledJob(){

                            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                                AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_END_LIVE_STREAM, name, category, null);
                            }
                        });
                    }
                    if ((endPointList = broadcast.getEndPointList()) != null) {
                        for (Endpoint endpoint : endPointList) {
                            VideoServiceEndpoint videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.endpointServiceId);
                            if (videoServiceEndPoint == null) continue;
                            try {
                                videoServiceEndPoint.stopBroadcast(endpoint);
                            }
                            catch (Exception e) {
                                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                            }
                        }
                    }
                    if (endPointList != null) {
                        this.recreateEndpointsForSocialMedia(broadcast, endPointList);
                    }
                    if (broadcast.isZombi()) {
                        this.dataStore.delete(streamName);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void recreateEndpointsForSocialMedia(Broadcast broadcast, List<Endpoint> endPointList) {
        for (Endpoint endpoint : endPointList) {
            VideoServiceEndpoint videoServiceEndPoint;
            if (endpoint.type == null || endpoint.type.equals("") || (videoServiceEndPoint = this.getVideoServiceEndPoint(endpoint.endpointServiceId)) == null) continue;
            try {
                Endpoint newEndpoint = videoServiceEndPoint.createBroadcast(broadcast.getName(), broadcast.getDescription(), broadcast.isIs360(), broadcast.isPublicStream(), 720, true);
                this.getDataStore().removeEndpoint(broadcast.getStreamId(), endpoint);
                this.getDataStore().addEndpoint(broadcast.getStreamId(), newEndpoint);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public VideoServiceEndpoint getEndpointService(String className, SocialEndpointCredentials socialEndpointCredentials, String clientId, String clientSecret) {
        try {
            Class<?> endpointClass = Class.forName(className);
            VideoServiceEndpoint endPointService = (VideoServiceEndpoint)endpointClass.getConstructor(String.class, String.class, IDataStore.class, SocialEndpointCredentials.class).newInstance(clientId, clientSecret, this.dataStore, socialEndpointCredentials);
            return endPointService;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    @Override
    public void streamPublishStart(IBroadcastStream stream) {
        String streamName = stream.getPublishedName();
        this.startPublish(streamName);
        super.streamPublishStart(stream);
    }

    public void startPublish(final String streamName) {
        this.addScheduledOnceJob(0L, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                try {
                    if (AntMediaApplicationAdapter.this.dataStore != null) {
                        List endPointList;
                        Broadcast broadcast = AntMediaApplicationAdapter.this.dataStore.get(streamName);
                        if (broadcast == null) {
                            broadcast = AntMediaApplicationAdapter.this.saveZombiBroadcast(streamName);
                        } else {
                            boolean result = AntMediaApplicationAdapter.this.dataStore.updateStatus(streamName, AntMediaApplicationAdapter.BROADCAST_STATUS_BROADCASTING);
                            logger.info(" Status of stream {} is set to Broadcasting with result: {}", (Object)broadcast.getStreamId(), (Object)result);
                        }
                        final String listenerHookURL = broadcast.getListenerHookURL();
                        final String streamId = broadcast.getStreamId();
                        if (listenerHookURL != null && listenerHookURL.length() > 0) {
                            final String name = broadcast.getName();
                            final String category = broadcast.getCategory();
                            AntMediaApplicationAdapter.this.addScheduledOnceJob(100L, new IScheduledJob(){

                                public void execute(ISchedulingService service) throws CloneNotSupportedException {
                                    AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_START_LIVE_STREAM, name, category, null);
                                }
                            });
                        }
                        if ((endPointList = broadcast.getEndPointList()) != null) {
                            for (Endpoint endpoint : endPointList) {
                                VideoServiceEndpoint videoServiceEndPoint = AntMediaApplicationAdapter.this.getVideoServiceEndPoint(endpoint.endpointServiceId);
                                if (videoServiceEndPoint == null) continue;
                                try {
                                    videoServiceEndPoint.publishBroadcast(endpoint);
                                    AntMediaApplicationAdapter.this.log.info("publish broadcast called for " + videoServiceEndPoint.getName());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private Broadcast saveZombiBroadcast(String streamName) {
        Broadcast newBroadcast = new Broadcast();
        newBroadcast.setDate(Long.valueOf(System.currentTimeMillis()));
        newBroadcast.setZombi(true);
        try {
            newBroadcast.setStreamId(streamName);
            return BroadcastRestService.saveBroadcast(newBroadcast, BROADCAST_STATUS_BROADCASTING, this.getScope().getName(), this.dataStore, this.appSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public VideoServiceEndpoint getVideoServiceEndPoint(String id) {
        if (this.videoServiceEndpoints != null) {
            for (VideoServiceEndpoint serviceEndpoint : this.videoServiceEndpoints) {
                if (!serviceEndpoint.getCredentials().getId().equals(id)) continue;
                return serviceEndpoint;
            }
        }
        return null;
    }

    public void muxingFinished(final String streamId, File file, long duration) {
        int index;
        String regularExp;
        String name = file.getName();
        String filePath = file.getPath();
        long fileSize = file.length();
        long unixTime = System.currentTimeMillis();
        String streamName = "";
        if (this.dataStore != null && !name.matches(regularExp = "^.*_{1}[0-9]{3}p{1}\\.mp4{1}$") && (index = name.lastIndexOf(".mp4")) != -1) {
            String listenerHookURL;
            final String baseName = name.substring(0, index);
            this.dataStore.updateDuration(streamId, duration);
            Broadcast broadcast = this.dataStore.get(streamId);
            streamName = broadcast != null ? broadcast.getName() : file.getName();
            String[] subDirs = filePath.split(Pattern.quote(File.separator));
            Integer pathLength = subDirs.length;
            String relativePath = subDirs[pathLength - 3] + '/' + subDirs[pathLength - 2] + '/' + subDirs[pathLength - 1];
            String vodId = RandomStringUtils.randomNumeric((int)24);
            Vod newVod = new Vod(streamName, streamId, relativePath, name, unixTime, duration, fileSize, "streamVod", vodId);
            this.getDataStore().addVod(newVod);
            if (broadcast != null && (listenerHookURL = broadcast.getListenerHookURL()) != null && listenerHookURL.length() > 0) {
                this.addScheduledOnceJob(100L, new IScheduledJob(){

                    public void execute(ISchedulingService service) throws CloneNotSupportedException {
                        AntMediaApplicationAdapter.this.notifyHook(listenerHookURL, streamId, AntMediaApplicationAdapter.HOOK_ACTION_VOD_READY, null, null, baseName);
                    }
                });
            }
        }
    }

    public void startDeviceAuthStatusPolling(VideoServiceEndpoint videoServiceEndpoint, VideoServiceEndpoint.DeviceAuthParameters askDeviceAuthParameters) {
        int timeDelta = askDeviceAuthParameters.interval * 1000;
        this.addScheduledOnceJob(timeDelta, (IScheduledJob)new AuthCheckJob(0, timeDelta, videoServiceEndpoint, this));
    }

    public List<VideoServiceEndpoint> getVideoServiceEndpoints() {
        return this.videoServiceEndpoints;
    }

    public List<VideoServiceEndpoint> getVideoServiceEndpointsHavingError() {
        return this.videoServiceEndpointsHavingError;
    }

    public void setVideoServiceEndpoints(List<VideoServiceEndpoint> videoServiceEndpoints) {
        this.videoServiceEndpoints = videoServiceEndpoints;
    }

    public StringBuffer notifyHook(String url, String id, String action, String streamName, String category, String vodName) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("id", id);
        variables.put("action", action);
        if (streamName != null) {
            variables.put("streamName", streamName);
        }
        if (category != null) {
            variables.put("category", category);
        }
        if (vodName != null) {
            variables.put("vodName", vodName);
        }
        StringBuffer response = null;
        try {
            response = AntMediaApplicationAdapter.sendPOST(url, variables);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public static StringBuffer sendPOST(String url, Map<String, String> variables) throws IOException {
        StringBuffer response = null;
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String inputLine;
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("User-Agent", "Daaavuuuuuttttt https://www.youtube.com/watch?v=cbyTDRgW4Jg");
            ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = variables.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                urlParameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            UrlEncodedFormEntity postParams = new UrlEncodedFormEntity(urlParameters);
            httpPost.setEntity((HttpEntity)postParams);
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            System.out.println("POST Response Status:: " + httpResponse.getStatusLine().getStatusCode());
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            response = new StringBuffer();
            while ((inputLine = reader.readLine()) != null) {
                response.append(inputLine);
            }
            reader.close();
        }
        return response;
    }

    public List<IStreamPublishSecurity> getStreamPublishSecurityList() {
        return this.streamPublishSecurityList;
    }

    public void setStreamPublishSecurityList(List<IStreamPublishSecurity> streamPublishSecurityList) {
        this.streamPublishSecurityList = streamPublishSecurityList;
    }

    public AppSettings getAppSettings() {
        if (this.appSettings == null) {
            AppSettings appSettings = new AppSettings();
            appSettings.setMp4MuxingEnabled(true);
            appSettings.setAddDateTimeToMp4FileName(true);
            appSettings.setWebRTCEnabled(false);
            appSettings.setHlsMuxingEnabled(true);
            appSettings.setObjectDetectionEnabled(Boolean.valueOf(false));
            appSettings.setAdaptiveResolutionList(null);
            appSettings.setHlsListSize(null);
            appSettings.setHlsTime(null);
            appSettings.setHlsPlayListType(null);
            appSettings.setDeleteHLSFilesOnEnded(true);
            appSettings.setPreviewOverwrite(false);
            this.appSettings = appSettings;
        }
        return this.appSettings;
    }

    public void setAppSettings(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    public void sourceQualityChanged(final String id, final String quality) {
        String qualityChangedJobName = this.addScheduledOnceJob(0L, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                boolean updateSourceQuality = AntMediaApplicationAdapter.this.getDataStore().updateSourceQuality(id, quality);
                AntMediaApplicationAdapter.this.log.info("source stream {} quality changed, new quality is: {}  , updating data strore {}", new Object[]{id, quality, updateSourceQuality});
            }
        });
        logger.info("sourceQualityChanged job name: {}", (Object)qualityChangedJobName);
    }

    public void sourceSpeedChanged(final String id, final double speed) {
        String speedChangeJobName = this.addScheduledOnceJob(0L, new IScheduledJob(){

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                AntMediaApplicationAdapter.this.getDataStore().updateSourceSpeed(id, speed);
            }
        });
        logger.info("sourceSpeedChanged change name {}", (Object)speedChangeJobName);
    }

    public StreamFetcher startStreaming(Broadcast broadcast) {
        return this.streamFetcherManager.startStreaming(broadcast);
    }

    public void stopStreaming(Broadcast cam) {
        this.streamFetcherManager.stopStreaming(cam);
    }

    public OnvifCamera getOnvifCamera(String id) {
        Broadcast camera;
        OnvifCamera onvifCamera = this.onvifCameraList.get(id);
        if (onvifCamera == null && (camera = this.getDataStore().get(id)) != null) {
            onvifCamera = new OnvifCamera();
            onvifCamera.connect(camera.getIpAddr(), camera.getUsername(), camera.getPassword());
            this.onvifCameraList.put(id, onvifCamera);
        }
        return onvifCamera;
    }

    public StreamFetcherManager getStreamFetcherManager() {
        return this.streamFetcherManager;
    }

    public IDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    private static class AuthCheckJob
    implements IScheduledJob {
        private int count;
        private VideoServiceEndpoint videoServiceEndpoint;
        private int interval;
        private AntMediaApplicationAdapter appAdapter;

        public AuthCheckJob(int count, int interval, VideoServiceEndpoint videoServiceEndpoint, AntMediaApplicationAdapter adapter) {
            this.count = count;
            this.videoServiceEndpoint = videoServiceEndpoint;
            this.interval = interval;
            this.appAdapter = adapter;
        }

        public void execute(ISchedulingService service) throws CloneNotSupportedException {
            try {
                if (!this.videoServiceEndpoint.askIfDeviceAuthenticated()) {
                    ++this.count;
                    if (this.count < 10) {
                        if (this.videoServiceEndpoint.getError() == null) {
                            service.addScheduledOnceJob((long)this.interval, (IScheduledJob)new AuthCheckJob(this.count, this.interval, this.videoServiceEndpoint, this.appAdapter));
                            logger.info("Asking authetnication for {}", (Object)this.videoServiceEndpoint.getName());
                        } else {
                            this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        }
                    } else {
                        this.videoServiceEndpoint.setError("AUTHENTICATION_TIMEOUT");
                        this.appAdapter.getVideoServiceEndpointsHavingError().add(this.videoServiceEndpoint);
                        logger.info("Not authenticated for {} and will not try again", (Object)this.videoServiceEndpoint.getName());
                    }
                } else {
                    logger.info("Authenticated, adding video service endpoint {} to the app", (Object)this.videoServiceEndpoint.getName());
                    this.appAdapter.getVideoServiceEndpoints().add(this.videoServiceEndpoint);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

