/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Vod;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBStore
implements IDataStore {
    private DB db;
    private BTreeMap<String, String> map;
    private BTreeMap<String, String> vodMap;
    private BTreeMap<String, String> detectionMap;
    private BTreeMap<String, String> userVodMap;
    private BTreeMap<String, String> socialEndpointsCredentialsMap;
    private Gson gson;
    protected static Logger logger = LoggerFactory.getLogger(MapDBStore.class);
    private static final String MAP_NAME = "broadcast";
    private static final String VOD_MAP_NAME = "vod";
    private static final String DETECTION_MAP_NAME = "detection";
    private static final String USER_MAP_NAME = "userVod";
    private static final String SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME = "SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME";

    public MapDBStore(String dbName) {
        this.db = DBMaker.fileDB((String)dbName).fileMmapEnableIfSupported().closeOnJvmShutdown().make();
        this.map = this.db.treeMap(MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.vodMap = this.db.treeMap(VOD_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.detectionMap = this.db.treeMap(DETECTION_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.userVodMap = this.db.treeMap(USER_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        this.socialEndpointsCredentialsMap = this.db.treeMap(SOCIAL_ENDPONT_CREDENTIALS_MAP_NAME).keySerializer(Serializer.STRING).valueSerializer(Serializer.STRING).counterEnable().createOrOpen();
        GsonBuilder builder = new GsonBuilder();
        this.gson = builder.create();
    }

    public BTreeMap<String, String> getUserVodMap() {
        return this.userVodMap;
    }

    public void setUserVodMap(BTreeMap<String, String> userVodMap) {
        this.userVodMap = userVodMap;
    }

    public BTreeMap<String, String> getVodMap() {
        return this.vodMap;
    }

    public void setVodMap(BTreeMap<String, String> vodMap) {
        this.vodMap = vodMap;
    }

    public BTreeMap<String, String> getMap() {
        return this.map;
    }

    public void setMap(BTreeMap<String, String> map) {
        this.map = map;
    }

    public BTreeMap<String, String> getDetectionMap() {
        return this.detectionMap;
    }

    public void setDetectionMap(BTreeMap<String, String> detectionMap) {
        this.detectionMap = detectionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String save(Broadcast broadcast) {
        String streamId = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (broadcast != null) {
                try {
                    if (broadcast.getStreamId() == null) {
                        streamId = RandomStringUtils.randomNumeric((int)24);
                        broadcast.setStreamId(streamId);
                    }
                    streamId = broadcast.getStreamId();
                    String rtmpURL = broadcast.getRtmpURL();
                    if (rtmpURL != null) {
                        rtmpURL = rtmpURL + streamId;
                    }
                    broadcast.setRtmpURL(rtmpURL);
                    if (broadcast.getStatus() == null) {
                        broadcast.setStatus("created");
                    }
                    this.map.put((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                    this.db.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    streamId = null;
                }
            }
        }
        return streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Broadcast get(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                return (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateName(String id, String name, String description) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setName(name);
                broadcast.setDescription(description);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus(String id, String status) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setStatus(status);
                String jsonVal = this.gson.toJson((Object)broadcast);
                String previousValue = (String)this.map.replace((Object)id, (Object)jsonVal);
                this.db.commit();
                logger.debug("updateStatus replacing id {} having value {} to {}", new Object[]{id, previousValue, jsonVal});
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDuration(String id, long duration) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setDuration(Long.valueOf(duration));
                String jsonVal = this.gson.toJson((Object)broadcast);
                String previousValue = (String)this.map.replace((Object)id, (Object)jsonVal);
                this.db.commit();
                result = true;
                logger.debug("updateStatus replacing id {} having value {} to {}", new Object[]{id, previousValue, jsonVal});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
                if (endPointList == null) {
                    endPointList = new ArrayList<Endpoint>();
                }
                endPointList.add(endpoint);
                broadcast.setEndPointList(endPointList);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEndpoint(String id, Endpoint endpoint) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Broadcast broadcast;
            List endPointList;
            String jsonString;
            if (id != null && endpoint != null && (jsonString = (String)this.map.get((Object)id)) != null && (endPointList = (broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class)).getEndPointList()) != null) {
                Iterator iterator = endPointList.iterator();
                while (iterator.hasNext()) {
                    Endpoint endpointItem = (Endpoint)iterator.next();
                    if (!endpointItem.rtmpUrl.equals(endpoint.rtmpUrl)) continue;
                    iterator.remove();
                    result = true;
                    break;
                }
                if (result) {
                    broadcast.setEndPointList(endPointList);
                    this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                    this.db.commit();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setEndPointList(null);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBroadcastCount() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.map.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.map.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getBroadcastList(int offset, int size) {
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.map.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (String broadcastString : values) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add((Broadcast)this.gson.fromJson(broadcastString, Broadcast.class));
                if (++itemCount < size) continue;
                break;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Vod> getVodList(int offset, int size) {
        ArrayList<Vod> list = new ArrayList<Vod>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.vodMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (String vodString : values) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add((Vod)this.gson.fromJson(vodString, Vod.class));
                if (++itemCount < size) continue;
                break;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> filterBroadcastList(int offset, int size, String type) {
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            Object[] objectArray = this.map.getValues().toArray();
            Broadcast[] broadcastArray = new Broadcast[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
            }
            ArrayList<Object> filterList = new ArrayList<Object>();
            for (int i = 0; i < broadcastArray.length; ++i) {
                if (!broadcastArray[i].getType().equals(type)) continue;
                filterList.add(this.gson.fromJson((String)objectArray[i], Broadcast.class));
            }
            for (Broadcast broadcast : filterList) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add(broadcast);
                if (++itemCount < size) continue;
                break;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addVod(Vod vod) {
        String id = vod.getVodId();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (id != null) {
                try {
                    this.vodMap.put((Object)vod.getVodId(), (Object)this.gson.toJson((Object)vod));
                    this.db.commit();
                    logger.warn(Long.toString(vod.getCreationDate()));
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUserVod(Vod vod) {
        String vodId = null;
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (vod != null) {
                try {
                    vodId = RandomStringUtils.randomNumeric((int)24);
                    vod.setVodId(vodId);
                    this.vodMap.put((Object)vodId, (Object)this.gson.toJson((Object)vod));
                    this.db.commit();
                    result = true;
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Broadcast> getExternalStreamsList() {
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.map.getValues().toArray();
            Broadcast[] broadcastArray = new Broadcast[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                broadcastArray[i] = (Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class);
            }
            for (i = 0; i < broadcastArray.length; ++i) {
                if (!broadcastArray[i].getType().equals("ipCamera") && !broadcastArray[i].getType().equals("streamSource")) continue;
                streamsList.add((Broadcast)this.gson.fromJson((String)objectArray[i], Broadcast.class));
            }
        }
        return streamsList;
    }

    public void close() {
        this.db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteVod(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.vodMap.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalVodNumber() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.getVodMap().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            int i;
            Object[] objectArray = this.vodMap.getValues().toArray();
            Vod[] vodtArray = new Vod[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                vodtArray[i] = (Vod)this.gson.fromJson((String)objectArray[i], Vod.class);
            }
            for (i = 0; i < vodtArray.length; ++i) {
                if (!vodtArray[i].getType().equals(USER_MAP_NAME)) continue;
                this.vodMap.remove((Object)vodtArray[i].getVodId());
                this.db.commit();
            }
            File[] listOfFiles = userfile.listFiles();
            if (listOfFiles != null) {
                for (File file : listOfFiles) {
                    String fileExtension = FilenameUtils.getExtension((String)file.getName());
                    if (!file.isFile() || !fileExtension.equals("mp4") && !fileExtension.equals("flv") && !fileExtension.equals("mkv")) continue;
                    long fileSize = file.length();
                    long unixTime = System.currentTimeMillis();
                    String path = file.getPath();
                    String[] subDirs = path.split(Pattern.quote(File.separator));
                    Integer pathLength = subDirs.length;
                    String relativePath = subDirs[pathLength - 3] + '/' + subDirs[pathLength - 2] + '/' + subDirs[pathLength - 1];
                    String vodId = RandomStringUtils.randomNumeric((int)24);
                    Vod newVod = new Vod("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, fileSize, USER_MAP_NAME, vodId);
                    this.addUserVod(newVod);
                    ++numberOfSavedFiles;
                }
            }
        }
        return numberOfSavedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSourceQuality(String id, String quality) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setQuality(quality);
                String jsonVal = this.gson.toJson((Object)broadcast);
                String previousValue = (String)this.map.replace((Object)id, (Object)jsonVal);
                this.db.commit();
                logger.debug("updateSourceQuality replacing id {} having value {} to {} and the fetched value {}", new Object[]{id, previousValue, jsonVal, jsonString});
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateSourceSpeed(String id, double speed) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.map.get((Object)id)) != null) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(jsonString, Broadcast.class);
                broadcast.setSpeed(speed);
                this.map.replace((Object)id, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
                if (credentials.getId() == null) {
                    String id = RandomStringUtils.randomAlphanumeric((int)6);
                    credentials.setId(id);
                    this.socialEndpointsCredentialsMap.put((Object)id, (Object)this.gson.toJson((Object)credentials));
                    this.db.commit();
                    addedCredential = credentials;
                } else if (this.socialEndpointsCredentialsMap.get((Object)credentials.getId()) != null) {
                    this.socialEndpointsCredentialsMap.put((Object)credentials.getId(), (Object)this.gson.toJson((Object)credentials));
                    this.db.commit();
                    addedCredential = credentials;
                }
            }
        }
        return addedCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        ArrayList<SocialEndpointCredentials> list = new ArrayList<SocialEndpointCredentials>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.socialEndpointsCredentialsMap.values();
            int t = 0;
            int itemCount = 0;
            if (size > 50) {
                size = 50;
            }
            if (offset < 0) {
                offset = 0;
            }
            for (String credentialString : values) {
                if (t < offset) {
                    ++t;
                    continue;
                }
                list.add((SocialEndpointCredentials)this.gson.fromJson(credentialString, SocialEndpointCredentials.class));
                if (++itemCount < size) continue;
                break;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSocialEndpointCredentials(String id) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            boolean bl = result = this.socialEndpointsCredentialsMap.remove((Object)id) != null;
            if (result) {
                this.db.commit();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        SocialEndpointCredentials credential = null;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.socialEndpointsCredentialsMap.get((Object)id)) != null) {
                credential = (SocialEndpointCredentials)this.gson.fromJson(jsonString, SocialEndpointCredentials.class);
            }
        }
        return credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBroadcastNumber() {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            return this.getMap().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActiveBroadcastCount() {
        int activeBroadcastCount = 0;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Collection values = this.map.values();
            for (String broadcastString : values) {
                Broadcast broadcast = (Broadcast)this.gson.fromJson(broadcastString, Broadcast.class);
                String status = broadcast.getStatus();
                if (status == null || !status.equals("broadcasting")) continue;
                ++activeBroadcastCount;
            }
        }
        return activeBroadcastCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                if (detectedObjects != null) {
                    for (TensorFlowObject tensorFlowObject : detectedObjects) {
                        tensorFlowObject.setDetectionTime(timeElapsed);
                    }
                    this.detectionMap.put((Object)id, (Object)this.gson.toJson(detectedObjects));
                    this.db.commit();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetection(String id) {
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            String jsonString;
            if (id != null && (jsonString = (String)this.detectionMap.get((Object)id)) != null) {
                Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
                return (List)this.gson.fromJson(jsonString, listType);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Type listType = new TypeToken<ArrayList<TensorFlowObject>>(){}.getType();
            int offsetCount = 0;
            int batchCount = 0;
            Iterator keyIterator = this.detectionMap.keyIterator();
            while (keyIterator.hasNext()) {
                String keyValue = (String)keyIterator.next();
                if (!keyValue.startsWith(idFilter)) continue;
                if (offsetCount < offsetSize) {
                    ++offsetCount;
                    continue;
                }
                if (batchCount > batchSize) break;
                ++batchCount;
                List detectedList = (List)this.gson.fromJson((String)this.detectionMap.get((Object)keyValue), listType);
                list.addAll(detectedList);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editStreamSourceInfo(Broadcast broadcast) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            try {
                logger.debug("inside of editStreamSourceInfo {}", (Object)broadcast.getStreamId());
                Broadcast oldBroadcast = this.get(broadcast.getStreamId());
                oldBroadcast.setName(broadcast.getName());
                oldBroadcast.setUsername(broadcast.getUsername());
                oldBroadcast.setPassword(broadcast.getPassword());
                oldBroadcast.setIpAddr(broadcast.getIpAddr());
                oldBroadcast.setStreamUrl(broadcast.getStreamUrl());
                oldBroadcast.setStreamUrl(broadcast.getStreamUrl());
                this.getMap().replace((Object)oldBroadcast.getStreamId(), (Object)this.gson.toJson((Object)oldBroadcast));
                this.db.commit();
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        }
        logger.debug("result inside edit camera:{} ", (Object)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateHLSViewerCount(String streamId, int viewerCount) {
        boolean result = false;
        MapDBStore mapDBStore = this;
        synchronized (mapDBStore) {
            Broadcast broadcast;
            if (streamId != null && (broadcast = this.get(streamId)) != null) {
                broadcast.setHlsViewerCount(viewerCount);
                this.map.replace((Object)streamId, (Object)this.gson.toJson((Object)broadcast));
                this.db.commit();
                result = true;
            }
        }
        return result;
    }
}

