/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.ipcamera.utils;

import com.google.gson.Gson;
import io.antmedia.ipcamera.utils.Camera;
import io.antmedia.ipcamera.utils.ICameraStore;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraStore
implements ICameraStore {
    public static final String CAMERA_STORAGE_FILE = "camera.db";
    public static final String CAMERA_STORAGE_MAP_NAME = "camera_map";
    private DB db;
    private HTreeMap<String, String> map;
    private Gson gson;
    protected static Logger logger = LoggerFactory.getLogger(CameraStore.class);

    @Override
    public boolean addCamera(String name, String ipAddr, String username, String password, String rtspUrl) {
        boolean result = false;
        try {
            Camera camera = new Camera(name, ipAddr, username, password, rtspUrl);
            this.map.put((Object)ipAddr, (Object)this.gson.toJson((Object)camera));
            this.db.commit();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean editCameraInfo(String name, String ipAddr, String username, String password, String rtspUrl) {
        boolean result = false;
        try {
            logger.warn("inside of editCameraInfo");
            Camera camera = new Camera(name, ipAddr, username, password, rtspUrl);
            this.map.replace((Object)ipAddr, (Object)this.gson.toJson((Object)camera));
            this.db.commit();
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean deleteCamera(String ipAddr) {
        boolean result = false;
        try {
            if (this.map.containsKey((Object)ipAddr)) {
                logger.warn("inside of deleteCamera");
                this.map.remove((Object)ipAddr);
                this.db.commit();
                result = true;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public Camera getCamera(String ip) {
        if (this.map.containsKey((Object)ip)) {
            return (Camera)this.gson.fromJson((String)this.map.get((Object)ip), Camera.class);
        }
        return null;
    }

    @Override
    public Camera[] getCameraList() {
        Object[] objectArray = this.map.getValues().toArray();
        Camera[] cameraArray = new Camera[objectArray.length];
        for (int i = 0; i < cameraArray.length; ++i) {
            cameraArray[i] = (Camera)this.gson.fromJson((String)objectArray[i], Camera.class);
        }
        return cameraArray;
    }

    @Override
    public void close() {
        this.db.close();
    }
}

