/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rest;

import io.antmedia.AntMediaApplicationAdapter;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.MapDBStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.ipcamera.OnvifCamera;
import io.antmedia.ipcamera.onvifdiscovery.OnvifDiscovery;
import io.antmedia.rest.model.Result;
import io.antmedia.streamsource.StreamFetcher;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Component
@Path(value="/streamSource")
public class StreamsSourceRestService {
    @Context
    private ServletContext servletContext;
    private IDataStore dbStore;
    private ApplicationContext appCtx;
    private IScope scope;
    private AntMediaApplicationAdapter appInstance;
    protected static Logger logger = LoggerFactory.getLogger(StreamsSourceRestService.class);

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/addStreamSource")
    @Produces(value={"application/json"})
    public Result addStreamSource(Broadcast stream) {
        Result result = new Result(false);
        logger.info("username {}", (Object)stream.getUsername());
        logger.info("pass {}", (Object)stream.getPassword());
        if (stream.getName() != null && stream.getName().length() > 0 && this.checkStreamUrl(stream.getStreamUrl())) {
            if (stream.getType().equals("ipCamera")) {
                OnvifCamera onvif = new OnvifCamera();
                onvif.connect(stream.getIpAddr(), stream.getUsername(), stream.getPassword());
                String rtspURL = onvif.getRTSPStreamURI();
                if (rtspURL != "no") {
                    String authparam = stream.getUsername() + ":" + stream.getPassword() + "@";
                    String rtspURLWithAuth = "rtsp://" + authparam + rtspURL.substring("rtsp://".length());
                    logger.info("rtsp url with auth: {}", (Object)rtspURLWithAuth);
                    stream.setStreamUrl(rtspURLWithAuth);
                    Date currentDate = new Date();
                    long unixTime = currentDate.getTime();
                    stream.setDate(Long.valueOf(unixTime));
                    stream.setStatus("created");
                    String id = this.getStore().save(stream);
                    if (id.length() > 0) {
                        Broadcast newCam = this.getStore().get(stream.getStreamId());
                        StreamFetcher streamFetcher = this.getInstance().startStreaming(newCam);
                        if (streamFetcher != null) {
                            result.setSuccess(true);
                        } else {
                            this.getStore().delete(stream.getStreamId());
                        }
                    }
                    onvif.disconnect();
                }
            } else if (stream.getType().equals("streamSource")) {
                Date currentDate = new Date();
                long unixTime = currentDate.getTime();
                stream.setDate(Long.valueOf(unixTime));
                stream.setStatus("created");
                String id = this.getStore().save(stream);
                if (id.length() > 0) {
                    Broadcast newSource = this.getStore().get(stream.getStreamId());
                    this.getInstance().startStreaming(newSource);
                }
                result.setSuccess(true);
                result.setMessage(id);
            } else {
                result.setMessage("No stream added");
            }
        }
        return result;
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/getCameraError")
    @Produces(value={"application/json"})
    public Result getCameraError(@QueryParam(value="id") String id) {
        Result result = new Result(true);
        for (StreamFetcher camScheduler : this.getInstance().getStreamFetcherManager().getStreamFetcherList()) {
            if (!camScheduler.getStream().getIpAddr().equals(id)) continue;
            result = camScheduler.getCameraError();
        }
        return result;
    }

    @GET
    @Path(value="/synchUserVoDList")
    @Produces(value={"application/json"})
    public Result synchUserVodList() {
        boolean result = false;
        int errorId = -1;
        String message = "";
        String vodFolder = this.getInstance().getAppSettings().getVodFolder();
        logger.info("synch user vod list vod folder is {}", (Object)vodFolder);
        if (vodFolder != null && vodFolder.length() > 0) {
            result = this.getInstance().synchUserVoDFolder(null, vodFolder);
        } else {
            errorId = 404;
            message = "no vod folder defined";
        }
        return new Result(result, message, errorId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/updateCamInfo")
    @Produces(value={"application/json"})
    public Result updateCamInfo(Broadcast broadcast) {
        boolean result = false;
        OnvifCamera onvif = null;
        logger.warn("inside of rest service");
        if (this.checkStreamUrl(broadcast.getStreamUrl()) && broadcast.getStatus() != null) {
            this.getInstance().stopStreaming(broadcast);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
            if (broadcast.getType().equals("ipCamera")) {
                onvif = new OnvifCamera();
                onvif.connect(broadcast.getIpAddr(), broadcast.getUsername(), broadcast.getPassword());
                String rtspURL = onvif.getRTSPStreamURI();
                if (rtspURL != "no") {
                    String authparam = broadcast.getUsername() + ":" + broadcast.getPassword() + "@";
                    String rtspURLWithAuth = "rtsp://" + authparam + rtspURL.substring("rtsp://".length());
                    logger.info("new RTSP URL: {}", (Object)rtspURLWithAuth);
                    broadcast.setStreamUrl(rtspURLWithAuth);
                }
            }
            if (onvif != null) {
                onvif.disconnect();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
                Thread.currentThread().interrupt();
            }
            result = this.getStore().editStreamSourceInfo(broadcast);
            this.getInstance().startStreaming(broadcast);
        }
        return new Result(result);
    }

    @GET
    @Path(value="/searchOnvifDevices")
    @Produces(value={"application/json"})
    public String[] searchOnvifDevices() {
        String localIP = null;
        String[] list = null;
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements() && (localIP == null || localIP.isEmpty())) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || !address.isSiteLocalAddress()) continue;
                    localIP = address.getHostAddress();
                }
            }
            logger.warn("IP Address: {} ", (Object)localIP);
        }
        if (localIP != null) {
            String[] ipAddrParts = localIP.split("\\.");
            String ipAd = ipAddrParts[0] + "." + ipAddrParts[1] + "." + ipAddrParts[2] + ".";
            logger.warn("inside of auto discovery ip Addr {}", (Object)ipAd);
            ArrayList<String> addressList = new ArrayList<String>();
            for (int i = 2; i < 255; ++i) {
                addressList.add(ipAd + i);
            }
            List<URL> onvifDevices = OnvifDiscovery.discoverOnvifDevices(true, addressList);
            list = new String[onvifDevices.size()];
            if (!onvifDevices.isEmpty()) {
                for (int i = 0; i < onvifDevices.size(); ++i) {
                    list[i] = StringUtils.substringBetween((String)onvifDevices.get(i).toString(), (String)"http://", (String)"/");
                }
            }
        }
        return list;
    }

    @GET
    @Path(value="/moveUp")
    @Produces(value={"application/json"})
    public Result moveUp(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveUp();
            result = true;
        }
        return new Result(result);
    }

    @GET
    @Path(value="/moveDown")
    @Produces(value={"application/json"})
    public Result moveDown(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveDown();
            result = true;
        }
        return new Result(result);
    }

    @GET
    @Path(value="/moveLeft")
    @Produces(value={"application/json"})
    public Result moveLeft(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveLeft();
            result = true;
        }
        return new Result(result);
    }

    @GET
    @Path(value="/moveRight")
    @Produces(value={"application/json"})
    public Result moveRight(@QueryParam(value="id") String id) {
        boolean result = false;
        OnvifCamera camera = this.getInstance().getOnvifCamera(id);
        if (camera != null) {
            camera.MoveRight();
            result = true;
        }
        return new Result(result);
    }

    @Nullable
    private ApplicationContext getAppContext() {
        if (this.servletContext != null) {
            this.appCtx = (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        return this.appCtx;
    }

    public AntMediaApplicationAdapter getInstance() {
        if (this.appInstance == null) {
            this.appInstance = (AntMediaApplicationAdapter)this.getAppContext().getBean("web.handler");
        }
        return this.appInstance;
    }

    public IScope getScope() {
        if (this.scope == null) {
            this.scope = this.getInstance().getScope();
        }
        return this.scope;
    }

    public IDataStore getStore() {
        if (this.dbStore == null) {
            WebApplicationContext ctxt = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.servletContext);
            this.dbStore = (IDataStore)ctxt.getBean("db.datastore");
        }
        return this.dbStore;
    }

    public void setCameraStore(MapDBStore cameraStore) {
        this.dbStore = cameraStore;
    }

    public boolean validateIPaddress(String ipaddress) {
        String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
        Pattern pattern = Pattern.compile("(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))");
        return pattern.matcher(ipaddress).matches();
    }

    public boolean checkStreamUrl(String url) {
        logger.info("inside check url {}", (Object)url);
        boolean streamUrlControl = false;
        String[] ipAddrParts = null;
        String ipAddr = null;
        if (url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("rtmp://") || url.startsWith("rtmps://") || url.startsWith("rtsp://"))) {
            streamUrlControl = true;
            ipAddrParts = url.split("//");
            ipAddr = ipAddrParts[1];
            if (ipAddr.contains("@")) {
                ipAddrParts = ipAddr.split("@");
                ipAddr = ipAddrParts[1];
            }
            if (ipAddr.contains(":")) {
                ipAddrParts = ipAddr.split(":");
                ipAddr = ipAddrParts[0];
            }
            if (ipAddr.contains("/")) {
                ipAddrParts = ipAddr.split("/");
                ipAddr = ipAddrParts[0];
            }
            if (ipAddr.split(".").length == 4 && !this.validateIPaddress(ipAddr)) {
                streamUrlControl = false;
            }
        }
        return streamUrlControl;
    }
}

