/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.streamsource;

import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.streamsource.StreamFetcher;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.red5.server.api.scheduling.IScheduledJob;
import org.red5.server.api.scheduling.ISchedulingService;
import org.red5.server.api.scope.IScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamFetcherManager {
    protected static Logger logger = LoggerFactory.getLogger(StreamFetcherManager.class);
    private int streamCheckerCount = 0;
    private Queue<StreamFetcher> streamFetcherList = new ConcurrentLinkedQueue<StreamFetcher>();
    private int streamCheckerIntervalMs = 10000;
    private ISchedulingService schedulingService;
    private IDataStore datastore;
    private IScope scope;
    private String streamFetcherScheduleJobName;
    protected AtomicBoolean isJobRunning = new AtomicBoolean(false);
    private boolean restartStreamAutomatically = true;
    private StreamFetcherFactory streamFetcherFactory;
    private int restartStreamFetcherPeriodSeconds;

    public StreamFetcherManager(ISchedulingService schedulingService, IDataStore datastore, IScope scope) {
        this(schedulingService, datastore, scope, null);
    }

    public StreamFetcherManager(ISchedulingService schedulingService, IDataStore datastore, IScope scope, StreamFetcherFactory streamFetcherFactory) {
        this.schedulingService = schedulingService;
        this.datastore = datastore;
        this.scope = scope;
        this.streamFetcherFactory = streamFetcherFactory;
        if (this.streamFetcherFactory == null) {
            this.streamFetcherFactory = new StreamFetcherFactory();
        }
    }

    public int getStreamCheckerInterval() {
        return this.streamCheckerIntervalMs;
    }

    public void setStreamCheckerInterval(int streamCheckerInterval) {
        this.streamCheckerIntervalMs = streamCheckerInterval;
    }

    public void setRestartStreamFetcherPeriod(int restartStreamFetcherPeriod) {
        this.restartStreamFetcherPeriodSeconds = restartStreamFetcherPeriod;
    }

    public StreamFetcher startStreaming(Broadcast broadcast) {
        StreamFetcher streamScheduler = null;
        try {
            streamScheduler = this.streamFetcherFactory.make(broadcast, this.scope, this.schedulingService);
            streamScheduler.setRestartStream(this.restartStreamAutomatically);
            streamScheduler.startStream();
            this.streamFetcherList.add(streamScheduler);
            if (this.streamFetcherScheduleJobName == null) {
                this.scheduleStreamFetcherJob();
            }
        }
        catch (Exception e) {
            streamScheduler = null;
            logger.error(e.getMessage());
        }
        return streamScheduler;
    }

    public StreamFetcher stopStreaming(Broadcast stream) {
        logger.warn("inside of stopStreaming for {}", (Object)stream.getStreamId());
        StreamFetcher streamScheduler = null;
        for (StreamFetcher scheduler : this.streamFetcherList) {
            if (!scheduler.getStream().getStreamId().equals(stream.getStreamId())) continue;
            scheduler.stopStream();
            this.streamFetcherList.remove(scheduler);
            streamScheduler = scheduler;
            break;
        }
        return streamScheduler;
    }

    public void stopCheckerJob() {
        if (this.streamFetcherScheduleJobName != null) {
            this.schedulingService.removeScheduledJob(this.streamFetcherScheduleJobName);
            this.streamFetcherScheduleJobName = null;
        }
    }

    public void startStreams(List<Broadcast> streams) {
        for (int i = 0; i < streams.size(); ++i) {
            this.startStreaming(streams.get(i));
        }
        this.scheduleStreamFetcherJob();
    }

    private void scheduleStreamFetcherJob() {
        if (this.streamFetcherScheduleJobName != null) {
            this.schedulingService.removeScheduledJob(this.streamFetcherScheduleJobName);
        }
        this.streamFetcherScheduleJobName = this.schedulingService.addScheduledJobAfterDelay(this.streamCheckerIntervalMs, new IScheduledJob(){
            private int lastRestartCount = 0;

            public void execute(ISchedulingService service) throws CloneNotSupportedException {
                if (!StreamFetcherManager.this.streamFetcherList.isEmpty()) {
                    StreamFetcherManager.this.streamCheckerCount++;
                    logger.warn("StreamFetcher Check Count:{}", (Object)StreamFetcherManager.this.streamCheckerCount);
                    int countToRestart = 0;
                    if (StreamFetcherManager.this.restartStreamFetcherPeriodSeconds > 0) {
                        int streamCheckIntervalSec = StreamFetcherManager.this.streamCheckerIntervalMs / 1000;
                        countToRestart = StreamFetcherManager.this.streamCheckerCount * streamCheckIntervalSec / StreamFetcherManager.this.restartStreamFetcherPeriodSeconds;
                    }
                    if (countToRestart > this.lastRestartCount) {
                        this.lastRestartCount = countToRestart;
                        logger.info("This is {} times that restarting streams", (Object)this.lastRestartCount);
                        StreamFetcherManager.this.restartStreamFetchers();
                    } else {
                        StreamFetcherManager.this.checkStreamFetchersStatus();
                    }
                }
            }
        }, this.streamCheckerIntervalMs);
        logger.info("StreamFetcherSchedule job name {}", (Object)this.streamFetcherScheduleJobName);
    }

    public void checkStreamFetchersStatus() {
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            Broadcast stream = streamScheduler.getStream();
            if (streamScheduler.isStreamAlive() || this.datastore == null || stream.getStreamId() == null) continue;
            logger.info("Updating stream quality to poor of stream {}", (Object)stream.getStreamId());
            this.datastore.updateSourceQuality(stream.getStreamId(), "poor");
            this.datastore.updateSourceSpeed(stream.getStreamId(), 0.0);
        }
    }

    public void restartStreamFetchers() {
        for (StreamFetcher streamScheduler : this.streamFetcherList) {
            if (streamScheduler.isStreamAlive()) {
                logger.info("Calling stop stream {}", (Object)streamScheduler.getStream().getStreamId());
                streamScheduler.stopStream();
            } else {
                logger.info("Stream is not alive {}", (Object)streamScheduler.getStream().getStreamId());
            }
            streamScheduler.startStream();
        }
    }

    public IDataStore getDatastore() {
        return this.datastore;
    }

    public void setDatastore(IDataStore datastore) {
        this.datastore = datastore;
    }

    public Queue<StreamFetcher> getStreamFetcherList() {
        return this.streamFetcherList;
    }

    public void setStreamFetcherList(Queue<StreamFetcher> streamFetcherList) {
        this.streamFetcherList = streamFetcherList;
    }

    public boolean isRestartStreamAutomatically() {
        return this.restartStreamAutomatically;
    }

    public void setRestartStreamAutomatically(boolean restartStreamAutomatically) {
        this.restartStreamAutomatically = restartStreamAutomatically;
    }

    public int getStreamCheckerCount() {
        return this.streamCheckerCount;
    }

    public void setStreamCheckerCount(int streamCheckerCount) {
        this.streamCheckerCount = streamCheckerCount;
    }

    public static class StreamFetcherFactory {
        public StreamFetcher make(Broadcast stream, IScope scope, ISchedulingService schedulingService) {
            return new StreamFetcher(stream, scope, schedulingService);
        }
    }
}

