/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.webrtc.adaptor;

import io.antmedia.recorder.FFmpegFrameRecorder;
import io.antmedia.recorder.Frame;
import io.antmedia.recorder.FrameRecorder;
import io.antmedia.webrtc.adaptor.Adaptor;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONObject;
import org.webrtc.AudioSink;
import org.webrtc.AudioTrack;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.SessionDescription;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoTrack;

public class RTMPAdaptor
extends Adaptor {
    FFmpegFrameRecorder recorder;
    protected long startTime;
    private ExecutorService videoEncoderExecutor;
    private ExecutorService audioEncoderExecutor;
    private volatile boolean isStopped = false;
    private ExecutorService signallingExecutor;
    public static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";

    public RTMPAdaptor(FFmpegFrameRecorder recorder) {
        this.recorder = recorder;
        this.setSdpMediaConstraints(new MediaConstraints());
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        this.getSdpMediaConstraints().mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
    }

    public static PeerConnectionFactory createPeerConnectionFactory() {
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        options.networkIgnoreMask = 0;
        return new PeerConnectionFactory(options);
    }

    @Override
    public void start() {
        this.videoEncoderExecutor = Executors.newSingleThreadExecutor();
        this.audioEncoderExecutor = Executors.newSingleThreadExecutor();
        this.signallingExecutor = Executors.newSingleThreadExecutor();
        this.signallingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
                iceServers.add(new PeerConnection.IceServer("stun:stun.l.google.com:19302"));
                PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
                MediaConstraints pcConstraints = new MediaConstraints();
                pcConstraints.optional.add(new MediaConstraints.KeyValuePair(RTMPAdaptor.DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT, "true"));
                RTMPAdaptor.this.peerConnectionFactory = RTMPAdaptor.createPeerConnectionFactory();
                RTMPAdaptor.this.peerConnection = RTMPAdaptor.this.peerConnectionFactory.createPeerConnection(rtcConfig, pcConstraints, (PeerConnection.Observer)RTMPAdaptor.this);
                try {
                    JSONObject jsonResponse = new JSONObject();
                    jsonResponse.put((Object)"command", (Object)"start");
                    RTMPAdaptor.this.getWsConnection().send(jsonResponse.toJSONString());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void stop() {
        if (this.isStopped) {
            return;
        }
        this.isStopped = true;
        this.signallingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put((Object)"command", (Object)"notification");
                jsonObject.put((Object)"definition", (Object)"publish_finished");
                try {
                    RTMPAdaptor.this.getWsConnection().send(jsonObject.toJSONString());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                RTMPAdaptor.this.audioEncoderExecutor.shutdownNow();
                RTMPAdaptor.this.videoEncoderExecutor.shutdownNow();
                try {
                    RTMPAdaptor.this.videoEncoderExecutor.awaitTermination(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    Thread.currentThread().interrupt();
                }
                try {
                    if (RTMPAdaptor.this.peerConnection != null) {
                        RTMPAdaptor.this.peerConnection.close();
                        RTMPAdaptor.this.recorder.stop();
                        RTMPAdaptor.this.peerConnection.dispose();
                        RTMPAdaptor.this.peerConnectionFactory.dispose();
                        RTMPAdaptor.this.peerConnection = null;
                    }
                }
                catch (FrameRecorder.Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.signallingExecutor.shutdown();
    }

    @Override
    public void onAddStream(MediaStream stream) {
        VideoTrack videoTrack;
        AudioTrack audioTrack;
        log.warn("onAddStream");
        if (stream.getAudioTracks().size() > 0 && (audioTrack = stream.getAudioTracks().getFirst()) != null) {
            audioTrack.addSink(new AudioSink(){
                private int audioFrameCount = 0;

                @Override
                public void onData(byte[] audio_data, int bits_per_sample, final int sample_rate, final int number_of_channels, final int number_of_frames) {
                    final ByteBuffer tempAudioBuffer = ByteBuffer.wrap(audio_data);
                    if (RTMPAdaptor.this.startTime == 0L) {
                        RTMPAdaptor.this.startTime = System.currentTimeMillis();
                    }
                    if (RTMPAdaptor.this.audioEncoderExecutor == null || RTMPAdaptor.this.audioEncoderExecutor.isShutdown()) {
                        return;
                    }
                    ++this.audioFrameCount;
                    if (bits_per_sample == 16) {
                        RTMPAdaptor.this.audioEncoderExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                long timeDiff = (System.currentTimeMillis() - RTMPAdaptor.this.startTime) * 1000L;
                                short[] data = new short[number_of_frames * number_of_channels];
                                tempAudioBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(data, 0, data.length);
                                ShortBuffer audioBuffer = ShortBuffer.wrap(data);
                                try {
                                    boolean result = RTMPAdaptor.this.recorder.recordSamples(sample_rate, number_of_channels, timeDiff, new Buffer[]{audioBuffer});
                                    if (!result) {
                                        System.out.println("could not audio sample");
                                    }
                                }
                                catch (FrameRecorder.Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                    }
                }
            });
        }
        if (stream.getVideoTracks().size() > 0 && (videoTrack = stream.getVideoTracks().getFirst()) != null) {
            videoTrack.addRenderer(new VideoRenderer(new VideoRenderer.Callbacks(){
                private int frameCount;

                @Override
                public void renderFrame(final VideoRenderer.I420Frame frame) {
                    if (RTMPAdaptor.this.startTime == 0L) {
                        RTMPAdaptor.this.startTime = System.currentTimeMillis();
                    }
                    if (RTMPAdaptor.this.videoEncoderExecutor == null || RTMPAdaptor.this.videoEncoderExecutor.isShutdown()) {
                        VideoRenderer.renderFrameDone(frame);
                        return;
                    }
                    ++this.frameCount;
                    RTMPAdaptor.this.videoEncoderExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            long pts = (System.currentTimeMillis() - RTMPAdaptor.this.startTime) * 1000L;
                            Frame frameCV = new Frame(frame.width, frame.height, 8, 2);
                            ((ByteBuffer)frameCV.image[0].position(0)).put(frame.yuvPlanes[0]);
                            ((ByteBuffer)frameCV.image[0]).put(frame.yuvPlanes[1]);
                            ((ByteBuffer)frameCV.image[0]).put(frame.yuvPlanes[2]);
                            try {
                                RTMPAdaptor.this.recorder.recordImage(frameCV.imageWidth, frameCV.imageHeight, frameCV.imageDepth, frameCV.imageChannels, frameCV.imageStride, 0, pts, frameCV.image);
                            }
                            catch (FrameRecorder.Exception e) {
                                e.printStackTrace();
                            }
                            VideoRenderer.renderFrameDone(frame);
                        }
                    });
                }
            }));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"command", (Object)"notification");
        jsonObject.put((Object)"definition", (Object)"publish_started");
        try {
            this.getWsConnection().send(jsonObject.toJSONString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSetSuccess() {
        this.peerConnection.createAnswer(this, this.getSdpMediaConstraints());
    }

    public void setRemoteDescription(final SessionDescription sdp) {
        this.signallingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                RTMPAdaptor.this.peerConnection.setRemoteDescription(RTMPAdaptor.this, sdp);
            }
        });
    }

    public void addIceCandidate(final IceCandidate iceCandidate) {
        this.signallingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!RTMPAdaptor.this.peerConnection.addIceCandidate(iceCandidate)) {
                    Adaptor.log.error("Add ice candidate failed");
                }
            }
        });
    }
}

