/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.datastore.DBReader;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.IDataStoreFactory;
import io.antmedia.datastore.db.InMemoryDataStore;
import io.antmedia.datastore.db.MapDBStore;
import io.antmedia.datastore.db.MongoStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreFactory
implements IDataStoreFactory {
    private static Logger logger = LoggerFactory.getLogger(DataStoreFactory.class);
    private IDataStore dataStore;
    private String appName;
    private String dbName;
    private String dbType;
    private String dbHost;
    private String dbUser;
    private String dbPassword;

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDbHost() {
        return this.dbHost;
    }

    public void setDbHost(String dbHost) {
        this.dbHost = dbHost;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public IDataStore getDataStore() {
        if (this.dataStore == null) {
            if (this.dbType.contentEquals("mongodb")) {
                this.dataStore = new MongoStore(this.dbName, this.dbHost);
            } else if (this.dbType.contentEquals("mapdb")) {
                this.dataStore = new MapDBStore(this.dbName + ".db");
            } else if (this.dbType.contentEquals("memorydb")) {
                this.dataStore = new InMemoryDataStore("dbName");
            } else {
                logger.error("Undefined Datastore:{} app:{} db name:{}", new Object[]{this.dbType, this.appName, this.dbName});
            }
            logger.info("Used Datastore:{} app:{} db name:{}", new Object[]{this.dbType, this.appName, this.dbName});
            DBReader.instance.addDataStore(this.appName, this.dataStore);
        }
        return this.dataStore;
    }

    public void setDataStore(IDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

