/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.datastore.db;

import io.antmedia.cluster.StreamInfo;
import io.antmedia.datastore.db.IDataStore;
import io.antmedia.datastore.db.types.Broadcast;
import io.antmedia.datastore.db.types.Endpoint;
import io.antmedia.datastore.db.types.SocialEndpointCredentials;
import io.antmedia.datastore.db.types.TensorFlowObject;
import io.antmedia.datastore.db.types.Token;
import io.antmedia.datastore.db.types.VoD;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDataStore
implements IDataStore {
    protected static Logger logger = LoggerFactory.getLogger(InMemoryDataStore.class);
    private Map<String, Broadcast> broadcastMap = new LinkedHashMap<String, Broadcast>();
    private Map<String, VoD> vodMap = new LinkedHashMap<String, VoD>();
    private Map<String, List<TensorFlowObject>> detectionMap = new LinkedHashMap<String, List<TensorFlowObject>>();
    private Map<String, SocialEndpointCredentials> socialEndpointCredentialsMap = new LinkedHashMap<String, SocialEndpointCredentials>();
    private Map<String, Token> tokenMap = new LinkedHashMap<String, Token>();

    public InMemoryDataStore(String dbName) {
    }

    public String save(Broadcast broadcast) {
        String streamId = null;
        if (broadcast != null) {
            try {
                if (broadcast.getStreamId() == null) {
                    streamId = RandomStringUtils.randomNumeric((int)24);
                    broadcast.setStreamId(streamId);
                }
                streamId = broadcast.getStreamId();
                String rtmpURL = broadcast.getRtmpURL();
                if (rtmpURL != null) {
                    rtmpURL = rtmpURL + streamId;
                }
                broadcast.setRtmpURL(rtmpURL);
                if (broadcast.getStatus() == null) {
                    broadcast.setStatus("created");
                }
                this.broadcastMap.put(streamId, broadcast);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                streamId = null;
            }
        }
        return streamId;
    }

    public Broadcast get(String id) {
        return this.broadcastMap.get(id);
    }

    public VoD getVoD(String id) {
        return this.vodMap.get(id);
    }

    public boolean updateName(String id, String name, String description) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setName(name);
            broadcast.setDescription(description);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updateStatus(String id, String status) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setStatus(status);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean updateDuration(String id, long duration) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            broadcast.setDuration(Long.valueOf(duration));
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean addEndpoint(String id, Endpoint endpoint) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null && endpoint != null) {
            ArrayList<Endpoint> endPointList = broadcast.getEndPointList();
            if (endPointList == null) {
                endPointList = new ArrayList<Endpoint>();
            }
            endPointList.add(endpoint);
            broadcast.setEndPointList(endPointList);
            this.broadcastMap.put(id, broadcast);
            result = true;
        }
        return result;
    }

    public boolean removeEndpoint(String id, Endpoint endpoint) {
        List endPointList;
        boolean result = false;
        Broadcast broadcast = this.broadcastMap.get(id);
        if (broadcast != null && endpoint != null && (endPointList = broadcast.getEndPointList()) != null) {
            Iterator iterator = endPointList.iterator();
            while (iterator.hasNext()) {
                Endpoint endpointItem = (Endpoint)iterator.next();
                if (!endpointItem.getRtmpUrl().equals(endpoint.getRtmpUrl())) continue;
                iterator.remove();
                result = true;
                break;
            }
        }
        return result;
    }

    public long getBroadcastCount() {
        return this.broadcastMap.size();
    }

    public long getActiveBroadcastCount() {
        Collection<Broadcast> values = this.broadcastMap.values();
        long activeBroadcastCount = 0L;
        for (Broadcast broadcast : values) {
            String status = broadcast.getStatus();
            if (status == null || !status.equals("broadcasting")) continue;
            ++activeBroadcastCount;
        }
        return activeBroadcastCount;
    }

    public boolean delete(String id) {
        Broadcast broadcast = this.broadcastMap.get(id);
        boolean result = false;
        if (broadcast != null) {
            this.broadcastMap.remove(id);
            result = true;
        }
        return result;
    }

    public List<Broadcast> getBroadcastList(int offset, int size) {
        Collection<Broadcast> values = this.broadcastMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(broadcast);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public List<Broadcast> getExternalStreamsList() {
        Collection<Broadcast> values = this.broadcastMap.values();
        ArrayList<Broadcast> streamsList = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            String type = broadcast.getType();
            if (!type.equals("ipCamera") && !type.equals("streamSource")) continue;
            streamsList.add(broadcast);
        }
        return streamsList;
    }

    public void close() {
    }

    public List<Broadcast> filterBroadcastList(int offset, int size, String type) {
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        Collection<Broadcast> values = this.broadcastMap.values();
        ArrayList<Broadcast> list = new ArrayList<Broadcast>();
        for (Broadcast broadcast : values) {
            if (!broadcast.getType().equals("ipCamera")) continue;
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(broadcast);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public String addVod(VoD vod) {
        String id = null;
        boolean result = false;
        if (vod != null) {
            try {
                if (vod.getVodId() == null) {
                    vod.setVodId(RandomStringUtils.randomNumeric((int)24));
                }
                this.vodMap.put(vod.getVodId(), vod);
                result = true;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if (result) {
            id = vod.getVodId();
        }
        return id;
    }

    public List<VoD> getVodList(int offset, int size) {
        Collection<VoD> values = this.vodMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<VoD> list = new ArrayList<VoD>();
        for (VoD vodString : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(vodString);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean deleteVod(String id) {
        return this.vodMap.remove(id) != null;
    }

    public boolean removeAllEndpoints(String id) {
        boolean result = false;
        Broadcast broadcast = this.broadcastMap.get(id);
        if (broadcast != null) {
            broadcast.setEndPointList(null);
            this.broadcastMap.replace(id, broadcast);
            result = true;
        }
        return result;
    }

    public long getTotalVodNumber() {
        return this.vodMap.size();
    }

    public int fetchUserVodList(File userfile) {
        if (userfile == null) {
            return 0;
        }
        int numberOfSavedFiles = 0;
        Collection<VoD> vodCollection = this.vodMap.values();
        Iterator<VoD> iterator = vodCollection.iterator();
        while (iterator.hasNext()) {
            VoD vod = iterator.next();
            if (!vod.getType().equals("userVod")) continue;
            iterator.remove();
        }
        File[] listOfFiles = userfile.listFiles();
        if (listOfFiles != null) {
            for (File file : listOfFiles) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                if (!file.isFile() || !fileExtension.equals("mp4") && !fileExtension.equals("flv") && !fileExtension.equals("mkv")) continue;
                long fileSize = file.length();
                long unixTime = System.currentTimeMillis();
                String filePath = file.getPath();
                String[] subDirs = filePath.split(Pattern.quote(File.separator));
                String relativePath = "streams/" + subDirs[subDirs.length - 2] + '/' + subDirs[subDirs.length - 1];
                String vodId = RandomStringUtils.randomNumeric((int)24);
                VoD newVod = new VoD("vodFile", "vodFile", relativePath, file.getName(), unixTime, 0L, fileSize, "userVod", vodId);
                this.addVod(newVod);
                ++numberOfSavedFiles;
            }
        }
        return numberOfSavedFiles;
    }

    public boolean updateSourceQualityParameters(String id, String quality, double speed, int pendingPacketSize) {
        Broadcast broadcast;
        boolean result = false;
        if (id != null && (broadcast = this.broadcastMap.get(id)) != null) {
            broadcast.setQuality(quality);
            broadcast.setSpeed(speed);
            broadcast.setPendingPacketSize(pendingPacketSize);
            this.broadcastMap.replace(id, broadcast);
            result = true;
        }
        return result;
    }

    public SocialEndpointCredentials addSocialEndpointCredentials(SocialEndpointCredentials credentials) {
        SocialEndpointCredentials addedCredential = null;
        if (credentials != null && credentials.getAccountName() != null && credentials.getAccessToken() != null && credentials.getServiceName() != null) {
            if (credentials.getId() == null) {
                String id = RandomStringUtils.randomAlphanumeric((int)6);
                credentials.setId(id);
                this.socialEndpointCredentialsMap.put(id, credentials);
                addedCredential = credentials;
            } else if (this.socialEndpointCredentialsMap.get(credentials.getId()) != null) {
                this.socialEndpointCredentialsMap.put(credentials.getId(), credentials);
                addedCredential = credentials;
            }
        }
        return addedCredential;
    }

    public List<SocialEndpointCredentials> getSocialEndpoints(int offset, int size) {
        Collection<SocialEndpointCredentials> values = this.socialEndpointCredentialsMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        ArrayList<SocialEndpointCredentials> list = new ArrayList<SocialEndpointCredentials>();
        for (SocialEndpointCredentials credential : values) {
            if (t < offset) {
                ++t;
                continue;
            }
            list.add(credential);
            if (++itemCount < size) continue;
            break;
        }
        return list;
    }

    public boolean removeSocialEndpointCredentials(String id) {
        return this.socialEndpointCredentialsMap.remove(id) != null;
    }

    public SocialEndpointCredentials getSocialEndpointCredentials(String id) {
        SocialEndpointCredentials credential = null;
        if (id != null) {
            credential = this.socialEndpointCredentialsMap.get(id);
        }
        return credential;
    }

    public long getTotalBroadcastNumber() {
        return this.broadcastMap.size();
    }

    public void saveDetection(String id, long timeElapsed, List<TensorFlowObject> detectedObjects) {
        if (detectedObjects != null) {
            for (TensorFlowObject tensorFlowObject : detectedObjects) {
                tensorFlowObject.setDetectionTime(timeElapsed);
            }
            this.detectionMap.put(id, detectedObjects);
        }
    }

    public List<TensorFlowObject> getDetectionList(String idFilter, int offsetSize, int batchSize) {
        int offsetCount = 0;
        int batchCount = 0;
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        Set<String> keySet = this.detectionMap.keySet();
        for (String keyValue : keySet) {
            if (!keyValue.startsWith(idFilter)) continue;
            if (offsetCount < offsetSize) {
                ++offsetCount;
                continue;
            }
            if (batchCount >= batchSize) break;
            List<TensorFlowObject> detectedList = this.detectionMap.get(keyValue);
            list.addAll(detectedList);
            batchCount = list.size();
        }
        return list;
    }

    public long getObjectDetectedTotal(String id) {
        ArrayList<TensorFlowObject> list = new ArrayList<TensorFlowObject>();
        Set<String> keySet = this.detectionMap.keySet();
        for (String keyValue : keySet) {
            if (!keyValue.startsWith(id)) continue;
            List<TensorFlowObject> detectedList = this.detectionMap.get(keyValue);
            list.addAll(detectedList);
        }
        return list.size();
    }

    public List<TensorFlowObject> getDetection(String id) {
        if (id != null) {
            List<TensorFlowObject> detectedObjects = this.detectionMap.get(id);
            return detectedObjects;
        }
        return null;
    }

    public boolean editStreamSourceInfo(Broadcast broadcast) {
        boolean result = false;
        try {
            logger.warn("inside of editCameraInfo");
            Broadcast oldBroadcast = this.get(broadcast.getStreamId());
            oldBroadcast.setName(broadcast.getName());
            oldBroadcast.setUsername(broadcast.getUsername());
            oldBroadcast.setPassword(broadcast.getPassword());
            oldBroadcast.setIpAddr(broadcast.getIpAddr());
            oldBroadcast.setStreamUrl(broadcast.getStreamUrl());
            this.broadcastMap.replace(oldBroadcast.getStreamId(), oldBroadcast);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public synchronized boolean updateHLSViewerCount(String streamId, int diffCount) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null) {
            int hlsViewerCount = broadcast.getHlsViewerCount();
            broadcast.setHlsViewerCount(hlsViewerCount += diffCount);
            this.broadcastMap.replace(streamId, broadcast);
            result = true;
        }
        return result;
    }

    public synchronized boolean updateWebRTCViewerCount(String streamId, boolean increment) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null) {
            int webRTCViewerCount = broadcast.getWebRTCViewerCount();
            webRTCViewerCount = increment ? ++webRTCViewerCount : --webRTCViewerCount;
            broadcast.setWebRTCViewerCount(webRTCViewerCount);
            this.broadcastMap.replace(streamId, broadcast);
            result = true;
        }
        return result;
    }

    public synchronized boolean updateRtmpViewerCount(String streamId, boolean increment) {
        Broadcast broadcast;
        boolean result = false;
        if (streamId != null && (broadcast = this.broadcastMap.get(streamId)) != null) {
            int rtmpViewerCount = broadcast.getRtmpViewerCount();
            rtmpViewerCount = increment ? ++rtmpViewerCount : --rtmpViewerCount;
            broadcast.setRtmpViewerCount(rtmpViewerCount);
            this.broadcastMap.replace(streamId, broadcast);
            result = true;
        }
        return result;
    }

    public Token createToken(String streamId, long expireDate, String type) {
        Token token = null;
        if (streamId != null) {
            token = new Token();
            token.setStreamId(streamId);
            token.setExpireDate(expireDate);
            token.setType(type);
            try {
                String tokenId = RandomStringUtils.randomNumeric((int)24);
                token.setTokenId(tokenId);
                this.tokenMap.put(tokenId, token);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return token;
    }

    public Token validateToken(Token token) {
        Token fetchedToken = null;
        if (token.getTokenId() != null) {
            fetchedToken = this.tokenMap.get(token.getTokenId());
            if (fetchedToken != null && fetchedToken.getStreamId().equals(token.getStreamId()) && fetchedToken.getType().equals(token.getType())) {
                this.tokenMap.remove(token.getTokenId());
                return fetchedToken;
            }
            fetchedToken = null;
        }
        return fetchedToken;
    }

    public boolean revokeTokens(String streamId) {
        boolean result = false;
        Collection<Token> tokenCollection = this.tokenMap.values();
        Iterator<Token> iterator = tokenCollection.iterator();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (token.getStreamId().equals(streamId)) {
                iterator.remove();
                this.tokenMap.remove(token.getTokenId());
            }
            result = true;
        }
        return result;
    }

    public List<Token> listAllTokens(String streamId, int offset, int size) {
        ArrayList<Token> list = new ArrayList<Token>();
        ArrayList<Token> returnList = new ArrayList<Token>();
        Collection<Token> values = this.tokenMap.values();
        int t = 0;
        int itemCount = 0;
        if (size > 50) {
            size = 50;
        }
        if (offset < 0) {
            offset = 0;
        }
        for (Token token : values) {
            if (!token.getStreamId().equals(streamId)) continue;
            list.add(token);
        }
        Iterator iterator = list.iterator();
        while (itemCount < size && iterator.hasNext()) {
            if (t < offset) {
                ++t;
                iterator.next();
                continue;
            }
            returnList.add((Token)iterator.next());
            ++itemCount;
        }
        return returnList;
    }

    public void addStreamInfoList(List<StreamInfo> streamInfoList) {
    }

    public List<StreamInfo> getStreamInfoList(String streamId) {
        return new ArrayList<StreamInfo>();
    }

    public void clearStreamInfoList(String streamId) {
    }
}

