/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.filter;

import io.antmedia.AppSettings;
import io.antmedia.security.TokenService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;

public class TokenFilter
implements Filter {
    protected static Logger logger = LoggerFactory.getLogger(TokenFilter.class);
    private FilterConfig filterConfig;
    private AppSettings settings;
    private TokenService tokenService;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = httpRequest.getMethod();
        String tokenId = ((HttpServletRequest)request).getParameter("token");
        String sessionId = httpRequest.getSession().getId();
        String streamId = TokenFilter.getStreamId(httpRequest.getRequestURI());
        String clientIP = httpRequest.getRemoteAddr();
        logger.info("Client IP: {}, request url:  {}, token:  {}, sessionId: {},streamId:  {} ", new Object[]{clientIP, httpRequest.getRequestURI(), tokenId, sessionId, streamId});
        if (method.equals("GET") && this.getAppSettings().isTokenControlEnabled()) {
            boolean result = this.getTokenService().checkToken(tokenId, streamId, sessionId, "play");
            if (!result) {
                httpResponse.sendError(403, "Invalid Token");
                logger.warn("token {} is not valid", (Object)tokenId);
                return;
            }
            chain.doFilter(request, response);
        } else {
            chain.doFilter((ServletRequest)httpRequest, response);
        }
    }

    public TokenService getTokenService() {
        if (this.tokenService == null) {
            ApplicationContext context = (ApplicationContext)this.filterConfig.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            this.tokenService = (TokenService)context.getBean("token.service");
        }
        return this.tokenService;
    }

    public AppSettings getAppSettings() {
        if (this.settings == null) {
            ApplicationContext context = (ApplicationContext)this.filterConfig.getServletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            this.settings = (AppSettings)context.getBean("app.settings");
        }
        return this.settings;
    }

    public static String getStreamId(String requestURI) {
        int startIndex = requestURI.lastIndexOf(47);
        if (requestURI.contains("_")) {
            return requestURI.split("_")[0].substring(startIndex + 1);
        }
        int endIndex = requestURI.lastIndexOf(".mp4");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        endIndex = requestURI.lastIndexOf("_adaptive.m3u8");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        String regex = "_[0-9]+p\\.m3u8$";
        if (requestURI.matches(regex)) {
            endIndex = requestURI.lastIndexOf(95);
            return requestURI.substring(startIndex + 1, endIndex);
        }
        endIndex = requestURI.lastIndexOf(".m3u8");
        if (endIndex != -1) {
            return requestURI.substring(startIndex + 1, endIndex);
        }
        return null;
    }

    public void destroy() {
    }
}

